/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SectionHierarchyProcessor
implements WebSiteModel {
    private static Log log = LogFactory.getLog(SectionHierarchyProcessor.class);
    private BehaviourFilter behaviourFilter;
    private NodeService nodeService;
    private DictionaryService dictionaryService;
    private SearchService searchService;
    private TransactionService transactionService;
    private boolean initialised = false;

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Set<NodeRef> affectedSections) {
        LinkedList<SectionAncestorRecord> sectionsToProcess = new LinkedList<SectionAncestorRecord>();
        for (NodeRef sectionId : affectedSections) {
            sectionsToProcess.add(new SectionAncestorRecord(sectionId, null));
        }
        HashSet<NodeRef> processedSections = new HashSet<NodeRef>(89);
        while (!sectionsToProcess.isEmpty()) {
            SectionAncestorRecord record = (SectionAncestorRecord)sectionsToProcess.remove(0);
            NodeRef currentSection = record.getSectionId();
            Set<NodeRef> thisSectionsAncestors = record.getAncestorSections();
            if (thisSectionsAncestors == null) {
                thisSectionsAncestors = new HashSet<NodeRef>();
                NodeRef sectionParent = this.nodeService.getPrimaryParent(currentSection).getParentRef();
                if (this.dictionaryService.isSubClass(this.nodeService.getType(sectionParent), WebSiteModel.TYPE_SECTION)) {
                    thisSectionsAncestors.add(sectionParent);
                    Collection ancestors = (Collection)((Object)this.nodeService.getProperty(sectionParent, PROP_ANCESTOR_SECTIONS));
                    if (ancestors != null) {
                        thisSectionsAncestors.addAll(ancestors);
                    }
                }
            }
            try {
                this.behaviourFilter.disableBehaviour(currentSection, TYPE_SECTION);
                this.behaviourFilter.disableBehaviour(currentSection, ContentModel.ASPECT_AUDITABLE);
                this.nodeService.setProperty(currentSection, PROP_ANCESTOR_SECTIONS, new ArrayList<NodeRef>(thisSectionsAncestors));
            }
            finally {
                this.behaviourFilter.enableBehaviour(currentSection, ContentModel.ASPECT_AUDITABLE);
                this.behaviourFilter.enableBehaviour(currentSection, TYPE_SECTION);
            }
            ArrayList<NodeRef> childrensAncestors = new ArrayList<NodeRef>(thisSectionsAncestors);
            childrensAncestors.add(currentSection);
            List childAssets = this.nodeService.getChildAssocsByPropertyValue(currentSection, PROP_PARENT_SECTIONS, (Serializable)currentSection);
            for (ChildAssociationRef childAssoc : childAssets) {
                this.processWebAssetsSections(childAssoc.getChildRef(), childrensAncestors);
            }
            HashSet sectionTypes = new HashSet(this.dictionaryService.getSubTypes(TYPE_SECTION, true));
            List subsections = this.nodeService.getChildAssocs(currentSection, sectionTypes);
            for (ChildAssociationRef subsection : subsections) {
                NodeRef child = subsection.getChildRef();
                if (processedSections.contains(child)) continue;
                sectionsToProcess.add(new SectionAncestorRecord(child, childrensAncestors));
            }
            processedSections.add(currentSection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processWebAssetsSections(NodeRef childNode, ArrayList<NodeRef> knownAncestors) {
        if (childNode != null && this.nodeService.hasAspect(childNode, ASPECT_WEBASSET)) {
            List parentAssocs = this.nodeService.getParentAssocs(childNode, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
            ArrayList<NodeRef> parentSections = new ArrayList<NodeRef>(parentAssocs.size());
            HashSet<NodeRef> ancestorSections = new HashSet<NodeRef>();
            if (parentAssocs.size() == 1 && knownAncestors != null) {
                parentSections.add(((ChildAssociationRef)parentAssocs.get(0)).getParentRef());
                try {
                    this.behaviourFilter.disableBehaviour(childNode, ASPECT_WEBASSET);
                    this.behaviourFilter.disableBehaviour(childNode, ContentModel.ASPECT_AUDITABLE);
                    this.nodeService.setProperty(childNode, PROP_PARENT_SECTIONS, parentSections);
                    this.nodeService.setProperty(childNode, PROP_ANCESTOR_SECTIONS, knownAncestors);
                }
                finally {
                    this.behaviourFilter.enableBehaviour(childNode, ContentModel.ASPECT_AUDITABLE);
                    this.behaviourFilter.enableBehaviour(childNode, ASPECT_WEBASSET);
                }
            } else {
                for (ChildAssociationRef assoc : parentAssocs) {
                    NodeRef parentNode = assoc.getParentRef();
                    if (this.dictionaryService.isSubClass(this.nodeService.getType(parentNode), WebSiteModel.TYPE_SECTION)) {
                        parentSections.add(parentNode);
                        Collection ancestors = (Collection)((Object)this.nodeService.getProperty(parentNode, PROP_ANCESTOR_SECTIONS));
                        if (ancestors != null) {
                            ancestorSections.addAll(ancestors);
                        }
                    }
                    ancestorSections.addAll(parentSections);
                    try {
                        this.behaviourFilter.disableBehaviour(childNode, ASPECT_WEBASSET);
                        this.behaviourFilter.disableBehaviour(childNode, ContentModel.ASPECT_AUDITABLE);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Section child is a web asset (" + String.valueOf(childNode) + "). Setting parent section ids:  " + String.valueOf(parentSections)));
                        }
                        this.nodeService.setProperty(childNode, PROP_PARENT_SECTIONS, parentSections);
                        this.nodeService.setProperty(childNode, PROP_ANCESTOR_SECTIONS, new ArrayList(ancestorSections));
                    }
                    finally {
                        this.behaviourFilter.enableBehaviour(childNode, ContentModel.ASPECT_AUDITABLE);
                        this.behaviourFilter.enableBehaviour(childNode, ASPECT_WEBASSET);
                    }
                }
            }
        }
    }

    public void init() {
        if (!this.initialised) {
            RetryingTransactionHelper.RetryingTransactionCallback<Object> work = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object execute() throws Throwable {
                    try (ResultSet rs = null;){
                        HashSet<NodeRef> sectionsToProcess = new HashSet<NodeRef>();
                        rs = SectionHierarchyProcessor.this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "lucene", "+TYPE:\"" + String.valueOf(WebSiteModel.TYPE_WEB_ROOT) + "\"");
                        for (ResultSetRow row : rs) {
                            if (SectionHierarchyProcessor.this.nodeService.hasAspect(row.getNodeRef(), WebSiteModel.ASPECT_HAS_ANCESTORS)) continue;
                            sectionsToProcess.add(row.getNodeRef());
                        }
                        if (!sectionsToProcess.isEmpty()) {
                            SectionHierarchyProcessor.this.process(sectionsToProcess);
                        }
                    }
                    return null;
                }
            };
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){
                final /* synthetic */ RetryingTransactionHelper.RetryingTransactionCallback val$work;
                {
                    this.val$work = retryingTransactionCallback;
                }

                public Object doWork() throws Exception {
                    SectionHierarchyProcessor.this.transactionService.getRetryingTransactionHelper().doInTransaction(this.val$work, false, true);
                    return null;
                }
            }, (String)"System");
            this.initialised = true;
        }
    }

    private static class SectionAncestorRecord {
        private final NodeRef sectionId;
        private final Set<NodeRef> ancestorSections;

        public SectionAncestorRecord(NodeRef sectionId, Collection<NodeRef> ancestorSections) {
            this.sectionId = sectionId;
            this.ancestorSections = ancestorSections == null ? null : new HashSet<NodeRef>(ancestorSections);
        }

        public NodeRef getSectionId() {
            return this.sectionId;
        }

        public Set<NodeRef> getAncestorSections() {
            return this.ancestorSections;
        }
    }
}

