/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.publish;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.repo.transfer.AbstractNodeFinder;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QNamePattern;

public class ArticleImageFinder
extends AbstractNodeFinder {
    private NodeService nodeService;
    private DictionaryService dictionaryService;

    public void init() {
        super.init();
        this.nodeService = this.serviceRegistry.getNodeService();
        this.dictionaryService = this.serviceRegistry.getDictionaryService();
    }

    public Set<NodeRef> findFrom(NodeRef thisNode) {
        Set<NodeRef> result = Collections.emptySet();
        if (this.nodeService.exists(thisNode) && this.dictionaryService.isSubClass(this.nodeService.getType(thisNode), WebSiteModel.TYPE_ARTICLE)) {
            result = new HashSet<NodeRef>();
            List images = this.nodeService.getTargetAssocs(thisNode, (QNamePattern)WebSiteModel.ASSOC_PRIMARY_IMAGE);
            images.addAll(this.nodeService.getTargetAssocs(thisNode, (QNamePattern)WebSiteModel.ASSOC_SECONDARY_IMAGE));
            for (AssociationRef assoc : images) {
                result.add(assoc.getTargetRef());
            }
        }
        return result;
    }
}

