/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.publish.PublishService;
import org.alfresco.module.org_alfresco_module_wcmquickstart.rendition.RenditionHelper;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;

public class WebAssetAspect
implements WebSiteModel,
CopyServicePolicies.OnCopyNodePolicy,
ContentServicePolicies.OnContentUpdatePolicy,
NodeServicePolicies.OnAddAspectPolicy,
NodeServicePolicies.BeforeDeleteNodePolicy {
    private PolicyComponent policyComponent;
    private NodeService nodeService;
    private BehaviourFilter behaviourFilter;
    private PublishService publishService;
    private RenditionHelper renditionHelper;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRenditionHelper(RenditionHelper renditionHelper) {
        this.renditionHelper = renditionHelper;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setPublishService(PublishService publishService) {
        this.publishService = publishService;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, ASPECT_WEBASSET, (Behaviour)new JavaBehaviour((Object)this, "getCopyCallback"));
        this.policyComponent.bindClassBehaviour(ContentServicePolicies.OnContentUpdatePolicy.QNAME, ASPECT_WEBASSET, (Behaviour)new JavaBehaviour((Object)this, "onContentUpdate", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnAddAspectPolicy.QNAME, ASPECT_WEBASSET, (Behaviour)new JavaBehaviour((Object)this, "onAddAspect", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ASPECT_WEBASSET, (Behaviour)new JavaBehaviour((Object)this, "onUpdatePropertiesEachEvent", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ASPECT_WEBASSET, (Behaviour)new JavaBehaviour((Object)this, "beforeDeleteNode", Behaviour.NotificationFrequency.FIRST_EVENT));
    }

    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return WebAssetAspectCopyBehaviourCallback.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpdatePropertiesEachEvent(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        Boolean afterAvailable = (Boolean)after.get(PROP_AVAILABLE);
        Boolean beforeAvailable = (Boolean)before.get(PROP_AVAILABLE);
        if (afterAvailable != null && !afterAvailable.equals(beforeAvailable) && afterAvailable.booleanValue()) {
            this.behaviourFilter.disableBehaviour(nodeRef, ASPECT_WEBASSET);
            try {
                this.nodeService.setProperty(nodeRef, PROP_PUBLISHED_TIME, (Serializable)new Date());
            }
            finally {
                this.behaviourFilter.enableBehaviour(nodeRef, ASPECT_WEBASSET);
            }
        }
    }

    public void onContentUpdate(NodeRef nodeRef, boolean newContent) {
        if (newContent && this.nodeService.exists(nodeRef)) {
            this.renditionHelper.createRenditions(nodeRef);
        }
    }

    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        if (this.nodeService.exists(nodeRef)) {
            this.nodeService.setProperty(nodeRef, PROP_AVAILABLE, (Serializable)Boolean.TRUE);
            this.nodeService.setProperty(nodeRef, PROP_PUBLISHED_TIME, (Serializable)new Date());
            this.renditionHelper.createRenditions(nodeRef);
        }
    }

    public void beforeDeleteNode(NodeRef nodeRef) {
        this.publishService.enqueueRemovedNodes(nodeRef);
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_PENDING_DELETE)) {
            this.removeAll(this.nodeService.getSourceAssocs(nodeRef, RegexQNamePattern.MATCH_ALL));
        }
    }

    private void removeAll(List<AssociationRef> assocs) {
        for (AssociationRef assoc : assocs) {
            this.nodeService.removeAssociation(assoc.getSourceRef(), assoc.getTargetRef(), assoc.getTypeQName());
        }
    }

    private static class WebAssetAspectCopyBehaviourCallback
    extends DefaultCopyBehaviourCallback {
        private static final CopyBehaviourCallback INSTANCE = new WebAssetAspectCopyBehaviourCallback();

        private WebAssetAspectCopyBehaviourCallback() {
        }

        public Map<QName, Serializable> getCopyProperties(QName classQName, CopyDetails copyDetails, Map<QName, Serializable> properties) {
            HashMap<QName, Serializable> propertiesToCopy = new HashMap<QName, Serializable>(properties);
            propertiesToCopy.remove(WebSiteModel.PROP_PARENT_SECTIONS);
            propertiesToCopy.remove(WebSiteModel.PROP_ANCESTOR_SECTIONS);
            return propertiesToCopy;
        }
    }
}

