/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.ArrayList;
import java.util.List;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.element.ConfigElementAdapter;

public class DependenciesConfigElement
extends ConfigElementAdapter {
    private static final long serialVersionUID = -8573715101320883067L;
    public static final String CONFIG_ELEMENT_ID = "dependencies";
    private final List<String> cssDependencies = new ArrayList<String>();
    private final List<String> jsDependencies = new ArrayList<String>();

    public DependenciesConfigElement() {
        super(CONFIG_ELEMENT_ID);
    }

    public DependenciesConfigElement(String name) {
        super(name);
    }

    public String[] getCss() {
        if (this.cssDependencies.isEmpty()) {
            return null;
        }
        return this.cssDependencies.toArray(new String[0]);
    }

    public String[] getJs() {
        if (this.jsDependencies.isEmpty()) {
            return null;
        }
        return this.jsDependencies.toArray(new String[0]);
    }

    public List<ConfigElement> getChildren() {
        throw new ConfigException("Reading the default-controls config via the generic interfaces is not supported");
    }

    public ConfigElement combine(ConfigElement configElement) {
        if (configElement == null) {
            return this;
        }
        DependenciesConfigElement otherDepsElement = (DependenciesConfigElement)configElement;
        DependenciesConfigElement result = new DependenciesConfigElement();
        if (!this.cssDependencies.isEmpty()) {
            result.addCssDependencies(this.cssDependencies);
        }
        if (!otherDepsElement.cssDependencies.isEmpty()) {
            result.addCssDependencies(otherDepsElement.cssDependencies);
        }
        if (!this.jsDependencies.isEmpty()) {
            result.addJsDependencies(this.jsDependencies);
        }
        if (!otherDepsElement.jsDependencies.isEmpty()) {
            result.addJsDependencies(otherDepsElement.jsDependencies);
        }
        return result;
    }

    void addCssDependencies(List<String> cssDeps) {
        if (cssDeps == null) {
            return;
        }
        this.cssDependencies.addAll(cssDeps);
    }

    void addJsDependencies(List<String> jsDeps) {
        if (jsDeps == null) {
            return;
        }
        this.jsDependencies.addAll(jsDeps);
    }
}

