/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.web.config.forms.ControlParam;

public class Control {
    private String template;
    private final Map<String, ControlParam> controlParams = new LinkedHashMap();

    public Control() {
        this(null);
    }

    public Control(String template) {
        this.template = template;
    }

    void addControlParam(String cpName, String cpValue) {
        ControlParam cp = new ControlParam(cpName, cpValue);
        this.addControlParam(cp);
    }

    void addControlParam(ControlParam param) {
        this.controlParams.put(param.getName(), param);
    }

    public String getTemplate() {
        return this.template;
    }

    void setTemplate(String newTemplate) {
        this.template = newTemplate;
    }

    public ControlParam[] getParams() {
        return this.getParamsAsList().toArray(new ControlParam[0]);
    }

    public List<ControlParam> getParamsAsList() {
        ArrayList<ControlParam> result = new ArrayList<ControlParam>(this.controlParams.size());
        for (Map.Entry entry : this.controlParams.entrySet()) {
            result.add((ControlParam)entry.getValue());
        }
        return Collections.unmodifiableList(result);
    }

    public Control combine(Control otherControl) {
        String combinedTemplate = otherControl.template == null ? this.template : otherControl.template;
        Control result = new Control(combinedTemplate);
        for (Map.Entry thisEntry : this.controlParams.entrySet()) {
            ControlParam thisCP = (ControlParam)thisEntry.getValue();
            result.controlParams.put(thisCP.getName(), thisCP);
        }
        for (Map.Entry otherEntry : otherControl.controlParams.entrySet()) {
            ControlParam otherCP = (ControlParam)otherEntry.getValue();
            result.controlParams.put(otherCP.getName(), otherCP);
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.template);
        result.append(this.controlParams);
        return result.toString();
    }
}

