/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.scripts.forms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.alfresco.web.config.forms.ConstraintHandlerDefinition;
import org.alfresco.web.config.forms.ConstraintHandlersConfigElement;
import org.alfresco.web.config.forms.Control;
import org.alfresco.web.config.forms.ControlParam;
import org.alfresco.web.config.forms.DefaultControlsConfigElement;
import org.alfresco.web.config.forms.FormConfigElement;
import org.alfresco.web.config.forms.FormField;
import org.alfresco.web.config.forms.FormSet;
import org.alfresco.web.config.forms.FormsConfigElement;
import org.alfresco.web.config.forms.Mode;
import org.alfresco.web.scripts.forms.FormUIGet;
import org.alfresco.web.scripts.forms.OptionsComparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.surf.FrameworkUtil;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.StringBuilderWriter;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.TemplateConfigModel;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorContext;
import org.springframework.extensions.webscripts.connector.ConnectorService;
import org.springframework.extensions.webscripts.connector.HttpMethod;
import org.springframework.extensions.webscripts.connector.Response;
import org.springframework.extensions.webscripts.json.JSONWriter;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FormUIGet
extends DeclarativeWebScript {
    private static Log logger = LogFactory.getLog(FormUIGet.class);
    protected static final String PROPERTY = "property";
    protected static final String ASSOCIATION = "association";
    protected static final String PROP_PREFIX = "prop:";
    protected static final String FIELD = "field";
    protected static final String SET = "set";
    protected static final String ASSOC_PREFIX = "assoc:";
    protected static final String OLD_DATA_TYPE_PREFIX = "d:";
    protected static final String ENDPOINT_ID = "alfresco";
    protected static final String ALFRESCO_PROXY = "/proxy/alfresco";
    protected static final String CM_NAME_PROP = "prop_cm_name";
    protected static final String MSG_DEFAULT_SET_LABEL = "form.default.set.label";
    protected static final String MSG_DEFAULT_FORM_ERROR = "form.error";
    protected static final String INDENT = "   ";
    protected static final String DELIMITER = "#alf#";
    protected static final String SUBMIT_TYPE_MULTIPART = "multipart";
    protected static final String SUBMIT_TYPE_JSON = "json";
    protected static final String SUBMIT_TYPE_URL = "urlencoded";
    protected static final String ENCTYPE_MULTIPART = "multipart/form-data";
    protected static final String ENCTYPE_JSON = "application/json";
    protected static final String ENCTYPE_URL = "application/x-www-form-urlencoded";
    protected static final String DEFAULT_MODE = "edit";
    protected static final String DEFAULT_SUBMIT_TYPE = "multipart";
    protected static final String DEFAULT_METHOD = "post";
    protected static final String DEFAULT_FIELD_TYPE = "text";
    protected static final String DEFAULT_CONSTRAINT_EVENT = "blur";
    protected static final String CONFIG_FORMS = "forms";
    protected static final String PARAM_ITEM_KIND = "itemKind";
    protected static final String PARAM_ITEM_ID = "itemId";
    protected static final String PARAM_FORM_ID = "formId";
    protected static final String PARAM_SUBMIT_TYPE = "submitType";
    protected static final String PARAM_SUBMISSION_URL = "submissionUrl";
    protected static final String PARAM_JS = "js";
    protected static final String PARAM_ERROR_KEY = "err";
    protected static final String CONSTRAINT_MANDATORY = "MANDATORY";
    protected static final String CONSTRAINT_LIST = "LIST";
    protected static final String CONSTRAINT_LENGTH = "LENGTH";
    protected static final String CONSTRAINT_NUMBER = "NUMBER";
    protected static final String CONSTRAINT_MINMAX = "MINMAX";
    protected static final String CONSTRAINT_REGEX = "REGEX";
    protected static final String CONSTRAINT_NODE_HANDLER = "Alfresco.forms.validation.nodeName";
    protected static final String CONSTRAINT_FILE_NAME_HANDLER = "Alfresco.forms.validation.fileName";
    protected static final String CONSTRAINT_MSG_LENGTH = "form.field.constraint.length";
    protected static final String CONSTRAINT_MSG_MINMAX = "form.field.constraint.minmax";
    protected static final String CONSTRAINT_MSG_NUMBER = "form.field.constraint.number";
    protected static final String CONTROL_SELECT_MANY = "/org/alfresco/components/form/controls/selectmany.ftl";
    protected static final String CONTROL_SELECT_ONE = "/org/alfresco/components/form/controls/selectone.ftl";
    protected static final String CONTROL_PARAM_OPTIONS = "options";
    protected static final String CONTROL_PARAM_OPTION_SEPARATOR = "optionSeparator";
    protected static final String MODEL_DATA = "data";
    protected static final String MODEL_DEFINITION = "definition";
    protected static final String MODEL_FIELDS = "fields";
    protected static final String MODEL_FORM_DATA = "formData";
    protected static final String MODEL_FORCE = "force";
    protected static final String MODEL_MESSAGE = "message";
    protected static final String MODEL_PROTECTED_FIELD = "protectedField";
    protected static final String MODEL_REPEATING = "repeating";
    protected static final String MODEL_DEFAULT_VALUE = "defaultValue";
    protected static final String MODEL_FORM = "form";
    protected static final String MODEL_ERROR = "error";
    protected static final String MODEL_NAME = "name";
    protected static final String MODEL_MODE = "mode";
    protected static final String MODEL_METHOD = "method";
    protected static final String MODEL_ENCTYPE = "enctype";
    protected static final String MODEL_SUBMISSION_URL = "submissionUrl";
    protected static final String MODEL_SHOW_CANCEL_BUTTON = "showCancelButton";
    protected static final String MODEL_SHOW_RESET_BUTTON = "showResetButton";
    protected static final String MODEL_SHOW_SUBMIT_BUTTON = "showSubmitButton";
    protected static final String MODEL_SHOW_CAPTION = "showCaption";
    protected static final String MODEL_DESTINATION = "destination";
    protected static final String MODEL_REDIRECT = "redirect";
    protected static final String MODEL_ARGUMENTS = "arguments";
    protected static final String MODEL_STRUCTURE = "structure";
    protected static final String MODEL_CONSTRAINTS = "constraints";
    protected static final String MODEL_VIEW_TEMPLATE = "viewTemplate";
    protected static final String MODEL_EDIT_TEMPLATE = "editTemplate";
    protected static final String MODEL_CREATE_TEMPLATE = "createTemplate";
    protected static final String MODEL_TYPE = "type";
    protected static final String MODEL_LABEL = "label";
    protected static final String MODEL_DESCRIPTION = "description";
    protected static final String MODEL_MANDATORY = "mandatory";
    protected static final String MODEL_DATA_TYPE = "dataType";
    protected static final String MODEL_DATA_TYPE_PARAMETERS = "dataTypeParameters";
    protected static final String MODEL_DATA_KEY_NAME = "dataKeyName";
    protected static final String MODEL_ENDPOINT_TYPE = "endpointType";
    protected static final String MODEL_ENDPOINT_MANDATORY = "endpointMandatory";
    protected static final String MODEL_ENDPOINT_MANY = "endpointMany";
    protected static final String MODEL_ENDPOINT_DIRECTION = "endpointDirection";
    protected static final String MODEL_JAVASCRIPT = "javascript";
    protected static final String MODEL_CAPABILITIES = "capabilities";
    protected static final String MODEL_PARAMETERS = "parameters";
    protected static final String MODEL_MAX_LENGTH = "maxLength";
    protected static final String MODEL_GROUP = "group";
    protected static final String MODEL_INDEX_TOKENISATION_MODE = "indexTokenisationMode";
    private static final String TYPE_INT = "int";
    private static final String TYPE_LONG = "long";
    private static final String TYPE_DOUBLE = "double";
    private static final String TYPE_FLOAT = "float";
    protected ConfigService configService;
    private MessageHelper messageHelper = null;

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        Map<String, Object> model = null;
        String itemKind = this.getParameter(req, "itemKind");
        String itemId = this.getParameter(req, "itemId");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("itemKind = " + itemKind));
            logger.debug((Object)("itemId = " + itemId));
        }
        if (itemKind != null && itemId != null && itemKind.length() > 0 && itemId.length() > 0) {
            model = this.generateModel(itemKind, itemId, req, status, cache);
        } else {
            model = new HashMap<String, Object>(1);
            model.put("form", null);
        }
        return model;
    }

    protected Map<String, Object> generateModel(String itemKind, String itemId, WebScriptRequest request, Status status, Cache cache) {
        FormConfigElement formConfig;
        List visibleFields;
        Response formSvcResponse;
        Map model = null;
        String modeParam = this.getParameter(request, "mode", "edit");
        String formId = this.getParameter(request, "formId");
        Mode mode = Mode.modeFromString((String)modeParam);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Showing " + String.valueOf(mode) + " form (id=" + formId + ") for item: [" + itemKind + "]" + itemId));
        }
        if ((formSvcResponse = this.retrieveFormDefinition(itemKind, itemId, visibleFields = this.getVisibleFields(mode, formConfig = this.getFormConfig(itemId, formId)), formConfig)).getStatus().getCode() == 200) {
            model = this.generateFormModel(request, mode, formSvcResponse, formConfig);
        } else if (formSvcResponse.getStatus().getCode() == 401) {
            status.setCode(401);
            status.setRedirect(true);
        } else {
            String errorKey = this.getParameter(request, "err");
            model = this.generateErrorModel(formSvcResponse, errorKey);
        }
        return model;
    }

    protected String getParameter(WebScriptRequest req, String name) {
        return this.getParameter(req, name, null);
    }

    protected String getParameter(WebScriptRequest req, String name, String defaultValue) {
        String value = req.getParameter(name);
        if ((value == null || value.length() == 0) && defaultValue != null) {
            value = defaultValue;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning \"" + value + "\" from getParameter for \"" + name + "\""));
        }
        return value;
    }

    protected FormConfigElement getFormConfig(String itemId, String formId) {
        FormConfigElement formConfig = null;
        FormsConfigElement formsConfig = null;
        RequestContext requestContext = ThreadLocalRequestContext.getRequestContext();
        TemplateConfigModel extendedTemplateConfigModel = requestContext.getExtendedTemplateConfigModel(null);
        if (extendedTemplateConfigModel != null) {
            Map configs = (Map)extendedTemplateConfigModel.getScoped().get(itemId);
            formsConfig = (FormsConfigElement)configs.get("forms");
        }
        if (formsConfig == null) {
            Config configResult = this.configService.getConfig((Object)itemId);
            formsConfig = (FormsConfigElement)configResult.getConfigElement("forms");
        }
        if (formsConfig != null) {
            if (formsConfig != null) {
                if (formId != null && formId.length() > 0) {
                    formConfig = formsConfig.getForm(formId);
                }
                if (formConfig == null) {
                    formConfig = formsConfig.getDefaultForm();
                }
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)"Could not lookup form configuration as configService has not been set");
        }
        return formConfig;
    }

    protected List<String> getVisibleFields(Mode mode, FormConfigElement formConfig) {
        List visibleFields = null;
        if (formConfig != null) {
            switch (1.$SwitchMap$org$alfresco$web$config$forms$Mode[mode.ordinal()]) {
                case 1: {
                    visibleFields = formConfig.getVisibleViewFieldNamesAsList();
                    break;
                }
                case 2: {
                    visibleFields = formConfig.getVisibleEditFieldNamesAsList();
                    break;
                }
                case 3: {
                    visibleFields = formConfig.getVisibleCreateFieldNamesAsList();
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Fields configured to be visible for " + String.valueOf(mode) + " mode = " + String.valueOf(visibleFields)));
        }
        return visibleFields;
    }

    protected List<String> getVisibleFieldsInSet(ModelContext context, FormSet setConfig) {
        List visibleFields = null;
        Mode mode = context.getMode();
        if (setConfig != null) {
            switch (1.$SwitchMap$org$alfresco$web$config$forms$Mode[mode.ordinal()]) {
                case 1: {
                    visibleFields = context.getFormConfig().getVisibleViewFieldNamesForSetAsList(setConfig.getSetId());
                    break;
                }
                case 2: {
                    visibleFields = context.getFormConfig().getVisibleEditFieldNamesForSetAsList(setConfig.getSetId());
                    break;
                }
                case 3: {
                    visibleFields = context.getFormConfig().getVisibleCreateFieldNamesForSetAsList(setConfig.getSetId());
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Fields configured to be visible for set \"" + setConfig.getSetId() + "\" = " + String.valueOf(visibleFields)));
            }
        }
        return visibleFields;
    }

    protected Response retrieveFormDefinition(String itemKind, String itemId, List<String> visibleFields, FormConfigElement formConfig) {
        Response response;
        block3: {
            response = null;
            try {
                ConnectorService connService = FrameworkUtil.getConnectorService();
                RequestContext requestContext = ThreadLocalRequestContext.getRequestContext();
                String currentUserId = requestContext.getUserId();
                HttpSession currentSession = ServletUtil.getSession((boolean)true);
                Connector connector = connService.getConnector("alfresco", currentUserId, currentSession);
                ConnectorContext context = new ConnectorContext(HttpMethod.POST, null, FormUIGet.buildDefaultHeaders());
                context.setContentType("application/json");
                response = connector.call("/api/formdefinitions", context, (InputStream)this.generateFormDefPostBody(itemKind, itemId, visibleFields, formConfig));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Response status: " + response.getStatus().getCode()));
                }
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block3;
                logger.error((Object)"Failed to get form definition: ", (Throwable)e);
            }
        }
        return response;
    }

    private static Map<String, String> buildDefaultHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(1, 1.0f);
        headers.put("Accept-Language", I18NUtil.getLocale().toString().replace('_', '-'));
        return headers;
    }

    protected String retrieveMessage(String messageKey, Object ... args) {
        if (this.messageHelper == null) {
            this.messageHelper = new MessageHelper(this, (WebScript)this);
        }
        return this.messageHelper.get(messageKey, args);
    }

    protected ByteArrayInputStream generateFormDefPostBody(String itemKind, String itemId, List<String> visibleFields, FormConfigElement formConfig) throws IOException {
        StringBuilderWriter buf = new StringBuilderWriter(512);
        JSONWriter writer = new JSONWriter((Writer)buf);
        writer.startObject();
        writer.writeValue("itemKind", itemKind);
        writer.writeValue("itemId", itemId.replace(":/", ""));
        ArrayList<String> forcedFields = null;
        if (visibleFields != null && visibleFields.size() > 0) {
            writer.startValue("fields");
            writer.startArray();
            forcedFields = new ArrayList<String>(visibleFields.size());
            for (String fieldId : visibleFields) {
                writer.writeValue(fieldId);
                if (!formConfig.isFieldForced(fieldId)) continue;
                forcedFields.add(fieldId);
            }
            writer.endArray();
        }
        if (forcedFields != null && forcedFields.size() > 0) {
            writer.startValue("force");
            writer.startArray();
            for (String fieldId : forcedFields) {
                writer.writeValue(fieldId);
            }
            writer.endArray();
        }
        writer.endObject();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Generated JSON POST body: " + buf.toString()));
        }
        return new ByteArrayInputStream(buf.toString().getBytes());
    }

    protected Map<String, Object> generateFormModel(WebScriptRequest request, Mode mode, Response formSvcResponse, FormConfigElement formConfig) {
        try {
            String jsonResponse = formSvcResponse.getResponse();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("form definition JSON = \n" + jsonResponse));
            }
            JSONObject formDefinition = new JSONObject(new JSONTokener(jsonResponse));
            HashMap<String, Object> model = new HashMap<String, Object>(1);
            model.put("form", this.generateFormUIModel(new ModelContext(this, request, mode, formDefinition, formConfig)));
            return model;
        }
        catch (JSONException je) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)je);
            }
            return null;
        }
    }

    protected Map<String, Object> generateFormUIModel(ModelContext context) {
        String redirect;
        HashMap<String, Object> formUIModel = new HashMap<String, Object>(8);
        context.setFormUIModel(formUIModel);
        formUIModel.put("mode", context.getMode().toString());
        formUIModel.put("method", this.getParameter(context.getRequest(), "method", "post"));
        formUIModel.put("enctype", this.discoverEncodingFormat(context));
        formUIModel.put("submissionUrl", this.discoverSubmissionUrl(context));
        formUIModel.put("arguments", this.discoverArguments(context));
        formUIModel.put("data", this.discoverData(context));
        formUIModel.put("showCancelButton", this.discoverBooleanParam(context, "showCancelButton"));
        formUIModel.put("showResetButton", this.discoverBooleanParam(context, "showResetButton"));
        formUIModel.put("showSubmitButton", this.discoverBooleanParam(context, "showSubmitButton", true));
        String destination = this.getParameter(context.getRequest(), "destination");
        if (destination != null && destination.length() > 0) {
            formUIModel.put("destination", destination);
        }
        if ((redirect = this.getParameter(context.getRequest(), "redirect")) != null && redirect.length() > 0) {
            formUIModel.put("redirect", redirect);
        }
        this.processCapabilities(context, formUIModel);
        this.processTemplates(context, formUIModel);
        this.processFields(context, formUIModel);
        formUIModel.put("showCaption", this.discoverBooleanParam(context, "showCaption", this.getDefaultShowCaption(context)));
        this.dumpFormUIModel(formUIModel);
        return formUIModel;
    }

    private boolean getDefaultShowCaption(ModelContext context) {
        if (context.getMode() == Mode.VIEW) {
            return false;
        }
        for (Constraint constraint : context.getConstraints()) {
            if (!"MANDATORY".equals(constraint.getId())) continue;
            return true;
        }
        return false;
    }

    protected String discoverEncodingFormat(ModelContext context) {
        String submitType = this.getParameter(context.getRequest(), "submitType", "multipart");
        String enctype = null;
        enctype = "multipart".equals(submitType) ? "multipart/form-data" : ("json".equals(submitType) ? "application/json" : ("urlencoded".equals(submitType) ? "application/x-www-form-urlencoded" : "multipart/form-data"));
        return enctype;
    }

    protected String discoverSubmissionUrl(ModelContext context) {
        Object submissionUrl = null;
        if (context.getFormConfig() != null && context.getFormConfig().getSubmissionURL() != null) {
            submissionUrl = context.getFormConfig().getSubmissionURL();
        } else {
            String defaultSubmissionUrl = null;
            try {
                JSONObject data = context.getFormDefinition().getJSONObject("data");
                defaultSubmissionUrl = data.getString("submissionUrl");
            }
            catch (JSONException je) {
                throw new WebScriptException("Failed to find default submission URL", (Throwable)je);
            }
            submissionUrl = this.getParameter(context.getRequest(), "submissionUrl", defaultSubmissionUrl);
        }
        submissionUrl = this.getProxyPath(context) + (String)submissionUrl;
        return submissionUrl;
    }

    protected String getProxyPath(ModelContext context) {
        return context.getRequest().getContextPath() + "/proxy/alfresco";
    }

    protected Map<String, String> discoverArguments(ModelContext context) {
        HashMap<String, String> arguments = new HashMap<String, String>(3);
        arguments.put("itemKind", this.getParameter(context.getRequest(), "itemKind"));
        arguments.put("itemId", this.getParameter(context.getRequest(), "itemId"));
        arguments.put("formId", this.getParameter(context.getRequest(), "formId"));
        return arguments;
    }

    protected Map<String, Object> discoverData(ModelContext context) {
        Map<String, Object> dataModel = null;
        try {
            JSONObject data = context.getFormDefinition().getJSONObject("data");
            JSONObject formData = data.getJSONObject("formData");
            JSONArray names = formData.names();
            if (names != null) {
                dataModel = new HashMap<String, Object>(names.length());
                for (int x = 0; x < names.length(); ++x) {
                    String key = names.getString(x);
                    dataModel.put(key, formData.get(key));
                }
            } else {
                dataModel = Collections.emptyMap();
            }
        }
        catch (JSONException je) {
            throw new WebScriptException("Failed to find form data", (Throwable)je);
        }
        return dataModel;
    }

    protected boolean discoverBooleanParam(ModelContext context, String name) {
        return this.discoverBooleanParam(context, name, false);
    }

    protected boolean discoverBooleanParam(ModelContext context, String name, boolean defaultValue) {
        String value = this.getParameter(context.getRequest(), name, Boolean.toString(defaultValue));
        return "true".equals(value);
    }

    protected JSONObject discoverFieldDefinition(ModelContext context, String fieldName) {
        JSONObject fieldDefinition = null;
        JSONObject propertyDefinition = (JSONObject)context.getPropertyDefinitions().get(fieldName);
        JSONObject associationDefinition = (JSONObject)context.getAssociationDefinitions().get(fieldName);
        if (propertyDefinition == null && associationDefinition == null) {
            if (fieldName.indexOf("prop:") != -1) {
                propertyDefinition = (JSONObject)context.getPropertyDefinitions().get(fieldName.substring("prop:".length()));
            } else if (fieldName.indexOf("assoc:") != -1) {
                associationDefinition = (JSONObject)context.getAssociationDefinitions().get(fieldName.substring("assoc:".length()));
            }
        }
        if (propertyDefinition != null) {
            fieldDefinition = propertyDefinition;
        } else if (associationDefinition != null) {
            fieldDefinition = associationDefinition;
        }
        return fieldDefinition;
    }

    protected String discoverSetLabel(FormSet setConfig) {
        String label = null;
        label = setConfig.getLabelId() != null ? this.retrieveMessage(setConfig.getLabelId(), new Object[0]) : (setConfig.getLabel() != null ? setConfig.getLabel() : ("".equals(setConfig.getSetId()) ? this.retrieveMessage("form.default.set.label", new Object[0]) : setConfig.getSetId()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning label for set: " + label));
        }
        return label;
    }

    protected Map<String, List<String>> discoverSetMembership(ModelContext context) {
        HashMap<String, List<String>> setMemberships;
        block8: {
            setMemberships = new HashMap<String, List<String>>(4);
            try {
                JSONObject data = context.getFormDefinition().getJSONObject("data");
                JSONObject definition = data.getJSONObject("definition");
                JSONArray fieldsFromServer = definition.getJSONArray("fields");
                for (int x = 0; x < fieldsFromServer.length(); ++x) {
                    JSONObject fieldDefinition = fieldsFromServer.getJSONObject(x);
                    String fieldName = fieldDefinition.getString("name");
                    if (!context.getFormConfig().isFieldHidden(fieldName, context.getMode())) {
                        ArrayList<String> fieldsForSet;
                        FormField fieldConfig;
                        String set = "";
                        if (fieldDefinition.has("group")) {
                            set = fieldDefinition.getString("group");
                        }
                        if ((fieldConfig = (FormField)context.getFormConfig().getFields().get(fieldName)) != null && !fieldConfig.getSet().equals("")) {
                            set = fieldConfig.getSet();
                        }
                        if ((fieldsForSet = (ArrayList<String>)setMemberships.get(set)) == null) {
                            fieldsForSet = new ArrayList<String>(4);
                            fieldsForSet.add(fieldName);
                            setMemberships.put(set, fieldsForSet);
                            continue;
                        }
                        fieldsForSet.add(fieldName);
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Ignoring \"" + fieldName + "\" as it is configured to be hidden"));
                }
            }
            catch (JSONException je) {
                if (!logger.isErrorEnabled()) break block8;
                logger.error((Object)"Failed to discover set membership", (Throwable)je);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Set membership = " + String.valueOf(setMemberships)));
        }
        return setMemberships;
    }

    protected void processCapabilities(ModelContext context, Map<String, Object> formUIModel) {
        String jsEnabled = this.getParameter(context.getRequest(), "js");
        if (jsEnabled != null && ("off".equalsIgnoreCase(jsEnabled) || "false".equalsIgnoreCase(jsEnabled) || "disabled".equalsIgnoreCase(jsEnabled))) {
            HashMap<String, Boolean> capabilities = new HashMap<String, Boolean>(1);
            capabilities.put("javascript", false);
            formUIModel.put("capabilities", capabilities);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("JavaScript disabled flag detected, added form capabilties: " + String.valueOf(capabilities)));
            }
        }
    }

    protected void processTemplates(ModelContext context, Map<String, Object> formUIModel) {
        FormConfigElement formConfig = context.getFormConfig();
        if (formConfig != null && formConfig.getViewTemplate() != null) {
            formUIModel.put("viewTemplate", formConfig.getViewTemplate());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Set viewTemplate to \"" + formConfig.getViewTemplate() + "\""));
            }
        }
        if (formConfig != null && formConfig.getEditTemplate() != null) {
            formUIModel.put("editTemplate", formConfig.getEditTemplate());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Set editTemplate to \"" + formConfig.getEditTemplate() + "\""));
            }
        }
        if (formConfig != null && formConfig.getCreateTemplate() != null) {
            formUIModel.put("createTemplate", formConfig.getCreateTemplate());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Set createTemplate to \"" + formConfig.getCreateTemplate() + "\""));
            }
        }
    }

    protected void processFields(ModelContext context, Map<String, Object> formUIModel) {
        List visibleFields = this.getVisibleFields(context.getMode(), context.getFormConfig());
        if (context.getFormConfig() != null && visibleFields != null && visibleFields.size() > 0) {
            this.processVisibleFields(context);
        } else {
            this.processServerFields(context);
        }
        formUIModel.put("fields", context.getFields());
        formUIModel.put("structure", context.getStructure());
        formUIModel.put("constraints", context.getConstraints());
    }

    protected void processVisibleFields(ModelContext context) {
        for (FormSet setConfig : context.getFormConfig().getRootSetsAsList()) {
            Set set = this.generateSetModelUsingVisibleFields(context, setConfig);
            if (set == null) continue;
            context.getStructure().add(set);
        }
    }

    protected void processServerFields(ModelContext context) {
        if (context.getFormConfig() != null) {
            Map setMembership = this.discoverSetMembership(context);
            for (FormSet setConfig : context.getFormConfig().getRootSetsAsList()) {
                Set set = this.generateSetModelUsingServerFields(context, setConfig, setMembership);
                if (set == null) continue;
                context.getStructure().add(set);
            }
        } else {
            Set set = this.generateDefaultSetModelUsingServerFields(context);
            context.getStructure().add(set);
        }
    }

    protected Set generateSetModelUsingVisibleFields(ModelContext context, FormSet setConfig) {
        Set set = null;
        List fieldsInSet = this.getVisibleFieldsInSet(context, setConfig);
        if (fieldsInSet != null && fieldsInSet.size() > 0 || setConfig.getChildrenAsList().size() > 0) {
            set = this.generateSetModel(context, setConfig, fieldsInSet);
            for (FormSet childSetConfig : setConfig.getChildrenAsList()) {
                Set childSet = this.generateSetModelUsingVisibleFields(context, childSetConfig);
                set.addChild((Element)childSet);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Ignoring set \"" + setConfig.getSetId() + "\" as it does not have any fields or child sets"));
        }
        return set;
    }

    protected Set generateSetModelUsingServerFields(ModelContext context, FormSet setConfig, Map<String, List<String>> setMembership) {
        Set set = null;
        List<String> fieldsInSet = setMembership.get(setConfig.getSetId());
        if (fieldsInSet != null && fieldsInSet.size() > 0 || setConfig.getChildrenAsList().size() > 0) {
            set = this.generateSetModel(context, setConfig, fieldsInSet);
            for (FormSet childSetConfig : setConfig.getChildrenAsList()) {
                Set childSet = this.generateSetModelUsingServerFields(context, childSetConfig, setMembership);
                set.addChild((Element)childSet);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Ignoring set \"" + setConfig.getSetId() + "\" as it does not have any fields or child sets"));
        }
        return set;
    }

    protected Set generateSetModel(ModelContext context, FormSet setConfig, List<String> fields) {
        Set set = new Set(this, setConfig);
        for (String fieldName : fields) {
            FormField fieldConfig;
            Field field = this.generateFieldModel(context, fieldName, fieldConfig = (FormField)context.getFormConfig().getFields().get(fieldName));
            if (field == null) continue;
            set.addChild((Element)new FieldPointer(this, field.getId()));
            context.getFields().put(field.getId(), field);
        }
        return set;
    }

    protected Set generateDefaultSetModelUsingServerFields(ModelContext context) {
        Set set;
        block4: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No configuration was found therefore showing all fields in the default set...");
            }
            set = new Set(this, "", this.retrieveMessage("form.default.set.label", new Object[0]));
            try {
                JSONObject data = context.getFormDefinition().getJSONObject("data");
                JSONObject definition = data.getJSONObject("definition");
                JSONArray fieldsFromServer = definition.getJSONArray("fields");
                for (int x = 0; x < fieldsFromServer.length(); ++x) {
                    String fieldName = fieldsFromServer.getJSONObject(x).getString("name");
                    Field field = this.generateFieldModel(context, fieldName, null);
                    if (field == null) continue;
                    set.addChild((Element)new FieldPointer(this, field.getId()));
                    context.getFields().put(field.getId(), field);
                }
            }
            catch (JSONException je) {
                if (!logger.isErrorEnabled()) break block4;
                logger.error((Object)"Failed to generate default set from server fields", (Throwable)je);
            }
        }
        return set;
    }

    protected Field generateFieldModel(ModelContext context, String fieldName, FormField fieldConfig) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Generating model for field \"" + fieldName + "\""));
        }
        Field field = null;
        try {
            if (this.isFieldAmbiguous(context, fieldName)) {
                field = this.generateTransientFieldModel(fieldName, "/org/alfresco/components/form/controls/ambiguous.ftl");
            } else {
                JSONObject fieldDefinition = this.discoverFieldDefinition(context, fieldName);
                if (fieldDefinition != null) {
                    field = new Field(this);
                    this.processFieldIdentification(context, field, fieldDefinition, fieldConfig);
                    this.processFieldState(context, field, fieldDefinition, fieldConfig);
                    this.processFieldText(context, field, fieldDefinition, fieldConfig);
                    this.processFieldData(context, field, fieldDefinition, fieldConfig);
                    this.processFieldControl(context, field, fieldDefinition, fieldConfig);
                    this.processFieldConstraints(context, field, fieldDefinition, fieldConfig);
                    this.processFieldContent(context, field, fieldDefinition, fieldConfig);
                } else {
                    field = this.generateTransientFieldModel(context, fieldName, fieldDefinition, fieldConfig);
                    if (field == null && logger.isDebugEnabled()) {
                        logger.debug((Object)("Ignoring field \"" + fieldName + "\" as neither a field definition or sufficient configuration could be located"));
                    }
                }
            }
        }
        catch (JSONException je) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)("Failed to generate field model for \"" + fieldName + "\""), (Throwable)je);
            }
            field = null;
        }
        return field;
    }

    protected boolean isFieldAmbiguous(ModelContext context, String fieldName) {
        boolean ambiguous = false;
        if (context.getPropertyDefinitions().get(fieldName) != null && context.getAssociationDefinitions().get(fieldName) != null) {
            ambiguous = true;
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("\"" + fieldName + "\" is ambiguous, a property and an association exists with this name, prefix with either \"prop:\" or \"assoc:\" to uniquely identify the field"));
            }
        }
        return ambiguous;
    }

    protected Field generateTransientFieldModel(String fieldName, String template) {
        Field field = new Field(this);
        String name = fieldName.replace(":", "_");
        field.setConfigName(fieldName);
        field.setName(name);
        field.setId(name);
        field.setLabel(fieldName);
        field.setValue((Object)"");
        field.setTransitory(true);
        field.setControl(new FieldControl(this, template));
        return field;
    }

    protected Field generateTransientFieldModel(ModelContext context, String fieldName, JSONObject fieldDefinition, FormField fieldConfig) throws JSONException {
        if (fieldConfig == null || fieldConfig.getControl() == null || fieldConfig.getControl().getTemplate() == null || fieldConfig.getAttributes() == null || fieldConfig.getAttributes().get("set") != null && !((String)fieldConfig.getAttributes().get("set")).isEmpty()) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Generating transient field for \"" + fieldName + "\""));
        }
        Field field = this.generateTransientFieldModel(fieldName, fieldConfig.getControl().getTemplate());
        List params = fieldConfig.getControl().getParamsAsList();
        if (params.size() > 0) {
            FieldControl control = field.getControl();
            for (ControlParam param : params) {
                control.getParams().put(param.getName(), param.getValue());
            }
        }
        this.processFieldText(context, field, fieldDefinition, fieldConfig);
        return field;
    }

    protected void processFieldIdentification(ModelContext context, Field field, JSONObject fieldDefinition, FormField fieldConfig) throws JSONException {
        field.setConfigName(fieldDefinition.getString("name"));
        field.setType(fieldDefinition.getString("type"));
        Object name = field.getConfigName();
        if (field.getType().equals("association")) {
            if (!((String)name).startsWith("assoc:")) {
                name = "assoc:" + field.getConfigName();
            }
        } else if (!((String)name).startsWith("prop:")) {
            name = "prop:" + field.getConfigName();
        }
        name = ((String)name).replace(":", "_");
        field.setId((String)name);
        name = ((String)name).replace(".", "#dot#");
        field.setName((String)name);
    }

    protected void processFieldState(ModelContext context, Field field, JSONObject fieldDefinition, FormField fieldConfig) throws JSONException {
        boolean disabled = false;
        if (fieldDefinition.has("protectedField")) {
            disabled = fieldDefinition.getBoolean("protectedField");
        }
        if (!disabled && fieldConfig != null && fieldConfig.isReadOnly()) {
            disabled = true;
        }
        field.setDisabled(disabled);
        boolean mandatory = false;
        if (fieldDefinition.has("mandatory")) {
            mandatory = fieldDefinition.getBoolean("mandatory");
        }
        if (fieldDefinition.has("endpointMandatory")) {
            mandatory = fieldDefinition.getBoolean("endpointMandatory");
        }
        if (!mandatory && fieldConfig != null && fieldConfig.isMandatory()) {
            mandatory = true;
        }
        field.setMandatory(mandatory);
        if (fieldDefinition.has("repeating")) {
            field.setRepeating(fieldDefinition.getBoolean("repeating"));
        }
        if (fieldDefinition.has("endpointMany")) {
            field.setRepeating(fieldDefinition.getBoolean("endpointMany"));
        }
        if (fieldDefinition.has("endpointDirection")) {
            field.setEndpointDirection(fieldDefinition.getString("endpointDirection"));
        }
    }

    protected void processFieldText(ModelContext context, Field field, JSONObject fieldDefinition, FormField fieldConfig) throws JSONException {
        if (fieldDefinition != null) {
            if (fieldDefinition.has("label")) {
                field.setLabel(fieldDefinition.getString("label"));
            }
            if (fieldDefinition.has("description")) {
                field.setDescription(fieldDefinition.getString("description"));
            }
        }
        if (fieldConfig != null) {
            String configLabel = null;
            if (fieldConfig.getLabelId() != null) {
                configLabel = this.retrieveMessage(fieldConfig.getLabelId(), new Object[0]);
            } else if (fieldConfig.getLabel() != null) {
                configLabel = fieldConfig.getLabel();
            }
            if (configLabel != null) {
                field.setLabel(configLabel);
            }
            String configDesc = null;
            if (fieldConfig.getDescriptionId() != null) {
                configDesc = this.retrieveMessage(fieldConfig.getDescriptionId(), new Object[0]);
            } else if (fieldConfig.getDescription() != null) {
                configDesc = fieldConfig.getDescription();
            }
            if (configDesc != null) {
                field.setDescription(configDesc);
            }
            String configHelp = null;
            if (fieldConfig.getHelpTextId() != null) {
                configHelp = this.retrieveMessage(fieldConfig.getHelpTextId(), new Object[0]);
            } else if (fieldConfig.getHelpText() != null) {
                configHelp = fieldConfig.getHelpText();
            }
            if (configHelp != null) {
                field.setHelp(configHelp);
            }
            if (fieldConfig.getHelpEncodeHtml() != null) {
                field.setHelpEncodeHtml(fieldConfig.getHelpEncodeHtml().equalsIgnoreCase("true"));
            }
        }
    }

    protected void processFieldData(ModelContext context, Field field, JSONObject fieldDefinition, FormField fieldConfig) throws JSONException {
        JSONObject formData;
        if (fieldDefinition.has("dataType")) {
            field.setDataType(fieldDefinition.getString("dataType"));
        }
        if (fieldDefinition.has("endpointType")) {
            field.setDataType(fieldDefinition.getString("endpointType"));
        }
        field.setDataKeyName(fieldDefinition.getString("dataKeyName"));
        field.setValue((Object)"");
        JSONObject formDefinition = context.getFormDefinition().getJSONObject("data");
        if (formDefinition.has("formData") && (formData = formDefinition.getJSONObject("formData")).has(field.getDataKeyName())) {
            field.setValue(formData.get(field.getDataKeyName()));
        }
        if (field.getValue().equals("") && context.getMode().equals((Object)Mode.CREATE) && fieldDefinition.has("defaultValue")) {
            field.setValue((Object)fieldDefinition.getString("defaultValue"));
        }
        if (fieldDefinition.has("indexTokenisationMode") && fieldDefinition.getString("indexTokenisationMode").toUpperCase().equals("FALSE")) {
            field.setIndexTokenisationMode(fieldDefinition.getString("indexTokenisationMode"));
        }
    }

    protected void processFieldConstraints(ModelContext context, Field field, JSONObject fieldDefinition, FormField fieldConfig) throws JSONException {
        Map constraintDefinitionMap;
        Constraint constraint;
        if (!field.isDisabled()) {
            Constraint constraint2;
            if (field.isMandatory() && (constraint2 = this.generateConstraintModel(context, field, fieldDefinition, fieldConfig, "MANDATORY")) != null) {
                context.getConstraints().add(constraint2);
            }
            if (fieldConfig != null && fieldConfig.getConstraintDefinitionMap() != null) {
                Map fieldConstraints = fieldConfig.getConstraintDefinitionMap();
                for (String constraintId : fieldConstraints.keySet()) {
                    Constraint constraint3 = null;
                    ConstraintHandlerDefinition customConstraintConfig = (ConstraintHandlerDefinition)fieldConstraints.get(constraintId);
                    if (customConstraintConfig != null) {
                        constraint3 = this.generateConstraintModel(context, field, fieldConfig, constraintId, new JSONObject(), customConstraintConfig);
                    }
                    if (constraint3 == null) continue;
                    context.getConstraints().add(constraint3);
                }
            }
        }
        if (fieldDefinition.has("constraints")) {
            JSONArray constraints = fieldDefinition.getJSONArray("constraints");
            for (int x = 0; x < constraints.length(); ++x) {
                constraint = this.generateConstraintModel(context, field, fieldDefinition, fieldConfig, constraints.getJSONObject(x));
                if (constraint == null) continue;
                context.getConstraints().add(constraint);
            }
        }
        String dataType = field.getDataType();
        Map map = constraintDefinitionMap = fieldConfig == null ? null : fieldConfig.getConstraintDefinitionMap();
        if ((this.isConstraintHandlerExist(constraintDefinitionMap, "NUMBER") || this.isDataTypeNumber(dataType)) && (constraint = this.generateConstraintModel(context, field, fieldDefinition, fieldConfig, "NUMBER")) != null) {
            if (field.isRepeating()) {
                constraint.getJSONParams().put("repeating", true);
            }
            context.getConstraints().add(constraint);
        }
    }

    private boolean isConstraintHandlerExist(Map<String, ConstraintHandlerDefinition> constraintDefinitionMap, String constraint) {
        if (constraintDefinitionMap != null) {
            return constraintDefinitionMap.containsKey(constraint);
        }
        return false;
    }

    private boolean isDataTypeNumber(String dataType) {
        return "int".equals(dataType) || "long".equals(dataType) || "double".equals(dataType) || "float".equals(dataType);
    }

    protected Constraint generateConstraintModel(ModelContext context, Field field, JSONObject fieldDefinition, FormField fieldConfig, String constraintId) throws JSONException {
        JSONObject constraintDef = new JSONObject();
        constraintDef.put("type", (Object)constraintId);
        return this.generateConstraintModel(context, field, fieldDefinition, fieldConfig, constraintDef);
    }

    protected Constraint generateConstraintModel(ModelContext context, Field field, JSONObject fieldDefinition, FormField fieldConfig, JSONObject constraintDefinition) throws JSONException {
        Constraint constraint = null;
        String constraintId = null;
        JSONObject constraintParams = null;
        if (constraintDefinition.has("type")) {
            constraintId = constraintDefinition.getString("type");
        }
        constraintParams = constraintDefinition.has("parameters") ? constraintDefinition.getJSONObject("parameters") : new JSONObject();
        ConstraintHandlersConfigElement defaultConstraintHandlers = null;
        FormsConfigElement formsGlobalConfig = (FormsConfigElement)this.configService.getGlobalConfig().getConfigElement("forms");
        if (formsGlobalConfig != null) {
            defaultConstraintHandlers = formsGlobalConfig.getConstraintHandlers();
        }
        if (defaultConstraintHandlers == null) {
            throw new WebScriptException("Failed to locate default constraint handlers configurarion");
        }
        ConstraintHandlerDefinition defaultConstraintConfig = (ConstraintHandlerDefinition)defaultConstraintHandlers.getItems().get(constraintId);
        if (defaultConstraintConfig != null) {
            constraint = this.generateConstraintModel(context, field, fieldConfig, constraintId, constraintParams, defaultConstraintConfig);
            this.processFieldConstraintControl(context, field, fieldConfig, constraint);
            this.processFieldConstraintHelp(context, field, fieldConfig, constraint);
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("No default constraint configuration found for \"" + constraintId + "\" constraint whilst processing field \"" + field.getConfigName() + "\""));
        }
        return constraint;
    }

    protected Constraint generateConstraintModel(ModelContext context, Field field, FormField fieldConfig, String constraintId, JSONObject constraintParams, ConstraintHandlerDefinition defaultConstraintConfig) throws JSONException {
        String validationHandler = defaultConstraintConfig.getValidationHandler();
        Constraint constraint = new Constraint(this, field.getId(), constraintId, validationHandler, constraintParams);
        if (defaultConstraintConfig.getEvent() != null) {
            constraint.setEvent(defaultConstraintConfig.getEvent());
        } else {
            constraint.setEvent("blur");
        }
        String constraintMsg = null;
        if (fieldConfig != null && fieldConfig.getConstraintDefinitionMap().get(constraintId) != null) {
            ConstraintHandlerDefinition fieldConstraintConfig = (ConstraintHandlerDefinition)fieldConfig.getConstraintDefinitionMap().get(constraintId);
            if (fieldConstraintConfig.getMessageId() != null) {
                constraintMsg = this.retrieveMessage(fieldConstraintConfig.getMessageId(), new Object[0]);
            } else if (fieldConstraintConfig.getMessage() != null) {
                constraintMsg = fieldConstraintConfig.getMessage();
            }
            if (fieldConstraintConfig.getValidationHandler() != null) {
                constraint.setValidationHandler(fieldConstraintConfig.getValidationHandler());
            }
            if (fieldConstraintConfig.getEvent() != null) {
                constraint.setEvent(fieldConstraintConfig.getEvent());
            }
        } else if (defaultConstraintConfig.getMessageId() != null) {
            constraintMsg = this.retrieveMessage(defaultConstraintConfig.getMessageId(), new Object[0]);
        } else if (defaultConstraintConfig.getMessage() != null) {
            constraintMsg = defaultConstraintConfig.getMessage();
        }
        if (constraintMsg == null) {
            constraintMsg = this.retrieveMessage(validationHandler + ".message", new Object[0]);
        }
        if (constraintMsg != null) {
            constraint.setMessage(constraintMsg);
        }
        return constraint;
    }

    protected void processFieldConstraintControl(ModelContext context, Field field, FormField fieldConfig, Constraint constraint) throws JSONException {
        if ("LIST".equals(constraint.getId())) {
            if (fieldConfig == null || fieldConfig.getControl() == null || fieldConfig.getControl().getTemplate() == null) {
                if (field.isRepeating()) {
                    field.getControl().setTemplate("/org/alfresco/components/form/controls/selectmany.ftl");
                } else {
                    field.getControl().setTemplate("/org/alfresco/components/form/controls/selectone.ftl");
                }
            }
            if (!field.getControl().getParams().containsKey("options")) {
                JSONArray options = constraint.getJSONParams().getJSONArray("allowedValues");
                ArrayList<String> optionsList = new ArrayList<String>(options.length());
                for (int x = 0; x < options.length(); ++x) {
                    optionsList.add(options.getString(x));
                }
                if (fieldConfig != null && fieldConfig.isSorted()) {
                    Collections.sort(optionsList, new OptionsComparator());
                }
                field.getControl().getParams().put("options", StringUtils.collectionToDelimitedString(optionsList, (String)"#alf#"));
                field.getControl().getParams().put("optionSeparator", "#alf#");
            }
        } else if ("LENGTH".equals(constraint.getId())) {
            int maxLength = -1;
            if (constraint.getJSONParams().has("maxLength")) {
                maxLength = constraint.getJSONParams().getInt("maxLength");
            }
            if (maxLength != -1) {
                field.getControl().getParams().put("maxLength", Integer.toString(maxLength));
                constraint.getJSONParams().put("crop", true);
            }
        } else if ("REGEX".equals(constraint.getId()) && "prop_cm_name".equals(field.getName())) {
            constraint.setValidationHandler("Alfresco.forms.validation.fileName");
            constraint.setJSONParams(new JSONObject());
        }
    }

    protected void processFieldConstraintHelp(ModelContext context, Field field, FormField fieldConfig, Constraint constraint) throws JSONException {
        if (field.getHelp() == null) {
            if ("LENGTH".equals(constraint.getId())) {
                String text = this.retrieveMessage("form.field.constraint.length", new Object[]{constraint.getJSONParams().getInt("minLength"), constraint.getJSONParams().getInt("maxLength")});
                field.setHelp(text);
            } else if ("MINMAX".equals(constraint.getId())) {
                String text = this.retrieveMessage("form.field.constraint.minmax", new Object[]{constraint.getJSONParams().getInt("minValue"), constraint.getJSONParams().getInt("maxValue")});
                field.setHelp(text);
            } else if ("NUMBER".equals(constraint.getId())) {
                field.setHelp(this.retrieveMessage("form.field.constraint.number", new Object[0]));
            }
        }
    }

    protected void processFieldControl(ModelContext context, Field field, JSONObject fieldDefinition, FormField fieldConfig) throws JSONException {
        List paramsConfig;
        FieldControl control = null;
        DefaultControlsConfigElement defaultControls = null;
        FormsConfigElement formsGlobalConfig = (FormsConfigElement)this.configService.getGlobalConfig().getConfigElement("forms");
        if (formsGlobalConfig != null) {
            defaultControls = formsGlobalConfig.getDefaultControls();
        }
        if (defaultControls == null) {
            throw new WebScriptException("Failed to locate default controls configuration");
        }
        boolean isPropertyField = !"association".equals(fieldDefinition.getString("type"));
        Control defaultControlConfig = null;
        if (isPropertyField) {
            defaultControlConfig = (Control)defaultControls.getItems().get(fieldDefinition.getString("dataType"));
            if (defaultControlConfig == null) {
                defaultControlConfig = (Control)defaultControls.getItems().get("d:" + fieldDefinition.getString("dataType"));
            }
        } else {
            defaultControlConfig = (Control)defaultControls.getItems().get("association:" + fieldDefinition.getString("endpointType"));
            if (defaultControlConfig == null) {
                defaultControlConfig = (Control)defaultControls.getItems().get("association");
            }
        }
        if (fieldConfig != null && fieldConfig.getControl() != null && fieldConfig.getControl().getTemplate() != null) {
            control = new FieldControl(this, fieldConfig.getControl().getTemplate());
        } else if (defaultControlConfig != null) {
            control = new FieldControl(this, defaultControlConfig.getTemplate());
        } else if (logger.isWarnEnabled()) {
            if (isPropertyField) {
                logger.warn((Object)("No default control found for data type \"" + fieldDefinition.getString("dataType") + "\" whilst processing field \"" + fieldDefinition.getString("name") + "\""));
            } else {
                logger.warn((Object)("No default control found for associations\" whilst processing field \"" + fieldDefinition.getString("name") + "\""));
            }
        }
        if (isPropertyField && control != null && fieldDefinition.has("dataTypeParameters")) {
            control.getParams().put("dataTypeParameters", fieldDefinition.get("dataTypeParameters").toString());
        }
        if (defaultControlConfig != null && control != null) {
            paramsConfig = defaultControlConfig.getParamsAsList();
            for (ControlParam param : paramsConfig) {
                control.getParams().put(param.getName(), param.getValue());
            }
        }
        if (fieldConfig != null && control != null) {
            paramsConfig = fieldConfig.getControl().getParamsAsList();
            for (ControlParam param : paramsConfig) {
                control.getParams().put(param.getName(), param.getValue());
            }
        }
        field.setControl(control);
    }

    protected void processFieldContent(ModelContext context, Field field, JSONObject fieldDefinition, FormField fieldConfig) throws JSONException {
        block5: {
            if (context.getFormUIModel().get("capabilities") != null && "content".equals(field.getDataType())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Retrieving content for \"" + field.getConfigName() + "\" as JavaScript is disabled"));
                }
                String nodeRef = this.getParameter(context.getRequest(), "itemId");
                try {
                    ConnectorService connService = FrameworkUtil.getConnectorService();
                    RequestContext requestContext = ThreadLocalRequestContext.getRequestContext();
                    String currentUserId = requestContext.getUserId();
                    HttpSession currentSession = ServletUtil.getSession((boolean)true);
                    Connector connector = connService.getConnector("alfresco", currentUserId, currentSession);
                    Response response = connector.call("/api/node/content/" + nodeRef.replace("://", "/"));
                    if (response.getStatus().getCode() == 200) {
                        field.setContent(response.getText());
                    }
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) break block5;
                    logger.error((Object)"Failed to get field content: ", (Throwable)e);
                }
            }
        }
    }

    protected Map<String, Object> generateErrorModel(Response errorResponse) {
        return this.generateErrorModel(errorResponse, null);
    }

    protected Map<String, Object> generateErrorModel(Response errorResponse, String errorKey) {
        String id;
        String error = "";
        try {
            JSONObject json = new JSONObject(new JSONTokener(errorResponse.getResponse()));
            if (json.has("message") && (error = json.getString("message")).indexOf("org.alfresco.repo.security.permissions.AccessDeniedException") == -1 && (errorKey == null || errorKey.isEmpty()) && logger.isErrorEnabled()) {
                logger.error((Object)error);
            }
        }
        catch (JSONException je) {
            error = "";
        }
        if (errorKey == null || errorKey.isEmpty()) {
            errorKey = "form.error";
        }
        if ((error = this.retrieveMessage(id = errorKey + "." + errorResponse.getStatus().getCode(), new Object[0])).equals(id)) {
            error = this.retrieveMessage(errorKey, new Object[0]);
        }
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        model.put("error", error);
        return model;
    }

    protected void dumpFormUIModel(Map<String, Object> model) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("formUIModel = " + this.dumpMap(model, "   ")));
        }
    }

    protected String dumpMap(Map<String, Object> map, String indent) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        if (indent.length() > "   ".length()) {
            builder.append(indent.substring("   ".length()));
        }
        builder.append("{");
        boolean firstKey = true;
        for (String key : map.keySet()) {
            if (firstKey) {
                firstKey = false;
            } else {
                builder.append(",");
            }
            builder.append("\n");
            builder.append(indent);
            builder.append(key);
            builder.append(": ");
            Object value = map.get(key);
            if (value instanceof String) {
                builder.append("\"");
                builder.append(value);
                builder.append("\"");
                continue;
            }
            if (value instanceof Map) {
                builder.append(this.dumpMap((Map)value, indent + "   "));
                continue;
            }
            if (value instanceof List) {
                boolean firstItem = true;
                builder.append("\n").append("   ").append("[");
                for (Object item : (List)value) {
                    if (firstItem) {
                        firstItem = false;
                    } else {
                        builder.append(",");
                    }
                    builder.append("\n").append("   ").append("   ");
                    builder.append(item);
                }
                builder.append("\n").append("   ").append("]");
                continue;
            }
            builder.append(value);
        }
        builder.append("\n");
        if (indent.length() > "   ".length()) {
            builder.append(indent.substring("   ".length()));
        }
        builder.append("}");
        return builder.toString();
    }
}

