/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.alfresco.util.BaseTest;
import org.alfresco.web.config.forms.ConstraintHandlerDefinition;
import org.alfresco.web.config.forms.ConstraintHandlersConfigElement;
import org.alfresco.web.config.forms.DefaultControlsConfigElement;
import org.alfresco.web.config.forms.FormConfigElement;
import org.alfresco.web.config.forms.FormsConfigElement;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.XMLConfigService;

public class ConstraintHandlersConfigTest
extends BaseTest {
    protected XMLConfigService configService;
    protected Config globalConfig;
    protected ConfigElement globalDefaultControls;
    protected ConfigElement globalConstraintHandlers;
    protected FormsConfigElement formsConfigElement;
    protected FormConfigElement defaultFormConfigElement;
    protected DefaultControlsConfigElement defltCtrlsConfElement;

    protected String getConfigXmlFile() {
        return "test-config-forms-basic.xml";
    }

    public String getResourcesDir() {
        return "classpath:";
    }

    public void testReadConstraintHandlersFromConfigXml() {
        HashMap<String, String> expectedValidationHandlers = new HashMap<String, String>();
        expectedValidationHandlers.put("MANDATORY", "Alfresco.forms.validation.mandatory");
        expectedValidationHandlers.put("REGEX", "Alfresco.forms.validation.regexMatch");
        expectedValidationHandlers.put("NUMERIC", "Alfresco.forms.validation.numericMatch");
        ConstraintHandlersConfigElement chConfigElement = (ConstraintHandlersConfigElement)this.globalConstraintHandlers;
        List actualTypes = chConfigElement.getConstraintTypesAsList();
        ConstraintHandlersConfigTest.assertEquals((String)"Incorrect type count.", (int)expectedValidationHandlers.size(), (int)actualTypes.size());
        ConstraintHandlersConfigTest.assertEquals(expectedValidationHandlers.keySet(), new HashSet(actualTypes));
        for (Object nextKey : expectedValidationHandlers.keySet()) {
            String nextExpectedValue = (String)expectedValidationHandlers.get(nextKey);
            String nextActualValue = chConfigElement.getValidationHandlerFor((String)nextKey);
            ConstraintHandlersConfigTest.assertTrue((String)("Incorrect handler for " + (String)nextKey + ": " + nextActualValue), (boolean)nextExpectedValue.equals(nextActualValue));
        }
        HashMap<String, String> expectedMessages = new HashMap<String, String>();
        expectedMessages.put("MANDATORY", null);
        expectedMessages.put("REGEX", null);
        expectedMessages.put("NUMERIC", "Test Message");
        for (String nextKey : expectedValidationHandlers.keySet()) {
            String nextExpectedValue = (String)expectedMessages.get(nextKey);
            String nextActualValue = chConfigElement.getMessageFor(nextKey);
            ConstraintHandlersConfigTest.assertEquals((String)("Incorrect message for " + nextKey + "."), (String)nextExpectedValue, (String)nextActualValue);
        }
        HashMap<String, String> expectedMessageIDs = new HashMap<String, String>();
        expectedMessageIDs.put("MANDATORY", null);
        expectedMessageIDs.put("REGEX", null);
        expectedMessageIDs.put("NUMERIC", "regex_error");
        for (String nextKey : expectedValidationHandlers.keySet()) {
            String nextExpectedValue = (String)expectedMessageIDs.get(nextKey);
            String nextActualValue = chConfigElement.getMessageIdFor(nextKey);
            ConstraintHandlersConfigTest.assertEquals((String)("Incorrect message-id for " + nextKey + "."), (String)nextExpectedValue, (String)nextActualValue);
        }
        ConstraintHandlersConfigTest.assertEquals((String)"Incorrect event for MANDATORY constraint", (String)"blur", (String)chConfigElement.getEventFor("MANDATORY"));
    }

    public void testConstraintHandlerElementShouldHaveNoChildren() {
        try {
            ConstraintHandlersConfigElement chConfigElement = (ConstraintHandlersConfigElement)this.globalConstraintHandlers;
            chConfigElement.getChildren();
            ConstraintHandlersConfigTest.fail((String)"getChildren() did not throw an exception");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    public void testCombineConstraintHandlersWithAddedParam() {
        ConstraintHandlersConfigElement basicElement = new ConstraintHandlersConfigElement();
        basicElement.addDataMapping("REGEX", "foo.regex", null, null, null);
        ConstraintHandlersConfigElement elementWithAdditions = new ConstraintHandlersConfigElement();
        elementWithAdditions.addDataMapping("REGEX", "foo.regex", "msg", "msg-id", null);
        ConstraintHandlersConfigElement combinedElem = (ConstraintHandlersConfigElement)basicElement.combine((ConfigElement)elementWithAdditions);
        ConstraintHandlersConfigTest.assertEquals((String)"foo.regex", (String)((ConstraintHandlerDefinition)combinedElem.getItems().get("REGEX")).getValidationHandler());
        ConstraintHandlersConfigTest.assertEquals((String)"msg", (String)((ConstraintHandlerDefinition)combinedElem.getItems().get("REGEX")).getMessage());
        ConstraintHandlersConfigTest.assertEquals((String)"msg-id", (String)((ConstraintHandlerDefinition)combinedElem.getItems().get("REGEX")).getMessageId());
        ConstraintHandlersConfigTest.assertEquals(null, (String)((ConstraintHandlerDefinition)combinedElem.getItems().get("REGEX")).getEvent());
    }

    public void testCombineConstraintHandlersWithModifiedParam() {
        ConstraintHandlersConfigElement initialElement = new ConstraintHandlersConfigElement();
        initialElement.addDataMapping("REGEX", "foo.regex", null, null, null);
        ConstraintHandlersConfigElement modifiedElement = new ConstraintHandlersConfigElement();
        modifiedElement.addDataMapping("REGEX", "bar.regex", "msg", "msg-id", null);
        ConstraintHandlersConfigElement combinedElem = (ConstraintHandlersConfigElement)initialElement.combine((ConfigElement)modifiedElement);
        ConstraintHandlersConfigTest.assertEquals((String)"bar.regex", (String)((ConstraintHandlerDefinition)combinedElem.getItems().get("REGEX")).getValidationHandler());
        ConstraintHandlersConfigTest.assertEquals((String)"msg", (String)((ConstraintHandlerDefinition)combinedElem.getItems().get("REGEX")).getMessage());
        ConstraintHandlersConfigTest.assertEquals((String)"msg-id", (String)((ConstraintHandlerDefinition)combinedElem.getItems().get("REGEX")).getMessageId());
        ConstraintHandlersConfigTest.assertEquals(null, (String)((ConstraintHandlerDefinition)combinedElem.getItems().get("REGEX")).getEvent());
    }

    public void testCombineConstraintHandlersWithDeletedParam() {
        ConstraintHandlersConfigElement initialElement = new ConstraintHandlersConfigElement();
        initialElement.addDataMapping("REGEX", "bar.regex", "msg", "msg-id", null);
        ConstraintHandlersConfigElement modifiedElement = new ConstraintHandlersConfigElement();
        modifiedElement.addDataMapping("REGEX", "bar.regex", null, null, null);
        ConstraintHandlersConfigElement combinedElem = (ConstraintHandlersConfigElement)initialElement.combine((ConfigElement)modifiedElement);
        ConstraintHandlersConfigTest.assertEquals((String)"bar.regex", (String)((ConstraintHandlerDefinition)combinedElem.getItems().get("REGEX")).getValidationHandler());
        ConstraintHandlersConfigTest.assertEquals(null, (String)((ConstraintHandlerDefinition)combinedElem.getItems().get("REGEX")).getMessage());
        ConstraintHandlersConfigTest.assertEquals(null, (String)((ConstraintHandlerDefinition)combinedElem.getItems().get("REGEX")).getMessageId());
        ConstraintHandlersConfigTest.assertEquals(null, (String)((ConstraintHandlerDefinition)combinedElem.getItems().get("REGEX")).getEvent());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.configService = this.initXMLConfigService(this.getConfigXmlFile());
        ConstraintHandlersConfigTest.assertNotNull((String)"configService was null.", (Object)this.configService);
        Config contentConfig = this.configService.getConfig((Object)"my:example");
        ConstraintHandlersConfigTest.assertNotNull((String)"contentConfig was null.", (Object)contentConfig);
        ConfigElement confElement = contentConfig.getConfigElement("forms");
        ConstraintHandlersConfigTest.assertNotNull((String)"confElement was null.", (Object)confElement);
        ConstraintHandlersConfigTest.assertTrue((String)"confElement should be instanceof FormsConfigElement.", (boolean)(confElement instanceof FormsConfigElement));
        this.formsConfigElement = (FormsConfigElement)confElement;
        this.defaultFormConfigElement = this.formsConfigElement.getDefaultForm();
        this.globalConfig = this.configService.getGlobalConfig();
        FormsConfigElement globalForms = (FormsConfigElement)this.globalConfig.getConfigElement("forms");
        this.globalDefaultControls = globalForms.getDefaultControls();
        ConstraintHandlersConfigTest.assertNotNull((String)"global default-controls element should not be null", (Object)this.globalDefaultControls);
        ConstraintHandlersConfigTest.assertTrue((String)"config element should be an instance of DefaultControlsConfigElement", (boolean)(this.globalDefaultControls instanceof DefaultControlsConfigElement));
        this.defltCtrlsConfElement = (DefaultControlsConfigElement)this.globalDefaultControls;
        this.globalConstraintHandlers = globalForms.getConstraintHandlers();
        ConstraintHandlersConfigTest.assertNotNull((String)"global constraint-handlers element should not be null", (Object)this.globalConstraintHandlers);
        ConstraintHandlersConfigTest.assertTrue((String)"config element should be an instance of ConstraintHandlersConfigElement", (boolean)(this.globalConstraintHandlers instanceof ConstraintHandlersConfigElement));
    }
}

