/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.alfresco.util.BaseTest;
import org.alfresco.web.config.forms.ConstraintHandlerDefinition;
import org.alfresco.web.config.forms.ControlParam;
import org.alfresco.web.config.forms.DefaultControlsConfigElement;
import org.alfresco.web.config.forms.FormConfigElement;
import org.alfresco.web.config.forms.FormField;
import org.alfresco.web.config.forms.FormSet;
import org.alfresco.web.config.forms.FormsConfigElement;
import org.alfresco.web.config.forms.Mode;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.XMLConfigService;

public class FormConfigTest
extends BaseTest {
    protected XMLConfigService configService;
    protected Config globalConfig;
    protected ConfigElement globalConstraintHandlers;
    protected FormsConfigElement formsConfigElement;
    protected FormConfigElement defaultFormInContent;
    protected DefaultControlsConfigElement defltCtrlsConfElement;

    protected String getConfigXmlFile() {
        return "test-config-forms.xml";
    }

    public String getResourcesDir() {
        return "classpath:";
    }

    public void testFormSubmissionUrl() {
        FormConfigTest.assertEquals((String)"Submission URL was incorrect.", (String)"submission/url", (String)this.defaultFormInContent.getSubmissionURL());
    }

    public void testGetFormTemplates() {
        FormConfigTest.assertEquals((String)"Incorrect template.", (String)"/create/template", (String)this.defaultFormInContent.getFormTemplate(Mode.CREATE));
    }

    public void testGetFormFieldVisibilitiesForModes() {
        FormConfigTest.assertTrue((String)"Field 'name' should be visible.", (boolean)this.defaultFormInContent.isFieldVisible("name", Mode.CREATE));
        FormConfigTest.assertTrue((String)"Field 'title' should be visible.", (boolean)this.defaultFormInContent.isFieldVisible("title", Mode.CREATE));
        FormConfigTest.assertFalse((String)"Field 'rubbish' should be invisible.", (boolean)this.defaultFormInContent.isFieldVisible("rubbish", Mode.CREATE));
        FormConfigTest.assertTrue((String)"Field 'name' should be visible.", (boolean)this.defaultFormInContent.isFieldVisible("name", Mode.EDIT));
        FormConfigTest.assertFalse((String)"Field 'title' should be invisible.", (boolean)this.defaultFormInContent.isFieldVisible("title", Mode.EDIT));
        FormConfigTest.assertFalse((String)"Field 'rubbish' should be invisible.", (boolean)this.defaultFormInContent.isFieldVisible("rubbish", Mode.EDIT));
        FormConfigTest.assertTrue((String)"Field 'name' should be visible.", (boolean)this.defaultFormInContent.isFieldVisible("name", Mode.VIEW));
        FormConfigTest.assertTrue((String)"Field 'title' should be visible.", (boolean)this.defaultFormInContent.isFieldVisible("title", Mode.VIEW));
        FormConfigTest.assertFalse((String)"Field 'rubbish' should be invisible.", (boolean)this.defaultFormInContent.isFieldVisible("rubbish", Mode.VIEW));
    }

    public void testVisibleFieldsMustBeCorrectlyOrdered() {
        FormConfigElement setForm = this.readFormFromConfig("set_membership");
        List fieldNames = setForm.getVisibleViewFieldNamesAsList();
        ArrayList<String> expectedFieldNames = new ArrayList<String>();
        expectedFieldNames.add("all");
        expectedFieldNames.add("v");
        expectedFieldNames.add("cev");
        expectedFieldNames.add("all_set");
        expectedFieldNames.add("v_set");
        expectedFieldNames.add("cev_set");
        FormConfigTest.assertEquals((String)"Visible fields wrong.", expectedFieldNames, (Object)fieldNames);
    }

    public void testGetSetsFromForm() {
        HashSet<String> expectedSetIds = new HashSet<String>();
        expectedSetIds.add("");
        expectedSetIds.add("details");
        expectedSetIds.add("user");
        FormConfigTest.assertEquals((String)"Set IDs were wrong.", expectedSetIds, this.defaultFormInContent.getSets().keySet());
        Map sets = this.defaultFormInContent.getSets();
        FormConfigTest.assertEquals((String)"Set parent was wrong.", (String)"details", (String)((FormSet)sets.get("user")).getParentId());
        FormConfigTest.assertEquals((String)"Set parent was wrong.", null, (String)((FormSet)sets.get("details")).getParentId());
        FormConfigTest.assertEquals((String)"Set parent was wrong.", (String)"fieldset", (String)((FormSet)sets.get("details")).getAppearance());
        FormConfigTest.assertEquals((String)"Set parent was wrong.", (String)"panel", (String)((FormSet)sets.get("user")).getAppearance());
        FormConfigTest.assertNull((Object)((FormSet)sets.get("details")).getTemplate());
        FormConfigTest.assertEquals((String)"custom-layout.ftl", (String)((FormSet)sets.get("user")).getTemplate());
    }

    public void testGetFieldsInTheDefaultSet_ViewEditCreate() {
        FormConfigElement setForm = this.readFormFromConfig("set_membership");
        String testSetId = "";
        String[] visibleViewFields_Create = setForm.getVisibleCreateFieldNamesForSet("");
        String[] visibleViewFields_Edit = setForm.getVisibleEditFieldNamesForSet("");
        String[] visibleViewFields_View = setForm.getVisibleViewFieldNamesForSet("");
        FormConfigTest.assertNotNull((Object)visibleViewFields_Create);
        FormConfigTest.assertNotNull((Object)visibleViewFields_Edit);
        FormConfigTest.assertNotNull((Object)visibleViewFields_View);
        FormConfigTest.assertEquals(Arrays.asList("all", "c", "ce", "cev"), Arrays.asList(visibleViewFields_Create));
        FormConfigTest.assertEquals(Arrays.asList("all", "e", "ce", "cev"), Arrays.asList(visibleViewFields_Edit));
        FormConfigTest.assertEquals(Arrays.asList("all", "v", "cev"), Arrays.asList(visibleViewFields_View));
    }

    public void testGetFieldsInASet_ViewEditCreate() {
        FormConfigElement setForm = this.readFormFromConfig("set_membership");
        String testSetId = "user";
        String[] visibleViewFields_Create = setForm.getVisibleCreateFieldNamesForSet("user");
        String[] visibleViewFields_Edit = setForm.getVisibleEditFieldNamesForSet("user");
        String[] visibleViewFields_View = setForm.getVisibleViewFieldNamesForSet("user");
        FormConfigTest.assertEquals(Arrays.asList(visibleViewFields_Create), Arrays.asList("all_set", "c_set", "ce_set", "cev_set"));
        FormConfigTest.assertEquals(Arrays.asList(visibleViewFields_Edit), Arrays.asList("all_set", "e_set", "ce_set", "cev_set"));
        FormConfigTest.assertEquals(Arrays.asList(visibleViewFields_View), Arrays.asList("all_set", "v_set", "cev_set"));
    }

    public void testGetRootSetsShouldReturnTheDefaultSetWhenNoSetsDeclared() throws Exception {
        FormConfigElement formWithoutSets = this.readFormFromConfig("form_without_sets");
        List rootSets = formWithoutSets.getRootSetsAsList();
        FormConfigTest.assertEquals((String)"A form without any explicit sets should return one root set.", (int)1, (int)rootSets.size());
        FormConfigTest.assertEquals((String)"The root set was incorrect.", (String)"", (String)((FormSet)rootSets.get(0)).getSetId());
        FormConfigTest.assertNull((Object)((FormSet)rootSets.get(0)).getParentId());
    }

    public void testGetVisibleFieldNamesForDefaultSet() throws Exception {
        FormConfigElement formWithoutSets = this.readFormFromConfig("form_without_sets");
        String testSetId = "";
        String[] visibleCreateFields = formWithoutSets.getVisibleCreateFieldNamesForSet("");
        String[] visibleEditFields = formWithoutSets.getVisibleEditFieldNamesForSet("");
        String[] visibleViewFields = formWithoutSets.getVisibleViewFieldNamesForSet("");
        List<String> expectedCreateFields = Arrays.asList("all", "c", "ce", "cev");
        List<String> expectedEditFields = Arrays.asList("all", "e", "ce", "cev");
        List<String> expectedViewFields = Arrays.asList("all", "v", "cev");
        FormConfigTest.assertEquals(expectedCreateFields, Arrays.asList(visibleCreateFields));
        FormConfigTest.assertEquals(expectedEditFields, Arrays.asList(visibleEditFields));
        FormConfigTest.assertEquals(expectedViewFields, Arrays.asList(visibleViewFields));
    }

    public void testAccessAllFieldRelatedData() {
        Map fields = this.defaultFormInContent.getFields();
        FormConfigTest.assertEquals((String)"Wrong number of Fields.", (int)5, (int)fields.size());
        FormField usernameField = (FormField)fields.get("username");
        FormConfigTest.assertNotNull((String)"usernameField was null.", (Object)usernameField);
        FormConfigTest.assertTrue((String)"Missing attribute.", (boolean)usernameField.getAttributes().containsKey("set"));
        FormConfigTest.assertEquals((String)"Incorrect attribute.", (String)"user", (String)((String)usernameField.getAttributes().get("set")));
        FormConfigTest.assertNull((String)"username field's template should be null.", (Object)usernameField.getControl().getTemplate());
        FormField nameField = (FormField)fields.get("name");
        String nameTemplate = nameField.getControl().getTemplate();
        FormConfigTest.assertNotNull((String)"name field had null template", (Object)nameTemplate);
        FormConfigTest.assertEquals((String)"name field had incorrect template.", (String)"alfresco/extension/formcontrols/my-name.ftl", (String)nameTemplate);
        List controlParams = nameField.getControl().getParamsAsList();
        FormConfigTest.assertNotNull((String)"name field should have control params.", (Object)controlParams);
        FormConfigTest.assertEquals((String)"name field has incorrect number of control params.", (int)1, (int)controlParams.size());
        ControlParam firstCP = (ControlParam)controlParams.iterator().next();
        FormConfigTest.assertEquals((String)"Control param has wrong name.", (String)"foo", (String)firstCP.getName());
        FormConfigTest.assertEquals((String)"Control param has wrong value.", (String)"bar", (String)firstCP.getValue());
        ConstraintHandlerDefinition regExConstraint = (ConstraintHandlerDefinition)nameField.getConstraintDefinitionMap().values().iterator().next();
        FormConfigTest.assertEquals((String)"name field had incorrect type.", (String)"REGEX", (String)regExConstraint.getType());
        FormConfigTest.assertEquals((String)"name field had incorrect message.", (String)"The name can not contain the character '{0}'", (String)regExConstraint.getMessage());
        FormConfigTest.assertEquals((String)"name field had incorrect message-id.", (String)"field_error_name", (String)regExConstraint.getMessageId());
    }

    public void testControlParamSequenceThatIncludesValuelessParamsParsesCorrectly() {
        Map fields = this.defaultFormInContent.getFields();
        FormField testField = (FormField)fields.get("fieldWithMixedCtrlParams");
        List controlParams = testField.getControl().getParamsAsList();
        FormConfigTest.assertNotNull((String)"field should have control params.", (Object)controlParams);
        FormConfigTest.assertEquals((String)"field has incorrect number of control params.", (int)4, (int)controlParams.size());
        FormConfigTest.assertEquals((String)"one", (String)((ControlParam)controlParams.get(0)).getName());
        FormConfigTest.assertEquals((String)"un", (String)((ControlParam)controlParams.get(0)).getValue());
        FormConfigTest.assertEquals((String)"two", (String)((ControlParam)controlParams.get(1)).getName());
        FormConfigTest.assertEquals((String)"deux", (String)((ControlParam)controlParams.get(1)).getValue());
        FormConfigTest.assertEquals((String)"three", (String)((ControlParam)controlParams.get(2)).getName());
        FormConfigTest.assertEquals((String)"", (String)((ControlParam)controlParams.get(2)).getValue());
        FormConfigTest.assertEquals((String)"four", (String)((ControlParam)controlParams.get(3)).getName());
        FormConfigTest.assertEquals((String)"quatre", (String)((ControlParam)controlParams.get(3)).getValue());
    }

    public void testFormsShouldSupportMultipleConstraintMessageTags() {
        FormField nameField = (FormField)this.defaultFormInContent.getFields().get("name");
        Map constraintDefinitions = nameField.getConstraintDefinitionMap();
        FormConfigTest.assertEquals((int)2, (int)constraintDefinitions.size());
        Iterator valuesIterator = constraintDefinitions.values().iterator();
        ConstraintHandlerDefinition regexField = (ConstraintHandlerDefinition)valuesIterator.next();
        ConstraintHandlerDefinition applesField = (ConstraintHandlerDefinition)valuesIterator.next();
        FormConfigTest.assertEquals((String)"REGEX", (String)regexField.getType());
        FormConfigTest.assertEquals((String)"LIMIT", (String)applesField.getType());
        FormConfigTest.assertEquals((String)"limit exceeded", (String)applesField.getMessage());
        FormConfigTest.assertEquals((String)"", (String)applesField.getMessageId());
    }

    public void testFormConfigElementShouldHaveNoChildren() {
        try {
            this.defaultFormInContent.getChildren();
            FormConfigTest.fail((String)"getChildren() did not throw an exception.");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.configService = this.initXMLConfigService(this.getConfigXmlFile());
        FormConfigTest.assertNotNull((String)"configService was null.", (Object)this.configService);
        Config contentConfig = this.configService.getConfig((Object)"content");
        FormConfigTest.assertNotNull((String)"contentConfig was null.", (Object)contentConfig);
        ConfigElement confElement = contentConfig.getConfigElement("forms");
        FormConfigTest.assertNotNull((String)"confElement was null.", (Object)confElement);
        FormConfigTest.assertTrue((String)"confElement should be instanceof FormsConfigElement.", (boolean)(confElement instanceof FormsConfigElement));
        this.formsConfigElement = (FormsConfigElement)confElement;
        this.defaultFormInContent = this.formsConfigElement.getDefaultForm();
        this.globalConfig = this.configService.getGlobalConfig();
        FormsConfigElement globalForms = (FormsConfigElement)this.globalConfig.getConfigElement("forms");
        this.defltCtrlsConfElement = globalForms.getDefaultControls();
        FormConfigTest.assertNotNull((String)"global default-controls element should not be null", (Object)this.defltCtrlsConfElement);
        this.globalConstraintHandlers = globalForms.getConstraintHandlers();
        FormConfigTest.assertNotNull((String)"global constraint-handlers element should not be null", (Object)this.globalConstraintHandlers);
    }

    private FormConfigElement readFormFromConfig(String condition) {
        Config setConfig = this.configService.getConfig((Object)condition);
        FormConfigTest.assertNotNull((String)"setConfig was null.", (Object)setConfig);
        ConfigElement confElement = setConfig.getConfigElement("forms");
        FormConfigTest.assertNotNull((String)"confElement was null.", (Object)confElement);
        FormConfigTest.assertTrue((String)"confElement should be instanceof FormsConfigElement.", (boolean)(confElement instanceof FormsConfigElement));
        FormsConfigElement setFormsConfigElement = (FormsConfigElement)confElement;
        FormConfigElement setForm = setFormsConfigElement.getDefaultForm();
        return setForm;
    }
}

