/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.web.config.forms.FormConfigElement;
import org.alfresco.web.config.forms.FormSet;
import org.springframework.extensions.config.ConfigException;

public class FormSetTest
extends TestCase {
    private FormConfigElement testElement;

    public FormSetTest(String name) {
        super(name);
    }

    public void setUp() {
        this.testElement = new FormConfigElement();
        this.testElement.addSet("root1", null, null, null, null);
        this.testElement.addSet("intermediate1", "root1", null, null, null);
        this.testElement.addSet("intermediate2", "root1", null, null, null);
        this.testElement.addSet("leaf1", "intermediate1", null, null, null);
        this.testElement.addSet("root2", null, null, null, null);
        this.testElement.addSet("root66", null, null, null, null);
        this.testElement.addSet("leaf2", "root66", null, null, null);
    }

    public void testGetSetIDsAreCorrect() {
        Map sets = this.testElement.getSets();
        ArrayList setNames = new ArrayList();
        setNames.addAll(sets.keySet());
        FormSetTest.assertEquals((String)"Error in set names.", (Object)this.testElement.getSetIDsAsList(), setNames);
        LinkedHashSet<String> expectedSetIDs = new LinkedHashSet<String>();
        expectedSetIDs.add("");
        expectedSetIDs.add("root1");
        expectedSetIDs.add("intermediate1");
        expectedSetIDs.add("intermediate2");
        expectedSetIDs.add("leaf1");
        expectedSetIDs.add("root2");
        expectedSetIDs.add("root66");
        expectedSetIDs.add("leaf2");
        FormSetTest.assertEquals(expectedSetIDs, sets.keySet());
    }

    public void testRootSetsCorrectlyIdentified() {
        List rootSets = this.testElement.getRootSetsAsList();
        FormSetTest.assertNotNull((Object)rootSets);
        FormSetTest.assertEquals((String)"Expecting 4 root sets", (int)4, (int)rootSets.size());
        FormSetTest.assertEquals((String)"", (String)((FormSet)rootSets.get(0)).getSetId());
        FormSetTest.assertEquals((String)"root1", (String)((FormSet)rootSets.get(1)).getSetId());
        FormSetTest.assertEquals((String)"root2", (String)((FormSet)rootSets.get(2)).getSetId());
        FormSetTest.assertEquals((String)"root66", (String)((FormSet)rootSets.get(3)).getSetId());
    }

    public void testRootSetsShouldHaveNoParent() {
        List rootSets = this.testElement.getRootSetsAsList();
        for (FormSet nextRoot : rootSets) {
            FormSetTest.assertNull((Object)nextRoot.getParent());
        }
    }

    public void testNavigationToChildSets() {
        Map allSets = this.testElement.getSets();
        FormSet root1 = (FormSet)allSets.get("root1");
        List root1Children = root1.getChildrenAsList();
        FormSetTest.assertEquals((String)"Expecting 2 children for root1", (int)2, (int)root1Children.size());
        FormSetTest.assertEquals((String)"intermediate1", (String)((FormSet)root1Children.get(0)).getSetId());
        FormSetTest.assertEquals((String)"intermediate2", (String)((FormSet)root1Children.get(1)).getSetId());
        FormSet root2 = (FormSet)allSets.get("root2");
        List root2Children = root2.getChildrenAsList();
        FormSetTest.assertEquals((String)"Expecting 0 children for root2", (int)0, (int)root2Children.size());
    }

    public void testNavigationToParentSets() {
        Map allSets = this.testElement.getSets();
        FormSet leaf2 = (FormSet)allSets.get("leaf2");
        FormSetTest.assertEquals((String)"root66", (String)leaf2.getParent().getSetId());
    }

    public void testDetectCyclicAncestors() {
        try {
            FormConfigElement brokenFormElement = new FormConfigElement();
            brokenFormElement.addSet("root", "leaf", null, null, null);
            brokenFormElement.addSet("leaf", "root", null, null, null);
        }
        catch (ConfigException expected) {
            return;
        }
        FormSetTest.fail((String)"Expected exception not thrown.");
    }

    public void testCannotGiveTheDefaultSetAParent() throws Exception {
        try {
            this.testElement.addSet("", "root1", null, null, null);
        }
        catch (ConfigException expected) {
            expected.toString();
            return;
        }
        FormSetTest.fail((String)"Expected exception not thrown.");
    }
}

