/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.service;

import freemarker.core.Environment;
import freemarker.template.Template;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.alfresco.module.aosmodule.service.AuthenticationServiceUserData;
import org.alfresco.module.aosmodule.service.FileDialogSortDir;
import org.alfresco.module.aosmodule.service.FileDialogSortField;
import org.alfresco.module.aosmodule.service.FileDialogWebViewConfiguration;
import org.alfresco.module.aosmodule.service.FileDialogWebViewRegistry;
import org.alfresco.module.aosmodule.vfs.AlfrescoVirtualFileSystem;
import org.alfresco.module.aosmodule.vfs.DocumentNode;
import org.alfresco.module.aosmodule.vfs.FolderNode;
import org.alfresco.officeservices.AbstractBrowsingService;
import org.alfresco.officeservices.URLEncoder;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.vfs.VFSNode;
import org.alfresco.officeservices.vfs.VirtualFileSystem;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class BrowsingService
extends AbstractBrowsingService {
    private static final long serialVersionUID = -4790039946289453732L;
    protected VirtualFileSystem vfs;
    protected FileDialogWebViewRegistry webViewRegistry;
    protected AuthenticationService authenticationService;
    private NamespaceService namespaceService;
    protected Logger logger = LoggerFactory.getLogger(BrowsingService.class);
    public static final String IMAGE_PREFIX = "images/filetypes/";
    public static final String IMAGE_POSTFIX = ".gif";
    public static final String DEFAULT_IMAGE = "images/filetypes/_default.gif";
    protected static URLEncoder urlEncoder = new URLEncoder(URLEncoder.ALPHANUMERIC);

    public void init() throws ServletException {
        super.init();
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        if (wac == null) {
            throw new ServletException("Error initializing Servlet. No WebApplicationContext available.");
        }
        this.vfs = (VirtualFileSystem)wac.getBean("AosVirtualFileSystem");
        if (this.vfs == null) {
            throw new ServletException("Cannot find bean AosVirtualFileSystem in WebApplicationContext.");
        }
        ((AlfrescoVirtualFileSystem)this.vfs).prepare();
        this.webViewRegistry = (FileDialogWebViewRegistry)wac.getBean("AosFileDialogWebViewRegistry");
        if (this.webViewRegistry == null) {
            throw new ServletException("Cannot find bean aosFileDialogWebViewRegistry in WebApplicationContext.");
        }
        this.authenticationService = (AuthenticationService)wac.getBean("AuthenticationService");
        if (this.authenticationService == null) {
            throw new ServletException("Cannot find bean AuthenticationService in WebApplicationContext.");
        }
        this.namespaceService = (NamespaceService)wac.getBean("NamespaceService");
        if (this.namespaceService == null) {
            throw new ServletException("Cannot find bean NamespaceService in WebApplicationContext.");
        }
    }

    public void doFileDialog(UserData userData, boolean saveAs, String location, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, AuthenticationRequiredException {
        String normalizedLocation = AlfrescoVirtualFileSystem.normalizePath(location);
        FileDialogWebViewConfiguration webViewConfig = this.webViewRegistry.getConfiguration(normalizedLocation);
        if (webViewConfig == null || webViewConfig.getFreeMarkerTemplateLocation() == null) {
            this.doFileDialogNoTemplateError(response, null);
            return;
        }
        InputStream templateInputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(webViewConfig.getFreeMarkerTemplateLocation());
        if (templateInputStream == null) {
            this.doFileDialogNoTemplateError(response, webViewConfig.getFreeMarkerTemplateLocation());
            return;
        }
        VFSNode node = this.vfs.getNodeByPath(userData, normalizedLocation, 2);
        if (node == null) {
            response.setStatus(404);
            return;
        }
        String baseUrl = ((AlfrescoVirtualFileSystem)this.vfs).getSitePrefix(request) + normalizedLocation;
        List subNodes = node.getEnumerableContainees(userData, 2);
        ArrayList<ItemData> itemDataList = new ArrayList<ItemData>();
        for (VFSNode n : subNodes) {
            itemDataList.add(new ItemData(n, baseUrl));
        }
        FileDialogSortField sortField = FileDialogSortField.valueOfOrDefault(request.getParameter("SortField"));
        FileDialogSortDir sortDir = FileDialogSortDir.valueOfOrDefault(request.getParameter("SortDir"));
        Collections.sort(itemDataList, new ItemDataComperator(sortField, sortDir));
        HashMap<String, Object> freeMarkerMap = new HashMap<String, Object>();
        freeMarkerMap.put("resourcesUrl", ((AlfrescoVirtualFileSystem)this.vfs).getSitePrefix(request) + "/_aos_resources");
        freeMarkerMap.put("location", urlEncoder.encode(location));
        freeMarkerMap.put("items", itemDataList);
        freeMarkerMap.put("sortField", sortField.toString());
        freeMarkerMap.put("sortDir", sortDir.toString());
        freeMarkerMap.put("type", I18NUtil.getMessage((String)"aos.webview.type"));
        freeMarkerMap.put("name", I18NUtil.getMessage((String)"aos.webview.name"));
        freeMarkerMap.put("modified_by", I18NUtil.getMessage((String)"aos.webview.modified_by"));
        freeMarkerMap.put("modified", I18NUtil.getMessage((String)"aos.webview.modified"));
        freeMarkerMap.put("checked_out_by", I18NUtil.getMessage((String)"aos.webview.checked_out_by"));
        freeMarkerMap.put("sort_by_type", I18NUtil.getMessage((String)"aos.webview.sort_by_type"));
        freeMarkerMap.put("sort_by_name", I18NUtil.getMessage((String)"aos.webview.sort_by_name"));
        freeMarkerMap.put("sort_by_modified_by", I18NUtil.getMessage((String)"aos.webview.sort_by_name"));
        freeMarkerMap.put("sort_by_modified", I18NUtil.getMessage((String)"aos.webview.sort_by_modified"));
        freeMarkerMap.put("sort_by_checked_out_by", I18NUtil.getMessage((String)"aos.webview.sort_by_checked_out_by"));
        try {
            Template template = new Template("FileDialog", (Reader)new InputStreamReader(templateInputStream), null);
            response.setContentType("text/html; charset=utf-8");
            response.flushBuffer();
            Environment env = template.createProcessingEnvironment(freeMarkerMap, (Writer)response.getWriter());
            env.setOutputEncoding("utf-8");
            env.process();
            response.getWriter().flush();
        }
        catch (Exception e) {
            this.logger.error("Error processing FreeMarker template for file dialog", (Throwable)e);
            this.doFileDialogException(response, e);
        }
    }

    public void doFileDialogNoTemplateError(HttpServletResponse response, String templateLocation) throws ServletException, IOException {
        PrintWriter w = response.getWriter();
        w.write("<html>\n");
        w.write("<head>\n");
        w.print("<style>");
        w.print("<!--");
        w.write(" html { margin: 0; padding: 0; }");
        w.write(" body { margin: 0; padding: 0; color: WindowText; background: Window url(images/blank.gif) fixed; color: #000000; overflow: hidden; border: 0; font: menu;font-size: 11px !important; background-color: ThreedFace; color: WindowText; }");
        w.print(" -->");
        w.print("</style>\n");
        w.write("</head>\n");
        w.write("<body servertype=\"OWS\" docLibsList=\"\">\n");
        w.write("<p>&nbsp;</p>\n");
        w.write("<p><b>Error:</b></p>\n");
        if (templateLocation == null) {
            w.write("<p>No FreeMarker Template defined for this path.</p>\n");
        } else {
            w.write("<p>Cannot find FreeMarker template. Classpath location:<br/>\n");
            w.write(WebDAVHelper.encodeHTML((String)templateLocation));
            w.write("</p>\n");
        }
        w.write("</body>\n");
        w.write("</html>\n");
    }

    public void doFileDialogException(HttpServletResponse response, Exception e) throws ServletException, IOException {
        PrintWriter w = response.getWriter();
        w.write("<html>\n");
        w.write("<head>\n");
        w.print("<style>");
        w.print("<!--");
        w.write(" html { margin: 0; padding: 0; }");
        w.write(" body { margin: 0; padding: 0; color: WindowText; background: Window url(images/blank.gif) fixed; color: #000000; overflow: scroll; border: 0; font: menu;font-size: 11px !important; background-color: ThreedFace; color: WindowText; }");
        w.print(" -->");
        w.print("</style>\n");
        w.write("</head>\n");
        w.write("<body servertype=\"OWS\" docLibsList=\"\">\n");
        w.write("<p>&nbsp;</p>\n");
        w.write("<p><b>" + WebDAVHelper.encodeHTML((String)e.getMessage()) + "</b></p>\n");
        w.write("<p>\n");
        for (StackTraceElement ste : e.getStackTrace()) {
            w.write("&nbsp;at ");
            w.write(WebDAVHelper.encodeHTML((String)ste.getClassName()));
            w.write(".");
            w.write(WebDAVHelper.encodeHTML((String)ste.getMethodName()));
            w.write("(");
            w.write(WebDAVHelper.encodeHTML((String)ste.getFileName()));
            w.write(":");
            w.write(ste.getLineNumber());
            w.write(")");
            w.write("<br/>\n");
        }
        w.write("</p>\n");
        w.write("</body>\n");
        w.write("</html>\n");
    }

    public void doPropertiesDialog(UserData userData, String location, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, AuthenticationRequiredException {
        response.sendError(500);
    }

    public UserData negotiateAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return new AuthenticationServiceUserData(this.authenticationService);
    }

    public void requestAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    public void invalidateAuthentication(UserData userData, HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    static {
        urlEncoder.addUnencodedCharacter('-');
        urlEncoder.addUnencodedCharacter('_');
        urlEncoder.addUnencodedCharacter('.');
        urlEncoder.addUnencodedCharacter('*');
        urlEncoder.addUnencodedCharacter('/');
        urlEncoder.addUnencodedCharacter(':');
    }

    public class ItemData {
        private VFSNode node;
        private String baseUrl;

        public ItemData(VFSNode node, String baseUrl) {
            this.node = node;
            this.baseUrl = baseUrl;
        }

        public boolean isFolder() {
            return this.node instanceof FolderNode;
        }

        public String getUrl() {
            StringBuilder sb = new StringBuilder(this.baseUrl);
            if (!this.baseUrl.endsWith("/")) {
                sb.append("/");
            }
            sb.append(this.getName());
            return urlEncoder.encode(sb.toString());
        }

        public String getName() {
            return this.node.getName(2);
        }

        public String getProperty(String propName) {
            NodeRef nodeRef;
            NodeService nodeService = ((AlfrescoVirtualFileSystem)BrowsingService.this.vfs).getNodeService();
            QName qname = null;
            try {
                qname = QName.createQName((String)propName, (NamespacePrefixResolver)BrowsingService.this.namespaceService);
            }
            catch (NamespaceException e) {
                BrowsingService.this.logger.debug("Property is not a valid QName", (Throwable)e);
                return "";
            }
            FileInfo fileInfo = null;
            if (this.node instanceof DocumentNode) {
                fileInfo = ((DocumentNode)this.node).getFileInfo();
            } else if (this.node instanceof FolderNode) {
                fileInfo = ((FolderNode)this.node).getFileInfo();
            }
            if (fileInfo != null && this.hasProperty(nodeRef = fileInfo.getNodeRef(), qname)) {
                return nodeService.getProperty(nodeRef, qname).toString();
            }
            return "";
        }

        public boolean hasProperty(NodeRef nodeRef, QName qname) {
            return ((AlfrescoVirtualFileSystem)BrowsingService.this.vfs).getNodeService().getProperties(nodeRef).containsKey(qname);
        }

        public String getModifiedBy() {
            if (this.node instanceof DocumentNode) {
                return ((DocumentNode)this.node).getModifier();
            }
            return "";
        }

        public Date getDateLastModified() {
            return this.node.getDateLastModified(2);
        }

        public String getLastModified() {
            return this.getDateLastModified().toString();
        }

        public String getCheckedOutTo() {
            if (this.node instanceof DocumentNode) {
                String coOwner = ((DocumentNode)this.node).getCheckoutOwner();
                return coOwner == null ? "" : coOwner;
            }
            return "";
        }

        public String getFileTypeImage() {
            String fileName = this.getName();
            Object image = BrowsingService.DEFAULT_IMAGE;
            int extIndex = fileName.lastIndexOf(46);
            if (extIndex != -1 && fileName.length() > extIndex + 1) {
                String ext = fileName.substring(extIndex + 1).toLowerCase();
                image = BrowsingService.IMAGE_PREFIX + ext + BrowsingService.IMAGE_POSTFIX;
            }
            return image;
        }
    }

    private class ItemDataComperator
    implements Comparator<ItemData> {
        private FileDialogSortField sortField;
        private FileDialogSortDir sortDir;

        public ItemDataComperator(FileDialogSortField sortField, FileDialogSortDir sortDir) {
            this.sortField = sortField;
            this.sortDir = sortDir;
        }

        @Override
        public int compare(ItemData o1, ItemData o2) {
            int result = 0;
            if (o1.isFolder() != o2.isFolder()) {
                result = o1.isFolder() ? -1 : 1;
            } else {
                switch (this.sortField) {
                    case TYPE: {
                        result = this.getFileExtension(o1.getName()).compareToIgnoreCase(this.getFileExtension(o2.getName()));
                        break;
                    }
                    case NAME: {
                        result = o1.getName().compareToIgnoreCase(o2.getName());
                        break;
                    }
                    case MODIFIED_BY: {
                        result = o1.getModifiedBy().compareToIgnoreCase(o2.getModifiedBy());
                        break;
                    }
                    case MODIFIED: {
                        result = o1.getDateLastModified().compareTo(o2.getDateLastModified());
                        break;
                    }
                    case CHECKED_OUT_BY: {
                        result = o1.getCheckedOutTo().compareToIgnoreCase(o2.getCheckedOutTo());
                    }
                }
                if (result == 0 && this.sortField != FileDialogSortField.NAME) {
                    result = o1.getName().compareToIgnoreCase(o2.getName());
                }
            }
            if (this.sortDir == FileDialogSortDir.DESC) {
                result *= -1;
            }
            return result;
        }

        private String getFileExtension(String str) {
            int extIndex = str.lastIndexOf(46);
            return extIndex < 0 ? "" : str.substring(extIndex);
        }
    }
}

