/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.service;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.module.aosmodule.service.AuthenticationServiceUserData;
import org.alfresco.module.aosmodule.vfs.AlfrescoVirtualFileSystem;
import org.alfresco.officeservices.GetWebCollectionWebDescription;
import org.alfresco.officeservices.GetWebWebDescription;
import org.alfresco.officeservices.StandardWebsService;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.WebsGetContentTypeContentType;
import org.alfresco.officeservices.WebsGetContentTypesContentType;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.protocol.SimpleSoapParser;
import org.alfresco.officeservices.protocol.SoapParameter;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class WebsService
extends StandardWebsService {
    private static final long serialVersionUID = -4811811494131468815L;
    protected AlfrescoVirtualFileSystem vfs;
    protected AuthenticationService authenticationService;
    protected List<String> serviceNames = new ArrayList<String>();

    public void init(ServletConfig servletConfig_p) throws ServletException {
        super.init(servletConfig_p);
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        if (wac == null) {
            throw new ServletException("Error initializing Servlet. No WebApplicationContext available.");
        }
        this.vfs = (AlfrescoVirtualFileSystem)wac.getBean("AosVirtualFileSystem");
        if (this.vfs == null) {
            throw new ServletException("Cannot find bean AosVirtualFileSystem in WebApplicationContext.");
        }
        this.vfs.prepare();
        this.authenticationService = (AuthenticationService)wac.getBean("AuthenticationService");
        if (this.authenticationService == null) {
            throw new ServletException("Cannot find bean AuthenticationService in WebApplicationContext.");
        }
        if (this.vfs.getSitePathOverwrite() != null) {
            this.serviceNames.add(this.vfs.getSitePathOverwrite().equals("/") ? "" : this.vfs.getSitePathOverwrite());
        } else {
            this.serviceNames.add(servletConfig_p.getServletContext().getContextPath() + "/aos");
        }
    }

    public List<String> getServicePrefixes(SimpleSoapParser parser, HttpServletRequest request) {
        return this.serviceNames;
    }

    protected String getServerUrl(HttpServletRequest request) {
        String protocol = request.isSecure() ? "https://" : "http://";
        int defaultPort = request.isSecure() ? 443 : 80;
        String portString = request.getLocalPort() != defaultPort ? ":" + Integer.toString(request.getLocalPort()) : "";
        return protocol + request.getServerName() + portString;
    }

    public List<GetWebCollectionWebDescription> getWebCollection(SimpleSoapParser parser, HttpServletRequest request) {
        return new ArrayList<GetWebCollectionWebDescription>(0);
    }

    protected GetWebWebDescription getWebResult(UserData userData, String webUrl, SimpleSoapParser parser, HttpServletRequest request) {
        return null;
    }

    public UserData negotiateAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return new AuthenticationServiceUserData(this.authenticationService);
    }

    public void requestAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    public void invalidateAuthentication(UserData userData, HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    public WebsGetContentTypesContentType[] getContentTypes(SimpleSoapParser parser, HttpServletRequest request) {
        return null;
    }

    protected WebsGetContentTypeContentType getContentType(UserData userData, String contentTypeId, HttpServletRequest request) throws AuthenticationRequiredException {
        return null;
    }

    protected boolean updateContentTypeXmlDocument(UserData userData, String contentTypeId, SoapParameter newDocument, HttpServletRequest request) throws AuthenticationRequiredException {
        return false;
    }
}

