/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.vfs;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.aosmodule.metadata.ContentFilter;
import org.alfresco.module.aosmodule.metadata.ContentFilterProcessingResult;
import org.alfresco.module.aosmodule.vfs.ContentResponse;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.io.IOUtils;

public class FilteredContentResponse
implements ContentResponse {
    protected byte[] filteredContent = null;
    protected File tempFile = null;
    public static final long TEMP_FILE_THRESHOLD = 102400L;

    public FilteredContentResponse(File tempFile) {
        this.tempFile = tempFile;
    }

    public FilteredContentResponse(byte[] filteredContent) {
        this.filteredContent = filteredContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentResponse createContentResponse(NodeRef nodeRef, ContentReader contentReader, ContentFilter contentFilter) {
        OutputStream tempStorageOutputStream;
        if (contentReader == null) {
            throw new AlfrescoRuntimeException("FilteredContentResponse cannot be created without a ContentReader");
        }
        File tempFileBuffer = null;
        if (contentReader.getSize() > 102400L) {
            try {
                tempFileBuffer = TempFileProvider.createTempFile((String)"FilteredContentResponse", (String)"tmp");
                tempStorageOutputStream = new FileOutputStream(tempFileBuffer);
            }
            catch (IOException ioe) {
                throw new AlfrescoRuntimeException("Error creating temp file for document filtering", (Throwable)ioe);
            }
        } else {
            tempStorageOutputStream = new ByteArrayOutputStream();
        }
        boolean isFiltered = false;
        InputStream contentInputStream = contentReader.getContentInputStream();
        try {
            ContentFilterProcessingResult processingResult = contentFilter.process(nodeRef, contentInputStream, tempStorageOutputStream, true);
            isFiltered = processingResult != null && processingResult.isModified();
        }
        catch (IOException ioe) {
            isFiltered = false;
        }
        finally {
            try {
                contentInputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (!isFiltered) {
            try {
                tempStorageOutputStream.close();
                if (tempFileBuffer != null) {
                    tempFileBuffer.delete();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        if (tempStorageOutputStream instanceof ByteArrayOutputStream) {
            return new FilteredContentResponse(((ByteArrayOutputStream)tempStorageOutputStream).toByteArray());
        }
        return new FilteredContentResponse(tempFileBuffer);
    }

    @Override
    public long getSize() {
        if (this.filteredContent != null) {
            return this.filteredContent.length;
        }
        if (this.tempFile != null) {
            return this.tempFile.length();
        }
        return 0L;
    }

    @Override
    public void emitContent(OutputStream out) throws IOException, ContentIOException {
        if (this.filteredContent != null) {
            out.write(this.filteredContent);
        } else if (this.tempFile != null) {
            try (FileInputStream fis = new FileInputStream(this.tempFile);){
                IOUtils.copy((InputStream)fis, (OutputStream)out);
            }
        }
    }

    @Override
    public InputStream getContentInputStream() throws IOException, ContentIOException {
        return new FileInputStream(this.tempFile);
    }

    @Override
    public void releaseResources() {
        this.tempFile.delete();
    }
}

