/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.aos;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.alfresco.module.aosmodule.auth.service.AosAuthenticationCookiesService;
import org.alfresco.module.aosmodule.auth.service.AosAuthenticationUriService;
import org.alfresco.module.aosmodule.auth.service.AosIDSContextService;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.web.scripts.aos.AbstractAosWebScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class AosAuthenticateResponse
extends AbstractAosWebScript {
    private static final Logger LOG = LoggerFactory.getLogger(AosAuthenticateResponse.class);
    private final AosAuthenticationCookiesService cookiesService;
    private final AosAuthenticationUriService uriService;
    private final AosIDSContextService idsContextService;

    public AosAuthenticateResponse(AosAuthenticationCookiesService cookiesService, AosAuthenticationUriService uriService, AosIDSContextService idsContextService) {
        this.cookiesService = cookiesService;
        this.uriService = uriService;
        this.idsContextService = idsContextService;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        HttpServletRequest servletRequest = this.findServletRequest(req);
        HttpServletResponse servletResponse = this.findServletResponse(res);
        IdentityServiceFacade identityServiceFacade = this.idsContextService.getIdentityServiceBean(IdentityServiceFacade.class);
        if (servletRequest != null && servletResponse != null) {
            try {
                if (identityServiceFacade == null) {
                    throw new AuthenticationException("IdentityServiceFacade is not available.");
                }
                IdentityServiceFacade.AccessTokenAuthorization authorization = identityServiceFacade.authorize(IdentityServiceFacade.AuthorizationGrant.authorizationCode((String)servletRequest.getParameter("code"), (String)this.uriService.getAuthenticateResponseURI()));
                if (authorization.getRefreshTokenValue() == null) {
                    throw new AuthenticationException("Cannot retrieve auth token: AccessTokenResponse is null");
                }
                IdentityServiceFacade.AccessToken accessToken = authorization.getAccessToken();
                this.cookiesService.addCookie("ALFRESCO_AOS_TOKEN_EXPIRATION", String.valueOf(accessToken.getExpiresAt().toEpochMilli()), servletResponse);
                this.cookiesService.addCookie("ALFRESCO_AOS_TOKEN", accessToken.getTokenValue(), servletResponse);
                this.cookiesService.addCookie("ALFRESCO_AOS_REFRESH_TOKEN", authorization.getRefreshTokenValue(), servletResponse);
                servletResponse.sendRedirect(this.uriService.getAuthenticateResponseSuccessURI());
            }
            catch (Exception e) {
                LOG.error("Error while trying to retrieve auth token: {}", (Object)e.getMessage());
                AosAuthenticateResponse.writeResponse(res, "Authentication failed.");
            }
        }
    }

    private static void writeResponse(WebScriptResponse res, String responseBody) throws IOException {
        res.setStatus(200);
        res.setContentEncoding("UTF-8");
        res.setHeader("length", String.valueOf(responseBody.getBytes().length));
        res.getWriter().write(responseBody);
        res.getWriter().flush();
        res.getWriter().close();
    }
}

