/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.alfresco.officeservices.AbstractSoapService;
import org.alfresco.officeservices.ServiceLogger;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.protocol.SimpleSoapParser;

public abstract class AbstractSiteDataService
extends AbstractSoapService {
    private static final long serialVersionUID = 1952238668637268008L;
    private static final ServiceLogger logger = new ServiceLogger(AbstractSiteDataService.class);
    public static final String METHODNAME_GETURLSEGMENTS = "GetURLSegments";
    public static final String METHODPARAMETER_STRURL = "strURL";

    @Override
    public void soapService(UserData userData, String methodName, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (methodName.equals(METHODNAME_GETURLSEGMENTS)) {
            this.handleGetUrlSegments(userData, parser, request, response);
        } else {
            logger.error("soapService: unknown RPC methodname " + methodName);
            SimpleSoapParser.soapErrorResponse(response, "Unknown methodname.");
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected void handleGetUrlSegments(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        String strUrl;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((strUrl = parser.getParameter(METHODPARAMETER_STRURL)) == null) {
            logger.error("handleGetUrlSegments: Parameter \"strURL\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter strURL");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("handleGetUrlSegments: strUrl=" + strUrl);
        }
        boolean urlSegments = this.getUrlSegmentsResult(strUrl, parser, request);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)bos, false, "utf-8");
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<GetURLSegmentsResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<GetURLSegmentsResult>");
        if (urlSegments) {
            out.print("true");
        } else {
            out.print("false");
        }
        out.print("</GetURLSegmentsResult>");
        out.print("</GetURLSegmentsResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType("text/xml; charset=utf-8");
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract boolean getUrlSegmentsResult(String var1, SimpleSoapParser var2, HttpServletRequest var3);
}

