/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.alfresco.officeservices.AbstractSoapService;
import org.alfresco.officeservices.ServiceLogger;
import org.alfresco.officeservices.URLPathDecoder;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.protocol.HtmlEncoder;
import org.alfresco.officeservices.protocol.SimpleSoapParser;

public abstract class AbstractVersionsService
extends AbstractSoapService {
    private static final long serialVersionUID = 746082483674875387L;
    private static final ServiceLogger logger = new ServiceLogger(AbstractVersionsService.class);
    public static final String METHODNAME_GETVERSIONS = "GetVersions";
    public static final String METHODNAME_RESTOREVERSION = "RestoreVersion";
    public static final String METHODPARAMETER_FILENAME = "fileName";
    public static final String METHODPARAMETER_FILEVERSION = "fileVersion";
    protected static final String RESPONSE_CONTENT_TYPE = "text/xml; charset=utf-8";

    @Override
    public void soapService(UserData userData, String methodName, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (methodName.equals(METHODNAME_GETVERSIONS)) {
            this.handleGetVersions(userData, parser, request, response);
        } else if (methodName.equals(METHODNAME_RESTOREVERSION)) {
            this.handleRestoreVersion(userData, parser, request, response);
        } else {
            logger.error("soapService: unknown RPC methodname " + methodName);
            SimpleSoapParser.soapErrorResponse(response, "Unknown methodname.");
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract List<VersionInformation> getVersions(UserData var1, String var2, String var3) throws AuthenticationRequiredException;

    public abstract String getListGUID(UserData var1, String var2);

    public abstract String getSettingsURL(UserData var1, String var2, String var3);

    public abstract DateFormat getDateFormat();

    protected String getSitePrefix(HttpServletRequest request) {
        String protocol = request.isSecure() ? "https://" : "http://";
        int defaultPort = request.isSecure() ? 443 : 80;
        String portString = request.getLocalPort() != defaultPort ? ":" + Integer.toString(request.getLocalPort()) : "";
        return protocol + request.getServerName() + portString + request.getContextPath();
    }

    protected void handleGetVersions(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        String filename;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((filename = parser.getParameter(METHODPARAMETER_FILENAME)) == null) {
            logger.error("handleGetVersions: Parameter \"fileName\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter fileName");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        String baseUrl = this.getSitePrefix(request);
        if (logger.isDebugEnabled()) {
            logger.debug("handleGetVersions: baseUrl=" + baseUrl);
        }
        if (filename.length() >= baseUrl.length() && filename.substring(0, baseUrl.length()).equalsIgnoreCase(baseUrl) && (filename = filename.substring(baseUrl.length())).length() > 1 && filename.charAt(0) == '/') {
            filename = filename.substring(1);
        }
        try {
            filename = URLPathDecoder.decode(filename, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            logger.debug("UTF-8 Encoding not supported", uee);
        }
        List<VersionInformation> versions = this.getVersions(userData, baseUrl, filename);
        if (versions == null) {
            logger.error("handleGetVersions: Error getting document versions. Got NULL instead of list of versions. fileName=" + filename);
            SimpleSoapParser.soapErrorResponse(response, "Ereror getting document versions.");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        String guid = this.getListGUID(userData, filename);
        String settingsurl = this.getSettingsURL(userData, baseUrl, filename);
        if (logger.isDebugEnabled()) {
            logger.debug("handleGetVersions: guid=" + guid);
            logger.debug("handleGetVersions: settingsurl=" + settingsurl);
        }
        response.setContentType(RESPONSE_CONTENT_TYPE);
        ServletOutputStream out = response.getOutputStream();
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<");
        out.print(METHODNAME_GETVERSIONS);
        out.print("Response xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<");
        out.print(METHODNAME_GETVERSIONS);
        out.print("Result>");
        out.print("<results xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<list id=\"" + guid + "\" />");
        out.print("<versioning enabled=\"1\" />");
        out.print("<settings url=\"");
        HtmlEncoder.writeEncoded(out, settingsurl, "UTF-8");
        out.print("\" />");
        DateFormat displayDateFormat = this.getDateFormat();
        for (VersionInformation version : versions) {
            out.print("<result");
            out.print(" version=\"");
            HtmlEncoder.writeEncoded(out, version.version, "UTF-8");
            out.print("\"");
            out.print(" url=\"");
            HtmlEncoder.writeEncoded(out, version.url, "UTF-8");
            out.print("\"");
            out.print(" created=\"");
            HtmlEncoder.writeEncoded(out, displayDateFormat.format(version.created), "UTF-8");
            out.print("\"");
            out.print(" createdRaw=\"");
            HtmlEncoder.writeEncoded(out, AbstractVersionsService.formatDate(version.created), "UTF-8");
            out.print("\"");
            out.print(" createdBy=\"");
            HtmlEncoder.writeEncoded(out, version.createdByUsername, "UTF-8");
            out.print("\"");
            out.print(" createdByName=\"");
            HtmlEncoder.writeEncoded(out, version.createdByDisplayName, "UTF-8");
            out.print("\"");
            out.print(" size=\"");
            HtmlEncoder.writeEncoded(out, version.size, "UTF-8");
            out.print("\"");
            out.print(" comments=\"");
            HtmlEncoder.writeEncoded(out, version.comments, "UTF-8");
            out.print("\"");
            out.print(" />");
        }
        out.print("</results>");
        out.print("</");
        out.print(METHODNAME_GETVERSIONS);
        out.print("Result>");
        out.print("</");
        out.print(METHODNAME_GETVERSIONS);
        out.print("Response>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract boolean restoreVersion(UserData var1, String var2, String var3) throws AuthenticationRequiredException;

    protected void handleRestoreVersion(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        String fileName;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((fileName = parser.getParameter(METHODPARAMETER_FILENAME)) == null) {
            logger.error("handleRestoreVersion: Parameter \"fileName\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter fileName");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        String fileVersion = parser.getParameter(METHODPARAMETER_FILEVERSION);
        if (fileVersion == null) {
            logger.error("handleRestoreVersion: Parameter \"fileVersion\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter fileVersion");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        String baseUrl = this.getSitePrefix(request);
        if (logger.isDebugEnabled()) {
            logger.debug("handleRestoreVersion: baseUrl=" + baseUrl);
        }
        if (fileName.length() >= baseUrl.length() && fileName.substring(0, baseUrl.length()).equalsIgnoreCase(baseUrl) && (fileName = fileName.substring(baseUrl.length())).length() > 1 && fileName.charAt(0) == '/') {
            fileName = fileName.substring(1);
        }
        if (!this.restoreVersion(userData, fileName, fileVersion)) {
            logger.error("handleRestoreVersion: Error restoring document version. fileName=" + fileName + " fileVersion=" + fileVersion);
            SimpleSoapParser.soapErrorResponse(response, "Ereror restoring document version.");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        List<VersionInformation> versions = this.getVersions(userData, baseUrl, fileName);
        if (versions == null) {
            logger.error("handleRestoreVersion: Error getting document versions. Got NULL instead of list of versions. fileName=" + fileName);
            SimpleSoapParser.soapErrorResponse(response, "Ereror getting document versions.");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        String guid = this.getListGUID(userData, fileName);
        String settingsurl = this.getSettingsURL(userData, baseUrl, fileName);
        if (logger.isDebugEnabled()) {
            logger.debug("handleRestoreVersion: guid=" + guid);
            logger.debug("handleRestoreVersion: settingsurl=" + settingsurl);
        }
        response.setContentType(RESPONSE_CONTENT_TYPE);
        ServletOutputStream out = response.getOutputStream();
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<");
        out.print(METHODNAME_RESTOREVERSION);
        out.print("Response xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<");
        out.print(METHODNAME_RESTOREVERSION);
        out.print("Result>");
        out.print("<results xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<list id=\"" + guid + "\" />");
        out.print("<versioning enabled=\"1\" />");
        out.print("<settings url=\"");
        HtmlEncoder.writeEncoded(out, settingsurl, "UTF-8");
        out.print("\" />");
        DateFormat displayDateFormat = this.getDateFormat();
        for (VersionInformation version : versions) {
            out.print("<result");
            out.print(" version=\"");
            HtmlEncoder.writeEncoded(out, version.version, "UTF-8");
            out.print("\"");
            out.print(" url=\"");
            HtmlEncoder.writeEncoded(out, version.url, "UTF-8");
            out.print("\"");
            out.print(" created=\"");
            HtmlEncoder.writeEncoded(out, displayDateFormat.format(version.created), "UTF-8");
            out.print("\"");
            out.print(" createdRaw=\"");
            HtmlEncoder.writeEncoded(out, AbstractVersionsService.formatDate(version.created), "UTF-8");
            out.print("\"");
            out.print(" createdBy=\"");
            HtmlEncoder.writeEncoded(out, version.createdByUsername, "UTF-8");
            out.print("\"");
            out.print(" createdByName=\"");
            HtmlEncoder.writeEncoded(out, version.createdByDisplayName, "UTF-8");
            out.print("\"");
            out.print(" size=\"");
            HtmlEncoder.writeEncoded(out, version.size, "UTF-8");
            out.print("\"");
            out.print(" comments=\"");
            HtmlEncoder.writeEncoded(out, version.comments, "UTF-8");
            out.print("\"");
            out.print(" />");
        }
        out.print("</results>");
        out.print("</");
        out.print(METHODNAME_RESTOREVERSION);
        out.print("Result>");
        out.print("</");
        out.print(METHODNAME_RESTOREVERSION);
        out.print("Response>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected static class VersionInformation {
        protected String version;
        protected String url;
        protected Date created;
        protected String createdByUsername;
        protected String createdByDisplayName;
        protected String size;
        protected String comments;

        public VersionInformation(String version, String url, Date created, String createdByUsername, String createdByDisplayName, String size, String comments) {
            this.version = version;
            this.url = url;
            this.created = created;
            this.createdByUsername = createdByUsername;
            this.createdByDisplayName = createdByDisplayName;
            this.size = size;
            this.comments = comments;
        }
    }
}

