/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices;

import java.io.IOException;
import java.util.List;
import org.alfresco.officeservices.AbstractDispatcherService;
import org.alfresco.officeservices.ServiceLogger;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.exceptions.VermeerException;
import org.alfresco.officeservices.protocol.VermeerRequest;
import org.alfresco.officeservices.protocol.VermeerResponse;
import org.alfresco.officeservices.protocol.VermeerReturnList;
import org.alfresco.officeservices.protocol.VermeerReturnStringValue;

public abstract class StandardDispatcherService
extends AbstractDispatcherService {
    private static final long serialVersionUID = 6883875497866743392L;
    private static final ServiceLogger logger = new ServiceLogger(StandardDispatcherService.class);

    public abstract List<String> getServicePrefixes(VermeerRequest var1);

    @Override
    public void serverVersion(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        VermeerReturnList serverVersionDescription = new VermeerReturnList();
        serverVersionDescription.add("major ver", new VermeerReturnStringValue("15"));
        serverVersionDescription.add("minor ver", new VermeerReturnStringValue("0"));
        serverVersionDescription.add("phase ver", new VermeerReturnStringValue("0"));
        serverVersionDescription.add("ver incr", new VermeerReturnStringValue("4420"));
        vermeerResponse.addReturnItem("server version", serverVersionDescription);
        vermeerResponse.addReturnItem("source control", new VermeerReturnStringValue("1"));
        if (logger.isDebugEnabled()) {
            logger.debug("serverVersion: sending version response 15.0.0.4420");
        }
        vermeerResponse.send();
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    @Override
    public void urlToWebUrl(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse, String url) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("urlToWebUrl: requested URL " + url);
        }
        List<String> servicePrefixes = this.getServicePrefixes(vermeerRequest);
        for (String servicePrefix : servicePrefixes) {
            if (logger.isDebugEnabled()) {
                logger.debug("urlToWebUrl: comparing with service prefix " + servicePrefix);
            }
            if (servicePrefix.equals(url)) {
                if (servicePrefix.length() == 0) {
                    servicePrefix = "/";
                }
                vermeerResponse.addReturnItem("webUrl", new VermeerReturnStringValue(servicePrefix));
                vermeerResponse.addReturnItem("fileUrl", new VermeerReturnStringValue(""));
                vermeerResponse.send();
                if (logger.isDebugEnabled()) {
                    logger.debug("urlToWebUrl: matching requested URL. webUrl=" + servicePrefix + " fileUrl=");
                }
                if (logger.isTraceEnabled()) {
                    logger.traceExit();
                }
                return;
            }
            if (url.length() < servicePrefix.length() + 1 || !url.startsWith(servicePrefix + "/")) continue;
            String fileUrl = url.substring(servicePrefix.length() + 1);
            if (servicePrefix.length() == 0) {
                servicePrefix = "/";
            }
            vermeerResponse.addReturnItem("webUrl", new VermeerReturnStringValue(servicePrefix));
            vermeerResponse.addReturnItem("fileUrl", new VermeerReturnStringValue(fileUrl));
            vermeerResponse.send();
            if (logger.isDebugEnabled()) {
                logger.debug("urlToWebUrl: matching requested URL. webUrl=" + servicePrefix + " fileUrl=" + fileUrl);
            }
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        logger.error("urlToWebUrl: unhandled URL " + url);
        vermeerResponse.error("unhandled url");
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }
}

