/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices;

import java.util.BitSet;

public class URLEncoder {
    protected BitSet unencodedCharacters = new BitSet(256);
    public static final char[] ALPHANUMERIC = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char[] PATH = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_', '.', '*', '/'};
    static final char[] HEXDIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public URLEncoder(char[] unencodedCharacters) {
        for (char c : unencodedCharacters) {
            this.unencodedCharacters.set(c);
        }
    }

    public void addUnencodedCharacter(char c) {
        this.unencodedCharacters.set(c);
    }

    public String encode(String in) {
        StringBuilder result = new StringBuilder(in.length());
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (this.unencodedCharacters.get(c)) {
                result.append(c);
                continue;
            }
            if (c < '\u0080') {
                URLEncoder.appendByteAsHex(result, c);
                continue;
            }
            if (c < '\u0800') {
                URLEncoder.appendByteAsHex(result, c >> 6 | 0xC0);
                URLEncoder.appendByteAsHex(result, c & 0x3F | 0x80);
                continue;
            }
            URLEncoder.appendByteAsHex(result, c >> 12 | 0xE0);
            URLEncoder.appendByteAsHex(result, c >> 6 & 0x3F | 0x80);
            URLEncoder.appendByteAsHex(result, c & 0x3F | 0x80);
        }
        return result.toString();
    }

    private static void appendByteAsHex(StringBuilder sb, int b) {
        sb.append('%');
        sb.append(HEXDIGITS[(b & 0xF0) >> 4]);
        sb.append(HEXDIGITS[b & 0xF]);
    }
}

