/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.lists;

import java.io.IOException;
import java.io.PrintStream;
import org.alfresco.officeservices.AbstractSoapService;
import org.alfresco.officeservices.datamodel.FieldDefinition;
import org.alfresco.officeservices.datamodel.FieldType;

public class ContentTypeFieldDefinition {
    protected FieldDefinition fieldDefinition;

    public ContentTypeFieldDefinition(FieldDefinition fieldDefinition) {
        this.fieldDefinition = fieldDefinition;
    }

    public void write(PrintStream out) throws IOException {
        boolean hasChildElements;
        out.print("<Field");
        AbstractSoapService.writeXmlAttribute(out, "ID", this.fieldDefinition.getID().toString(), true);
        AbstractSoapService.writeXmlAttribute(out, "Type", this.fieldDefinition.getFieldType().getTypeString(), true);
        AbstractSoapService.writeXmlAttribute(out, "Name", this.fieldDefinition.getName(), true);
        AbstractSoapService.writeXmlAttribute(out, "ShowInNewForm", this.fieldDefinition.isShowInNewForm() ? "TRUE" : "FALSE", true);
        AbstractSoapService.writeXmlAttribute(out, "ShowInFileDlg", this.fieldDefinition.isShowInFileDlg() ? "TRUE" : "FALSE", true);
        AbstractSoapService.writeXmlAttribute(out, "DisplayName", this.fieldDefinition.getDisplayName(), true);
        AbstractSoapService.writeXmlAttribute(out, "Sealed", "TRUE", true);
        AbstractSoapService.writeXmlAttribute(out, "SourceID", "http://schemas.microsoft.com/sharepoint/v3", true);
        AbstractSoapService.writeXmlAttribute(out, "StaticName", this.fieldDefinition.getName(), true);
        AbstractSoapService.writeXmlAttribute(out, "ColName", this.fieldDefinition.getName(), true);
        AbstractSoapService.writeXmlAttribute(out, "Required", this.fieldDefinition.isMandatory() ? "TRUE" : "FALSE", true);
        AbstractSoapService.writeXmlAttribute(out, "ShowInEditForm", this.fieldDefinition.isShowInEditForm() ? "TRUE" : "FALSE", true);
        if (this.fieldDefinition.getMaxTextLength() != null) {
            AbstractSoapService.writeXmlAttribute(out, "MaxLength", this.fieldDefinition.getMaxTextLength().toString(), true);
        }
        if (this.fieldDefinition.getMinValue() != null) {
            AbstractSoapService.writeXmlAttribute(out, "Min", this.fieldDefinition.getFormattedMinValueString(), true);
        }
        if (this.fieldDefinition.getMaxValue() != null) {
            AbstractSoapService.writeXmlAttribute(out, "Max", this.fieldDefinition.getFormattedMaxValueString(), true);
        }
        if (this.fieldDefinition.getFieldType() == FieldType.DATE_TIME) {
            AbstractSoapService.writeXmlAttribute(out, "Format", this.fieldDefinition.getDateFormat().getFormatIdentifier(), true);
        }
        if (this.fieldDefinition.getFieldType() == FieldType.CHOICE) {
            AbstractSoapService.writeXmlAttribute(out, "Format", "Dropdown", true);
            AbstractSoapService.writeXmlAttribute(out, "FillInChoice", "FALSE", true);
        }
        boolean bl = hasChildElements = this.fieldDefinition.getFieldType() == FieldType.CHOICE || this.fieldDefinition.getDefaultValue() != null;
        if (hasChildElements) {
            out.print(">");
            if (this.fieldDefinition.getDefaultValue() != null) {
                out.print("<Default>");
                AbstractSoapService.writeEncoded(out, this.fieldDefinition.getDefaultValue());
                out.print("</Default>");
            }
            if (this.fieldDefinition.getFieldType() == FieldType.CHOICE) {
                out.print("<CHOICES>");
                for (String choice : this.fieldDefinition.getChoices()) {
                    out.print("<CHOICE>");
                    AbstractSoapService.writeEncoded(out, choice);
                    out.print("</CHOICE>");
                }
                out.print("</CHOICES>");
            }
            out.print("</Field>");
        } else {
            out.print(" />");
        }
    }
}

