/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.protocol;

public class VermeerProtocolVersion {
    private int major;
    private int minor;
    private int phase;
    private int increase;
    public static final char SEPARATOR_CHAR = '.';

    public VermeerProtocolVersion(int major, int minor, int phase, int increase) {
        this.major = major;
        this.minor = minor;
        this.phase = phase;
        this.increase = increase;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPhase() {
        return this.phase;
    }

    public int getIncrease() {
        return this.increase;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.major);
        sb.append('.');
        sb.append(this.minor);
        sb.append('.');
        sb.append(this.phase);
        sb.append('.');
        sb.append(this.increase);
        return sb.toString();
    }

    public int hashCode() {
        return this.major << 26 ^ this.minor << 20 ^ this.phase << 14 ^ this.increase;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof VermeerProtocolVersion) {
            VermeerProtocolVersion anVPV = (VermeerProtocolVersion)anObject;
            return this.major == anVPV.major && this.minor == anVPV.minor && this.phase == anVPV.phase && this.increase == anVPV.increase;
        }
        return false;
    }

    public int compareTo(Object o) {
        return this.compareTo((VermeerProtocolVersion)o);
    }

    public int compareTo(VermeerProtocolVersion anotherVermeerProtocolVersion) {
        int thisMajor = this.major;
        int thisMinor = this.minor;
        int thisPhase = this.phase;
        int thisIncrease = this.increase;
        int anotherMajor = anotherVermeerProtocolVersion.major;
        int anotherMinor = anotherVermeerProtocolVersion.minor;
        int anotherPhase = anotherVermeerProtocolVersion.phase;
        int anotherIncrease = anotherVermeerProtocolVersion.increase;
        if (thisMajor < anotherMajor) {
            return -1;
        }
        if (thisMajor > anotherMajor) {
            return 1;
        }
        if (thisMinor < anotherMinor) {
            return -1;
        }
        if (thisMinor > anotherMinor) {
            return 1;
        }
        if (thisPhase < anotherPhase) {
            return -1;
        }
        if (thisPhase > anotherPhase) {
            return 1;
        }
        if (thisIncrease < anotherIncrease) {
            return -1;
        }
        if (thisIncrease > anotherIncrease) {
            return 1;
        }
        return 0;
    }

    public static VermeerProtocolVersion valueOf(String versionString) {
        int major = 0;
        int minor = 0;
        int phase = 0;
        int increase = 0;
        String[] versionParts = versionString.split("\\.");
        if (versionParts.length < 4) {
            throw new IllegalArgumentException("Argument is not a valid Vermeer protocol version.");
        }
        try {
            major = Integer.parseInt(versionParts[0]);
            minor = Integer.parseInt(versionParts[1]);
            phase = Integer.parseInt(versionParts[2]);
            increase = Integer.parseInt(versionParts[3]);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Argument is not a valid Vermeer protocol version.");
        }
        return new VermeerProtocolVersion(major, minor, phase, increase);
    }

    public static VermeerProtocolVersion min(VermeerProtocolVersion a, VermeerProtocolVersion b) {
        return a.compareTo(b) < 0 ? a : b;
    }
}

