/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.protocol;

import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.officeservices.protocol.VermeerResponse;
import org.alfresco.officeservices.protocol.VermeerReturnDictionary;
import org.alfresco.officeservices.protocol.VermeerReturnValue;

public class VermeerReturnVectorUrlDirectory
implements VermeerReturnValue {
    protected List<VermeerReturnVectorUrlDirectoryItem> items = new ArrayList<VermeerReturnVectorUrlDirectoryItem>();

    public void add(String directoryUrl, VermeerReturnDictionary metainfoDictionary) {
        this.items.add(new VermeerReturnVectorUrlDirectoryItem(directoryUrl, metainfoDictionary));
    }

    public int size() {
        return this.items.size();
    }

    public String getUrl(int i) {
        return this.items.get(i).getUrl();
    }

    public VermeerReturnDictionary getMetainfoDictionary(int i) {
        return this.items.get(i).getMetainfoDictionary();
    }

    @Override
    public void write(ServletOutputStream out) throws IOException {
        out.print("\n<ul>");
        for (VermeerReturnVectorUrlDirectoryItem item : this.items) {
            out.print("\n<ul>");
            out.print("\n<li>url=");
            out.print(VermeerResponse.encodeString(item.getUrl()));
            out.print("\n<li>meta_info=");
            item.getMetainfoDictionary().write(out);
            out.print("\n</ul>");
        }
        out.print("\n</ul>");
    }

    @Override
    public String toTraceString() {
        return "####";
    }

    protected static class VermeerReturnVectorUrlDirectoryItem {
        protected String url;
        protected VermeerReturnDictionary metainfoDictionary;

        public VermeerReturnVectorUrlDirectoryItem(String url, VermeerReturnDictionary metainfoDictionary) {
            this.url = url;
            this.metainfoDictionary = metainfoDictionary;
        }

        public String getUrl() {
            return this.url;
        }

        public VermeerReturnDictionary getMetainfoDictionary() {
            return this.metainfoDictionary;
        }
    }
}

