/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.workflow;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.alfresco.officeservices.AbstractSoapService;
import org.alfresco.officeservices.ServiceLogger;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.protocol.SimpleSoapParser;
import org.alfresco.officeservices.protocol.SoapParameter;
import org.alfresco.officeservices.workflow.PrincipalInfo;

public abstract class AbstractPeopleService
extends AbstractSoapService {
    private static final long serialVersionUID = 4046536199692999558L;
    private static final ServiceLogger logger = new ServiceLogger(AbstractPeopleService.class);
    public static final String METHODNAME_RESOLVEPRINCIPALS = "ResolvePrincipals";
    public static final String METHODNAME_SEARCHPRINCIPALS = "SearchPrincipals";
    public static final String METHODPARAMETER_PRINCIPALKEYS = "principalKeys";
    public static final String METHODPARAMETER_PRINCIPALTYPE = "principalType";
    public static final String METHODPARAMETER_ADDTOUSERINFOLIST = "addToUserInfoList";
    public static final String METHODPARAMETER_SEARCHTEXT = "searchText";
    public static final String METHODPARAMETER_MAXRESULTS = "maxResults";

    @Override
    public void soapService(UserData userData, String methodName, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (methodName.equals(METHODNAME_RESOLVEPRINCIPALS)) {
            this.handleResolvePrincipals(userData, parser, request, response);
        } else if (methodName.equals(METHODNAME_SEARCHPRINCIPALS)) {
            this.handleSearchPrincipals(userData, parser, request, response);
        } else {
            logger.error("soapService: unknown RPC methodname " + methodName);
            SimpleSoapParser.soapErrorResponse(response, "Unknown methodname.");
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected void handleResolvePrincipals(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        PrincipalInfo principalInfo;
        SoapParameter principalKeysStringElem;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        String principalKeys = null;
        SoapParameter principalKeysElem = parser.getSoapParameter(METHODPARAMETER_PRINCIPALKEYS);
        if (principalKeysElem != null && (principalKeysStringElem = principalKeysElem.getFirstSubParameterByName("string")) != null) {
            principalKeys = principalKeysStringElem.getValue();
        }
        String principalType = parser.getParameter(METHODPARAMETER_PRINCIPALTYPE);
        String addToUserInfoList = parser.getParameter(METHODPARAMETER_ADDTOUSERINFOLIST);
        if (logger.isDebugEnabled()) {
            logger.debug("handleResolvePrincipals: principalKeys=" + principalKeys);
            logger.debug("handleResolvePrincipals: principalType=" + principalType);
            logger.debug("handleResolvePrincipals: addToUserInfoList=" + addToUserInfoList);
        }
        if ((principalInfo = this.resolvePrincipals(principalKeys, principalType, "true".equalsIgnoreCase(addToUserInfoList), userData, parser, request)) == null) {
            logger.error("handleResolvePrincipals: resolvePrincipals returned null instead of response object.");
            SimpleSoapParser.soapErrorResponse(response, "handleResolvePrincipals: resolvePrincipals returned null instead of response object.");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)bos, false, "utf-8");
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<ResolvePrincipalsResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<ResolvePrincipalsResult>");
        principalInfo.write(out);
        out.print("</ResolvePrincipalsResult>");
        out.print("</ResolvePrincipalsResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType("text/xml; charset=utf-8");
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract PrincipalInfo resolvePrincipals(String var1, String var2, boolean var3, UserData var4, SimpleSoapParser var5, HttpServletRequest var6);

    protected void handleSearchPrincipals(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        String searchText = parser.getParameter(METHODPARAMETER_SEARCHTEXT);
        String maxResultsText = parser.getParameter(METHODPARAMETER_MAXRESULTS);
        String principalType = parser.getParameter(METHODPARAMETER_PRINCIPALTYPE);
        int maxResults = 200;
        if (maxResultsText != null) {
            try {
                maxResults = Integer.parseInt(maxResultsText);
            }
            catch (NumberFormatException nfe) {
                logger.debug("handleSearchPrincipals: maxResults does not contain a valid integer:" + maxResultsText);
                maxResults = 200;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("handleSearchPrincipals: searchText=" + searchText);
            logger.debug("handleSearchPrincipals: maxResults=" + maxResults);
            logger.debug("handleSearchPrincipals: principalType=" + principalType);
        }
        PrincipalInfo[] searchResult = this.searchPrincipals(searchText, principalType, maxResults, userData, parser, request);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)bos, false, "utf-8");
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<SearchPrincipalsResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">");
        out.print("<SearchPrincipalsResult>");
        if (searchResult != null) {
            for (int i = 0; i < searchResult.length; ++i) {
                searchResult[i].write(out);
            }
        }
        out.print("</SearchPrincipalsResult>");
        out.print("</SearchPrincipalsResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        out.flush();
        response.setContentType("text/xml; charset=utf-8");
        response.setContentLength(bos.size());
        bos.writeTo((OutputStream)response.getOutputStream());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract PrincipalInfo[] searchPrincipals(String var1, String var2, int var3, UserData var4, SimpleSoapParser var5, HttpServletRequest var6);
}

