/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.module.aosmodule.metadata.ServerPropertiesProvider;
import org.alfresco.module.aosmodule.metadata.StandardDataModelMapper;
import org.alfresco.officeservices.docproc.DocumentProperty;
import org.alfresco.officeservices.docproc.DocumentPropertyDateFormat;
import org.alfresco.officeservices.docproc.DocumentPropertyOrigin;
import org.alfresco.repo.dictionary.constraint.ListOfValuesConstraint;
import org.alfresco.repo.dictionary.constraint.NumericRangeConstraint;
import org.alfresco.repo.dictionary.constraint.StringLengthConstraint;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.InvalidQNameException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardServerPropertiesProvider
extends StandardDataModelMapper
implements ServerPropertiesProvider {
    protected String titleProperty;
    protected QName titlePropertyQName = null;
    private Logger logger = LoggerFactory.getLogger(StandardServerPropertiesProvider.class);

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        try {
            this.titlePropertyQName = QName.createQName((String)this.titleProperty);
        }
        catch (InvalidQNameException e) {
            this.logger.error("titleProperty is not a valid QName", (Throwable)e);
        }
    }

    @Override
    public Map<QName, DocumentProperty> getServerPropertiesMapping(NodeRef nodeRef) {
        this.logger.debug("getServerProperties for Node " + String.valueOf(nodeRef));
        HashMap<QName, DocumentProperty> result = new HashMap<QName, DocumentProperty>();
        Map properties = this.nodeService.getProperties(nodeRef);
        QName nodeTypeQname = this.nodeService.getType(nodeRef);
        this.logger.debug("Node Type: " + String.valueOf(nodeTypeQname));
        ClassDefinition classDefinition = this.dictionaryService.getClass(nodeTypeQname);
        this.addAlfrescoPropertiesToDocumentProperties(properties, classDefinition.getProperties(), result);
        Set aspectsQNames = this.nodeService.getAspects(nodeRef);
        for (QName aspectQname : aspectsQNames) {
            this.logger.debug("Aspect Type: " + String.valueOf(aspectQname));
            if (!this.dataModelMappingConfiguration.isAspectMapped(aspectQname)) {
                this.logger.debug("    ignored.");
                continue;
            }
            AspectDefinition aspectDefinition = this.dictionaryService.getAspect(aspectQname);
            this.addAlfrescoPropertiesToDocumentProperties(properties, aspectDefinition.getProperties(), result);
        }
        return result;
    }

    protected void addAlfrescoPropertiesToDocumentProperties(Map<QName, Serializable> properties, Map<QName, PropertyDefinition> propertyDefinitions, HashMap<QName, DocumentProperty> result) {
        for (Map.Entry<QName, PropertyDefinition> propEntry : propertyDefinitions.entrySet()) {
            PropertyDefinition propDef = propEntry.getValue();
            this.logger.debug("    Property: " + String.valueOf(propDef.getName()));
            if (!this.dataModelMappingConfiguration.isPropertyMapped(propDef.getName())) {
                this.logger.debug("        ignored.");
                continue;
            }
            if (this.titleProperty != null && this.titleProperty.equals(propDef.getName().toString())) {
                this.logger.debug("        is title property. ignored.");
                continue;
            }
            DocumentProperty documentProperty = this.convertToDocumentProperty(propDef, properties.get(propDef.getName()));
            if (documentProperty == null) {
                this.logger.debug("        cannot be converted to SP data model. ignored.");
                continue;
            }
            result.put(propDef.getName(), documentProperty);
        }
    }

    protected DocumentProperty convertToDocumentProperty(PropertyDefinition propDef, Serializable value) {
        if (propDef.isMultiValued()) {
            return null;
        }
        String displayName = propDef.getTitle((MessageLookup)this.dictionaryService);
        if (displayName == null) {
            displayName = propDef.getName().toPrefixString((NamespacePrefixResolver)this.namespaceService);
        }
        String name = StandardServerPropertiesProvider.displayNameToXmlName(displayName);
        String description = propDef.getDescription((MessageLookup)this.dictionaryService);
        if (description == null) {
            description = "";
        }
        DocumentPropertyOrigin origin = DocumentPropertyOrigin.SERVER;
        boolean readOnly = propDef.isProtected();
        boolean mandatory = readOnly ? false : propDef.isMandatory();
        DataTypeDefinition dtd = propDef.getDataType();
        this.logger.debug("        internalName=" + name + " displayName=" + displayName + " dataType=" + String.valueOf(dtd.getName()) + " mandatory=" + mandatory + " readOnly=" + readOnly);
        if (dtd.getName().equals((Object)DataTypeDefinition.TEXT)) {
            Pair<ListOfValuesConstraint, Boolean> listOfValuesConstraintResult = StandardServerPropertiesProvider.findConstraint(propDef.getConstraints(), ListOfValuesConstraint.class);
            if (listOfValuesConstraintResult.getFirst() != null) {
                if (((Boolean)listOfValuesConstraintResult.getSecond()).booleanValue()) {
                    return null;
                }
                ListOfValuesConstraint listOfValuesConstraint = (ListOfValuesConstraint)listOfValuesConstraintResult.getFirst();
                ArrayList<String> listOfDisplayLabels = new ArrayList<String>();
                String displayValue = null;
                for (String allowedValue : listOfValuesConstraint.getAllowedValues()) {
                    String displayLabel = listOfValuesConstraint.getDisplayLabel(allowedValue, (MessageLookup)this.dictionaryService);
                    listOfDisplayLabels.add(displayLabel);
                    if (value == null || !value.equals(allowedValue)) continue;
                    displayValue = displayLabel;
                }
                return DocumentProperty.createChoiceDocumentProperty((String)name, (String)displayName, (String)description, (DocumentPropertyOrigin)origin, (boolean)mandatory, (boolean)readOnly, displayValue, listOfDisplayLabels);
            }
            Pair<StringLengthConstraint, Boolean> stringLengthConstraintResult = StandardServerPropertiesProvider.findConstraint(propDef.getConstraints(), StringLengthConstraint.class);
            if (((Boolean)stringLengthConstraintResult.getSecond()).booleanValue()) {
                return null;
            }
            Integer minTextLength = null;
            Integer maxTextLength = null;
            if (stringLengthConstraintResult.getFirst() != null) {
                StringLengthConstraint stringLengthConstraint = (StringLengthConstraint)stringLengthConstraintResult.getFirst();
                if (stringLengthConstraint.getMinLength() != 0) {
                    minTextLength = stringLengthConstraint.getMinLength();
                }
                if (stringLengthConstraint.getMaxLength() != Integer.MAX_VALUE) {
                    maxTextLength = stringLengthConstraint.getMaxLength();
                }
            }
            return DocumentProperty.createTextDocumentProperty((String)name, (String)displayName, (String)description, (DocumentPropertyOrigin)origin, (boolean)mandatory, (boolean)readOnly, (String)((String)((Object)value)), (Integer)minTextLength, maxTextLength, (boolean)false);
        }
        if (dtd.getName().equals((Object)DataTypeDefinition.MLTEXT)) {
            if (propDef.getConstraints() != null && propDef.getConstraints().size() > 0) {
                return null;
            }
            Integer minTextLength = null;
            Integer maxTextLength = null;
            return DocumentProperty.createTextDocumentProperty((String)name, (String)displayName, (String)description, (DocumentPropertyOrigin)origin, (boolean)mandatory, (boolean)readOnly, (String)((String)((Object)value)), minTextLength, maxTextLength, (boolean)true);
        }
        if (dtd.getName().equals((Object)DataTypeDefinition.INT)) {
            int precision = 0;
            Number minValue = null;
            Number maxValue = null;
            Pair<NumericRangeConstraint, Boolean> numericRangeConstraintResult = StandardServerPropertiesProvider.findConstraint(propDef.getConstraints(), NumericRangeConstraint.class);
            if (((Boolean)numericRangeConstraintResult.getSecond()).booleanValue()) {
                return null;
            }
            if (numericRangeConstraintResult.getFirst() != null) {
                NumericRangeConstraint numericRangeConstraint = (NumericRangeConstraint)numericRangeConstraintResult.getFirst();
                minValue = numericRangeConstraint.getMinValue();
                maxValue = numericRangeConstraint.getMaxValue();
            } else {
                minValue = Integer.MIN_VALUE;
                maxValue = Integer.MAX_VALUE;
            }
            return DocumentProperty.createNumberDocumentProperty((String)name, (String)displayName, (String)description, (DocumentPropertyOrigin)origin, (boolean)mandatory, (boolean)readOnly, (Number)((Integer)value), (int)precision, (Number)minValue, (Number)maxValue);
        }
        if (dtd.getName().equals((Object)DataTypeDefinition.LONG)) {
            int precision = 0;
            Number minValue = null;
            Number maxValue = null;
            Pair<NumericRangeConstraint, Boolean> numericRangeConstraintResult = StandardServerPropertiesProvider.findConstraint(propDef.getConstraints(), NumericRangeConstraint.class);
            if (((Boolean)numericRangeConstraintResult.getSecond()).booleanValue()) {
                return null;
            }
            if (numericRangeConstraintResult.getFirst() != null) {
                NumericRangeConstraint numericRangeConstraint = (NumericRangeConstraint)numericRangeConstraintResult.getFirst();
                minValue = numericRangeConstraint.getMinValue();
                maxValue = numericRangeConstraint.getMaxValue();
            } else {
                minValue = Long.MIN_VALUE;
                maxValue = Long.MAX_VALUE;
            }
            return DocumentProperty.createNumberDocumentProperty((String)name, (String)displayName, (String)description, (DocumentPropertyOrigin)origin, (boolean)mandatory, (boolean)readOnly, (Number)((Long)value), (int)precision, (Number)minValue, (Number)maxValue);
        }
        if (dtd.getName().equals((Object)DataTypeDefinition.FLOAT)) {
            int precision = 5;
            Double minValue = null;
            Double maxValue = null;
            Pair<NumericRangeConstraint, Boolean> numericRangeConstraintResult = StandardServerPropertiesProvider.findConstraint(propDef.getConstraints(), NumericRangeConstraint.class);
            if (((Boolean)numericRangeConstraintResult.getSecond()).booleanValue()) {
                return null;
            }
            if (numericRangeConstraintResult.getFirst() != null) {
                NumericRangeConstraint numericRangeConstraint = (NumericRangeConstraint)numericRangeConstraintResult.getFirst();
                minValue = numericRangeConstraint.getMinValue();
                maxValue = numericRangeConstraint.getMaxValue();
            }
            return DocumentProperty.createNumberDocumentProperty((String)name, (String)displayName, (String)description, (DocumentPropertyOrigin)origin, (boolean)mandatory, (boolean)readOnly, (Number)((Float)value), (int)precision, (Number)minValue, (Number)maxValue);
        }
        if (dtd.getName().equals((Object)DataTypeDefinition.DOUBLE)) {
            int precision = 10;
            Double minValue = null;
            Double maxValue = null;
            Pair<NumericRangeConstraint, Boolean> numericRangeConstraintResult = StandardServerPropertiesProvider.findConstraint(propDef.getConstraints(), NumericRangeConstraint.class);
            if (((Boolean)numericRangeConstraintResult.getSecond()).booleanValue()) {
                return null;
            }
            if (numericRangeConstraintResult.getFirst() != null) {
                NumericRangeConstraint numericRangeConstraint = (NumericRangeConstraint)numericRangeConstraintResult.getFirst();
                minValue = numericRangeConstraint.getMinValue();
                maxValue = numericRangeConstraint.getMaxValue();
            }
            return DocumentProperty.createNumberDocumentProperty((String)name, (String)displayName, (String)description, (DocumentPropertyOrigin)origin, (boolean)mandatory, (boolean)readOnly, (Number)((Double)value), (int)precision, (Number)minValue, (Number)maxValue);
        }
        if (dtd.getName().equals((Object)DataTypeDefinition.DATE)) {
            if (propDef.getConstraints() != null && propDef.getConstraints().size() > 0) {
                return null;
            }
            return DocumentProperty.createDateTimeDocumentProperty((String)name, (String)displayName, (String)description, (DocumentPropertyOrigin)origin, (boolean)mandatory, (boolean)readOnly, (Date)((Date)value), (DocumentPropertyDateFormat)DocumentPropertyDateFormat.DATE_ONLY);
        }
        if (dtd.getName().equals((Object)DataTypeDefinition.DATETIME)) {
            if (propDef.getConstraints() != null && propDef.getConstraints().size() > 0) {
                return null;
            }
            return DocumentProperty.createDateTimeDocumentProperty((String)name, (String)displayName, (String)description, (DocumentPropertyOrigin)origin, (boolean)mandatory, (boolean)readOnly, (Date)((Date)value), (DocumentPropertyDateFormat)DocumentPropertyDateFormat.DATE_TIME);
        }
        if (dtd.getName().equals((Object)DataTypeDefinition.BOOLEAN)) {
            if (propDef.getConstraints() != null && propDef.getConstraints().size() > 0) {
                return null;
            }
            return DocumentProperty.createBooleanDocumentProperty((String)name, (String)displayName, (String)description, (DocumentPropertyOrigin)origin, (boolean)mandatory, (boolean)readOnly, (Boolean)((Boolean)value));
        }
        return null;
    }

    @Override
    public QName getDocumentTitlePropertyName() {
        return this.titlePropertyQName;
    }

    @Override
    public String getDocumentTitle(NodeRef nodeRef) {
        if (this.titlePropertyQName == null) {
            return null;
        }
        Serializable value = this.nodeService.getProperty(nodeRef, this.titlePropertyQName);
        if (value == null) {
            return null;
        }
        String stringValue = value.toString();
        if (stringValue == null || stringValue.isEmpty()) {
            return null;
        }
        return stringValue;
    }

    public String getTitleProperty() {
        return this.titleProperty;
    }

    public void setTitleProperty(String titleProperty) {
        this.titleProperty = titleProperty;
    }
}

