/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.service;

import java.util.regex.Pattern;
import org.alfresco.module.aosmodule.service.FileDialogWebViewConfiguration;
import org.alfresco.module.aosmodule.service.FileDialogWebViewRegistry;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.InitializingBean;

public class StandardFileDialogWebViewConfiguration
implements FileDialogWebViewConfiguration,
InitializingBean {
    private FileDialogWebViewRegistry registry;
    private String pathPattern;
    private Pattern compiledPattern;
    private String templateLocation;

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"pathPattern", (Object)this.pathPattern);
        PropertyCheck.mandatory((Object)this, (String)"templateLocation", (Object)this.templateLocation);
        this.compiledPattern = Pattern.compile(this.pathPattern);
    }

    public void register() {
        if (this.registry != null) {
            this.registry.registerConfiguration(this);
        }
    }

    @Override
    public boolean appliesTo(String path) {
        return this.compiledPattern.matcher(path).matches();
    }

    @Override
    public String getFreeMarkerTemplateLocation() {
        return this.templateLocation;
    }

    public void setRegistry(FileDialogWebViewRegistry registry) {
        this.registry = registry;
    }

    public void setPathPattern(String pathPattern) {
        this.pathPattern = pathPattern;
    }

    public void setTemplateLocation(String templateLocation) {
        this.templateLocation = templateLocation;
    }
}

