/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.vfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.module.aosmodule.metadata.ContentFilter;
import org.alfresco.module.aosmodule.metadata.ContentFilterProcessingResult;
import org.alfresco.module.aosmodule.metadata.ContentPostProcessor;
import org.alfresco.module.aosmodule.metadata.IOContentFilterRegistry;
import org.alfresco.module.aosmodule.vfs.AlfrescoVirtualFileSystem;
import org.alfresco.module.aosmodule.vfs.ContentResponse;
import org.alfresco.module.aosmodule.vfs.EmptyFileContentResponse;
import org.alfresco.module.aosmodule.vfs.FilteredContentResponse;
import org.alfresco.module.aosmodule.vfs.RepositoryContentResponse;
import org.alfresco.module.aosmodule.vfs.VersionNumber;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.datamodel.ContentTypeId;
import org.alfresco.officeservices.datamodel.Guid;
import org.alfresco.officeservices.lists.CheckinType;
import org.alfresco.officeservices.protocol.VermeerRequest;
import org.alfresco.officeservices.protocol.VermeerReturnDictionary;
import org.alfresco.officeservices.protocol.VermeerReturnDictionaryFile;
import org.alfresco.officeservices.vfs.CheckoutResult;
import org.alfresco.officeservices.vfs.VFSDocumentNode;
import org.alfresco.officeservices.vfs.VFSDocumentVersion;
import org.alfresco.officeservices.vfs.VFSNode;
import org.alfresco.repo.lock.mem.Lifetime;
import org.alfresco.repo.lock.mem.LockState;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.webdav.LockInfoImpl;
import org.alfresco.repo.webdav.WebDAV;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.lock.UnableToReleaseLockException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.TempFileProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentNode
implements VFSDocumentNode {
    protected AlfrescoVirtualFileSystem vfs;
    protected FileInfo fileInfo;
    protected String relativePath;
    protected boolean isHistoryNode;
    protected ContentResponse contentResponse;
    protected boolean activateVersioningOnWrite = true;
    private boolean ignoreCurrentUser = false;
    protected static Logger logger = LoggerFactory.getLogger(DocumentNode.class);
    private Boolean cache_isCheckedOut;
    private NodeRef cache_workingCopy;

    public DocumentNode(FileInfo info, String path, AlfrescoVirtualFileSystem vfs, boolean isHistoryNode) {
        this.fileInfo = info;
        this.relativePath = path;
        this.vfs = vfs;
        this.isHistoryNode = isHistoryNode;
        if (this.fileInfo.getProperties().get(ContentModel.PROP_LOCK_TYPE) == null) {
            this.cache_isCheckedOut = Boolean.FALSE;
        }
    }

    public DocumentNode(FileInfo info, String path, AlfrescoVirtualFileSystem vfs) {
        this(info, path, vfs, false);
    }

    public void setIgnoreCurrentUser(boolean ignoreCurrentUser) {
        this.ignoreCurrentUser = ignoreCurrentUser;
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    protected String getSiteId() {
        String siteId;
        try {
            siteId = this.getSiteIdInANewRetryingTransaction();
            if (siteId == null) {
                siteId = "";
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Error getting site ID: ", (Throwable)e);
            }
            siteId = "";
        }
        return siteId;
    }

    private String getSiteIdInANewRetryingTransaction() {
        RetryingTransactionHelper.RetryingTransactionCallback<String> callback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            public String execute() throws Throwable {
                return DocumentNode.this.vfs.getSiteService().getSiteShortName(DocumentNode.this.fileInfo.getNodeRef());
            }
        };
        return (String)this.vfs.getTransactionService().getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, true, true);
    }

    public String getName(int callContext) {
        return this.fileInfo.getName();
    }

    public VermeerReturnDictionary getVermeerMetaInfoDictionary(int callContext) {
        ContentReader reader;
        NodeRef nodeToRead = this.fileInfo.getNodeRef();
        boolean isCheckedOut = this.isCheckedOut();
        boolean isCheckedOutToLocal = false;
        if (isCheckedOut) {
            nodeToRead = this.getWorkingCopy();
            isCheckedOutToLocal = this.vfs.getNodeService().hasAspect(nodeToRead, AlfrescoVirtualFileSystem.ASPECT_AOS_CHECKED_OUT_TO_LOCAL);
        }
        long size = (reader = this.vfs.getFileFolderService().getReader(nodeToRead)) == null ? 0L : reader.getSize();
        LockStatus lockStatus = this.vfs.getLockService().getLockStatus(nodeToRead);
        boolean isLocked = lockStatus == LockStatus.LOCK_OWNER || lockStatus == LockStatus.LOCKED;
        Date dateCreated = (Date)this.vfs.getNodeService().getProperty(this.fileInfo.getNodeRef(), ContentModel.PROP_CREATED);
        Date dateModified = (Date)this.vfs.getNodeService().getProperty(nodeToRead, ContentModel.PROP_MODIFIED);
        String userCreated = this.getCreator();
        String userModified = this.getModifier();
        Date dateLockExpires = null;
        Date dateLockCreated = null;
        if (isLocked) {
            dateLockExpires = (Date)this.vfs.getNodeService().getProperty(nodeToRead, ContentModel.PROP_EXPIRY_DATE);
            if (dateLockExpires == null) {
                Date now = new Date();
                dateLockExpires = new Date(now.getTime() + 600000L);
            }
            dateLockCreated = new Date(dateLockExpires.getTime() - 3600000L);
        }
        Date dateCheckedOut = null;
        if (isCheckedOut) {
            dateCheckedOut = (Date)this.vfs.getNodeService().getProperty(nodeToRead, ContentModel.PROP_CREATED);
        }
        String lockOwner = null;
        if (isLocked) {
            lockOwner = (String)((Object)this.vfs.getNodeService().getProperty(nodeToRead, ContentModel.PROP_LOCK_OWNER));
        }
        String checkoutOwner = null;
        if (isCheckedOut) {
            checkoutOwner = (String)((Object)this.vfs.getNodeService().getProperty(this.fileInfo.getNodeRef(), ContentModel.PROP_LOCK_OWNER));
        }
        VersionNumber versionNumber = this.getVersionNumber();
        VermeerReturnDictionaryFile dict = new VermeerReturnDictionaryFile(size, isLocked, isCheckedOut, dateCreated, dateModified, userCreated, userModified, dateLockCreated, dateLockExpires, dateCheckedOut, lockOwner, checkoutOwner, versionNumber.toString());
        dict.setCheckoutToLocal(isCheckedOutToLocal);
        return dict;
    }

    public String getCreator() {
        return (String)((Object)this.vfs.getNodeService().getProperty(this.fileInfo.getNodeRef(), ContentModel.PROP_CREATOR));
    }

    public String getModifier() {
        return (String)((Object)this.vfs.getNodeService().getProperty(this.fileInfo.getNodeRef(), ContentModel.PROP_MODIFIER));
    }

    public Date getDateLastModified(int callContext) {
        if (this.isCheckedOut()) {
            Date workingCopyModified;
            NodeRef workingCopy = this.getWorkingCopy();
            Date workingCopyCreated = (Date)this.vfs.getNodeService().getProperty(workingCopy, ContentModel.PROP_CREATED);
            if (workingCopyCreated.equals(workingCopyModified = (Date)this.vfs.getNodeService().getProperty(workingCopy, ContentModel.PROP_MODIFIED))) {
                return this.fileInfo.getModifiedDate();
            }
            return workingCopyModified;
        }
        return this.fileInfo.getModifiedDate();
    }

    public Date getDateCreated(int callContext) {
        return this.fileInfo.getCreatedDate();
    }

    public String getMimeString(int callContext) {
        ContentData contentData;
        ContentData contentData2 = contentData = this.isCheckedOut() ? (ContentData)this.vfs.getNodeService().getProperty(this.getWorkingCopy(), ContentModel.PROP_CONTENT) : this.fileInfo.getContentData();
        if (contentData != null) {
            return contentData.getMimetype();
        }
        return "application/octet-stream";
    }

    public long getSize(int callContext) {
        ContentData contentData;
        if (callContext == 513) {
            return this.getContentResponse().getSize();
        }
        ContentData contentData2 = contentData = this.isCheckedOut() ? (ContentData)this.vfs.getNodeService().getProperty(this.getWorkingCopy(), ContentModel.PROP_CONTENT) : this.fileInfo.getContentData();
        if (contentData != null) {
            return contentData.getSize();
        }
        return 0L;
    }

    public boolean isModifiedSince(Date lastSeen, int callContext) {
        long lastSeenSeconds;
        long lastModifiedSeconds = this.getDateLastModified(callContext).getTime() / 1000L;
        return lastModifiedSeconds > (lastSeenSeconds = lastSeen.getTime() / 1000L);
    }

    public String getLockOwner() {
        LockStatus lockStatus;
        NodeRef nodeToCheck = this.fileInfo.getNodeRef();
        if (this.isCheckedOut()) {
            nodeToCheck = this.getWorkingCopy();
        }
        if ((lockStatus = this.vfs.getLockService().getLockStatus(nodeToCheck)) == LockStatus.LOCK_OWNER || lockStatus == LockStatus.LOCKED) {
            return (String)((Object)this.vfs.getNodeService().getProperty(nodeToCheck, ContentModel.PROP_LOCK_OWNER));
        }
        return null;
    }

    public Date getLockExpiry() {
        LockStatus lockStatus;
        NodeRef nodeToCheck = this.fileInfo.getNodeRef();
        if (this.isCheckedOut()) {
            nodeToCheck = this.getWorkingCopy();
        }
        if ((lockStatus = this.vfs.getLockService().getLockStatus(nodeToCheck)) == LockStatus.LOCK_OWNER || lockStatus == LockStatus.LOCKED) {
            return (Date)this.vfs.getNodeService().getProperty(nodeToCheck, ContentModel.PROP_EXPIRY_DATE);
        }
        return null;
    }

    public Date getCheckoutDate() {
        if (this.isCheckedOut()) {
            NodeRef workingCopy = this.getWorkingCopy();
            if (workingCopy != null) {
                return (Date)this.vfs.getNodeService().getProperty(workingCopy, ContentModel.PROP_CREATED);
            }
            return null;
        }
        return null;
    }

    public String getCheckoutOwner() {
        if (this.isCheckedOut()) {
            return (String)((Object)this.vfs.getNodeService().getProperty(this.fileInfo.getNodeRef(), ContentModel.PROP_LOCK_OWNER));
        }
        return null;
    }

    public boolean isCheckedOutToLocal() {
        if (this.isCheckedOut()) {
            NodeRef workingCopy = this.getWorkingCopy();
            if (workingCopy != null) {
                return this.vfs.getNodeService().hasAspect(workingCopy, AlfrescoVirtualFileSystem.ASPECT_AOS_CHECKED_OUT_TO_LOCAL);
            }
            return false;
        }
        return false;
    }

    public CheckoutResult checkout(int timeout, String webdavLockToken, int callContext) {
        return this.checkout(timeout, webdavLockToken, callContext, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckoutResult checkout(int timeout, String webdavLockToken, int callContext, boolean checkoutToLocal) {
        try {
            if (this.isHistoryNode) {
                CheckoutResult checkoutResult = CheckoutResult.FAILED;
                return checkoutResult;
            }
            if (timeout == 0) {
                CheckoutResult checkoutResult = this.performCheckout(webdavLockToken, callContext, checkoutToLocal);
                return checkoutResult;
            }
            CheckoutResult checkoutResult = this.performLock(timeout, webdavLockToken, callContext);
            return checkoutResult;
        }
        finally {
            this.cache_isCheckedOut = null;
            this.cache_workingCopy = null;
        }
    }

    private CheckoutResult performCheckout(String webdavLockToken, int callContext, boolean checkoutToLocal) {
        NodeRef workingCopy;
        LockService lockService = this.vfs.getLockService();
        LockStatus lockStatus = lockService.getLockStatus(this.fileInfo.getNodeRef());
        if (this.isCheckedOut()) {
            if (lockStatus == LockStatus.LOCK_OWNER) {
                return CheckoutResult.OK;
            }
            return CheckoutResult.DIFFERENTUSER;
        }
        if (lockStatus == LockStatus.LOCKED) {
            return CheckoutResult.DIFFERENTUSER;
        }
        boolean reCreateLock = false;
        Date initialExpiryDate = null;
        if (lockStatus == LockStatus.LOCK_OWNER) {
            reCreateLock = true;
            initialExpiryDate = (Date)this.vfs.getNodeService().getProperty(this.fileInfo.getNodeRef(), ContentModel.PROP_EXPIRY_DATE);
            if (!this.unlockNode(this.fileInfo.getNodeRef())) {
                return CheckoutResult.FAILED;
            }
        }
        CheckOutCheckInService checkOutCheckInService = this.vfs.getCheckOutCheckInService();
        try {
            workingCopy = checkOutCheckInService.checkout(this.fileInfo.getNodeRef());
        }
        catch (Exception e) {
            AlfrescoVirtualFileSystem.checkForRetryingException(e);
            logger.debug("Error checking out node", (Throwable)e);
            return CheckoutResult.FAILED;
        }
        if (checkoutToLocal) {
            this.vfs.getNodeService().addAspect(workingCopy, AlfrescoVirtualFileSystem.ASPECT_AOS_CHECKED_OUT_TO_LOCAL, null);
        }
        if (reCreateLock && workingCopy != null) {
            this.lockNode(workingCopy, this.calculateTimeout(initialExpiryDate, 3600));
        }
        return CheckoutResult.OK;
    }

    private int calculateTimeout(Date targetExpiryDate, int defaultTimeout) {
        long currentMillis;
        if (targetExpiryDate == null) {
            return defaultTimeout;
        }
        long targetMillis = targetExpiryDate.getTime();
        if (targetMillis <= (currentMillis = System.currentTimeMillis())) {
            return 0;
        }
        return (int)Math.round((double)(targetMillis - currentMillis) / 1000.0);
    }

    private CheckoutResult performLock(int timeout, String webdavLockToken, int callContext) {
        LockStatus lockStatus;
        NodeRef nodeToLock = this.fileInfo.getNodeRef();
        if (this.isCheckedOut()) {
            nodeToLock = this.getWorkingCopy();
        }
        if ((lockStatus = this.vfs.getLockService().getLockStatus(nodeToLock)) == LockStatus.LOCKED) {
            return CheckoutResult.DIFFERENTUSER;
        }
        if (this.lockNode(nodeToLock, timeout * 60)) {
            return CheckoutResult.OK;
        }
        return CheckoutResult.FAILED;
    }

    private boolean lockNode(NodeRef node, int timeoutSeconds) {
        try {
            String currentUser = this.vfs.getAuthenticationService().getCurrentUserName();
            String lockToken = WebDAV.makeLockToken((NodeRef)this.fileInfo.getNodeRef(), (String)currentUser);
            LockInfoImpl lockInfo = new LockInfoImpl();
            lockInfo.setTimeoutSeconds(timeoutSeconds);
            lockInfo.setExclusiveLockToken(lockToken);
            lockInfo.setDepth("0");
            lockInfo.setScope("exclusive");
            lockInfo.setOwner(currentUser);
            this.vfs.getLockService().lock(node, LockType.WRITE_LOCK, timeoutSeconds, Lifetime.EPHEMERAL, lockInfo.toJSON());
            if (node == this.fileInfo.getNodeRef()) {
                this.fileInfo.getProperties().put(ContentModel.PROP_LOCK_OWNER, currentUser);
                this.fileInfo.getProperties().put(ContentModel.PROP_EXPIRY_DATE, this.vfs.getNodeService().getProperty(this.fileInfo.getNodeRef(), ContentModel.PROP_EXPIRY_DATE));
            }
            return true;
        }
        catch (Exception e) {
            AlfrescoVirtualFileSystem.checkForRetryingException(e);
            logger.debug("Failed locking node", (Throwable)e);
            return false;
        }
    }

    private boolean unlockNode(NodeRef node) {
        LockService lockService = this.vfs.getLockService();
        LockStatus lockStatus = lockService.getLockStatus(node);
        if (lockStatus == LockStatus.LOCK_OWNER) {
            try {
                lockService.unlock(node);
                return true;
            }
            catch (UnableToReleaseLockException utrle) {
                AlfrescoVirtualFileSystem.checkForRetryingException(utrle);
                logger.debug("Unlock failed.", (Throwable)utrle);
                return false;
            }
        }
        return false;
    }

    private NodeRef getWorkingCopy() {
        if (this.cache_workingCopy != null) {
            return this.cache_workingCopy;
        }
        this.cache_workingCopy = this.vfs.getCheckOutCheckInService().getWorkingCopy(this.fileInfo.getNodeRef());
        return this.cache_workingCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uncheckout(boolean releaseShortTermLock, int callContext) {
        try {
            if (this.isHistoryNode) {
                boolean bl = false;
                return bl;
            }
            if (releaseShortTermLock) {
                boolean bl = this.performUnlock(callContext);
                return bl;
            }
            boolean bl = this.performUncheckout(callContext);
            return bl;
        }
        finally {
            this.cache_isCheckedOut = null;
            this.cache_workingCopy = null;
        }
    }

    private boolean performUnlock(int callContext) {
        LockStatus lockStatus;
        NodeRef nodeToUnlock = this.fileInfo.getNodeRef();
        if (this.isCheckedOut()) {
            nodeToUnlock = this.getWorkingCopy();
        }
        if ((lockStatus = this.vfs.getLockService().getLockStatus(nodeToUnlock)) != LockStatus.LOCK_OWNER) {
            return false;
        }
        return this.unlockNode(nodeToUnlock);
    }

    private boolean performUncheckout(int callContext) {
        NodeRef previousNode;
        NodeRef workingCopy = this.getWorkingCopy();
        if (workingCopy == null) {
            return false;
        }
        LockStatus lockStatus = this.vfs.getLockService().getLockStatus(workingCopy);
        if (lockStatus == LockStatus.LOCKED) {
            return false;
        }
        boolean reCreateLock = false;
        Date initialExpiryDate = null;
        if (lockStatus == LockStatus.LOCK_OWNER) {
            reCreateLock = true;
            initialExpiryDate = (Date)this.vfs.getNodeService().getProperty(workingCopy, ContentModel.PROP_EXPIRY_DATE);
            if (!this.unlockNode(workingCopy)) {
                return false;
            }
        }
        try {
            previousNode = this.vfs.getCheckOutCheckInService().cancelCheckout(workingCopy);
        }
        catch (Exception e) {
            AlfrescoVirtualFileSystem.checkForRetryingException(e);
            logger.debug("Error cancelling check-out", (Throwable)e);
            return false;
        }
        if (reCreateLock && previousNode != null) {
            this.lockNode(previousNode, this.calculateTimeout(initialExpiryDate, 3600));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkin(String comment, boolean keepCheckedOut, int callContext, CheckinType checkinType) {
        try {
            NodeRef nextNode;
            if (this.isHistoryNode) {
                boolean bl = false;
                return bl;
            }
            NodeRef workingCopy = this.getWorkingCopy();
            if (workingCopy == null) {
                boolean bl = false;
                return bl;
            }
            LockStatus lockStatus = this.vfs.getLockService().getLockStatus(workingCopy);
            if (lockStatus == LockStatus.LOCKED) {
                boolean bl = false;
                return bl;
            }
            boolean reCreateLock = false;
            Date initialExpiryDate = null;
            if (lockStatus == LockStatus.LOCK_OWNER) {
                reCreateLock = true;
                initialExpiryDate = (Date)this.vfs.getNodeService().getProperty(workingCopy, ContentModel.PROP_EXPIRY_DATE);
                if (!this.unlockNode(workingCopy)) {
                    boolean bl = false;
                    return bl;
                }
            }
            if (this.vfs.getNodeService().hasAspect(workingCopy, AlfrescoVirtualFileSystem.ASPECT_AOS_CHECKED_OUT_TO_LOCAL)) {
                this.vfs.getNodeService().removeAspect(workingCopy, AlfrescoVirtualFileSystem.ASPECT_AOS_CHECKED_OUT_TO_LOCAL);
            }
            try {
                boolean major = checkinType == CheckinType.MAJOR;
                HashMap<String, Object> versionProperties = new HashMap<String, Object>(5);
                versionProperties.put("versionType", major ? VersionType.MAJOR : VersionType.MINOR);
                if (comment != null) {
                    versionProperties.put("description", comment);
                }
                nextNode = this.vfs.getCheckOutCheckInService().checkin(workingCopy, versionProperties, null, keepCheckedOut);
            }
            catch (Exception e) {
                AlfrescoVirtualFileSystem.checkForRetryingException(e);
                logger.debug("Error checking in node", (Throwable)e);
                boolean bl = false;
                this.cache_isCheckedOut = null;
                this.cache_workingCopy = null;
                return bl;
            }
            if (reCreateLock && nextNode != null) {
                this.lockNode(nextNode, this.calculateTimeout(initialExpiryDate, 3600));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.cache_isCheckedOut = null;
            this.cache_workingCopy = null;
        }
    }

    public boolean isLocked() {
        LockStatus lockStatus;
        NodeRef nodeToCheck = this.fileInfo.getNodeRef();
        if (this.isCheckedOut()) {
            nodeToCheck = this.getWorkingCopy();
        }
        return (lockStatus = this.vfs.getLockService().getLockStatus(nodeToCheck)) == LockStatus.LOCK_OWNER || lockStatus == LockStatus.LOCKED;
    }

    public boolean isCheckedOut() {
        boolean isCurrentUserCheckoutOwner = this.isCurrentUserCheckoutOwner();
        if (this.cache_isCheckedOut != null) {
            return this.cache_isCheckedOut != false && isCurrentUserCheckoutOwner;
        }
        this.cache_isCheckedOut = this.vfs.getCheckOutCheckInService().isCheckedOut(this.fileInfo.getNodeRef());
        return this.cache_isCheckedOut != false && isCurrentUserCheckoutOwner;
    }

    public boolean isLocked(int callContext) {
        return this.isLocked();
    }

    public boolean isCheckedOut(int callContext) {
        return this.isCheckedOut();
    }

    public String getCheckoutOwner(int callContext) {
        return this.getCheckoutOwner();
    }

    public String getWebdavLockToken(String currentLockToken, int callContext) {
        if (this.isCheckedOut(callContext)) {
            String checkOutOwner = this.getCheckoutOwner();
            if (checkOutOwner != null) {
                return WebDAV.makeLockToken((NodeRef)this.fileInfo.getNodeRef(), (String)checkOutOwner);
            }
            return "";
        }
        if (this.isLocked(callContext)) {
            LockState lockState = this.vfs.getLockService().getLockState(this.fileInfo.getNodeRef());
            if (lockState != null && lockState.getOwner() != null) {
                return WebDAV.makeLockToken((NodeRef)this.fileInfo.getNodeRef(), (String)lockState.getOwner());
            }
            return "";
        }
        return "";
    }

    protected ContentResponse getContentResponse() {
        if (this.contentResponse == null) {
            this.contentResponse = this.createContentResponse();
        }
        return this.contentResponse;
    }

    protected ContentResponse createContentResponse() {
        ContentReader contentReader;
        NodeRef nodeToRead = this.fileInfo.getNodeRef();
        if (this.isCheckedOut()) {
            nodeToRead = this.getWorkingCopy();
        }
        if ((contentReader = this.vfs.getFileFolderService().getReader(nodeToRead)) == null) {
            return new EmptyFileContentResponse();
        }
        IOContentFilterRegistry ioContentFilterRegistry = this.vfs.getIoContentFilterRegistry();
        if (ioContentFilterRegistry != null) {
            ContentFilter contentFilter;
            boolean ignoreContentFilter = false;
            if (this.vfs.isFilterIgnoresOOXMLProtected()) {
                ignoreContentFilter = this.checkIfOOXMLProtected(contentReader);
                contentReader = this.vfs.getFileFolderService().getReader(nodeToRead);
            }
            if (!ignoreContentFilter && (contentFilter = ioContentFilterRegistry.getOutputFilter(nodeToRead, contentReader)) != null) {
                ContentResponse contentResponse = FilteredContentResponse.createContentResponse(nodeToRead, contentReader, contentFilter);
                if (contentResponse != null) {
                    return contentResponse;
                }
                contentReader = this.vfs.getFileFolderService().getReader(nodeToRead);
                if (contentReader == null) {
                    return new EmptyFileContentResponse();
                }
            }
        }
        return new RepositoryContentResponse(contentReader);
    }

    private boolean checkIfOOXMLProtected(ContentReader contentReader) {
        String mimeType = this.vfs.getMimetypeService().getMimetypeIfNotMatches(contentReader);
        return "application/x-tika-ooxml-protected".equals(mimeType);
    }

    public void emitContent(OutputStream outputStream, int callContext) {
        try {
            this.getContentResponse().emitContent(outputStream);
        }
        catch (IOException | ContentIOException e) {
            logger.debug("Error reading content from node", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emitContentRange(OutputStream outputStream, long start, long end, boolean multipartHint, int callContext) {
        try {
            InputStream contentInputStream = this.getContentResponse().getContentInputStream();
            if (contentInputStream == null) {
                return;
            }
            try {
                this.copyRange(contentInputStream, outputStream, start, end);
            }
            finally {
                contentInputStream.close();
            }
        }
        catch (ContentIOException e) {
            logger.debug("Error reading content from node", (Throwable)e);
        }
        catch (IOException e) {
            logger.debug("Error writing content to output", (Throwable)e);
        }
    }

    protected void copyRange(InputStream in, OutputStream out, long start, long end) throws IOException {
        in.skip(start);
        byte[] buffer = new byte[1024];
        int num = 0;
        for (long remaining = end - start + 1L; remaining > 0L && (num = in.read(buffer, 0, (int)Math.min(1024L, remaining))) > 0; remaining -= (long)num) {
            out.write(buffer, 0, num);
        }
    }

    public boolean storeContent(VermeerRequest vermeerRequest, int callContext) {
        return this.storeContent(vermeerRequest.getAttachedFileInputStream(), callContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeContent(InputStream in, int callContext) {
        if (this.isHistoryNode) {
            return false;
        }
        NodeRef nodeToWriteTo = this.fileInfo.getNodeRef();
        if (this.isCheckedOut()) {
            nodeToWriteTo = this.getWorkingCopy();
        }
        boolean hadContentBeforeUpdate = false;
        File tempFile = null;
        FileInputStream tempFileInputStream = null;
        InputStream content = null;
        ContentPostProcessor postProcessor = null;
        IOContentFilterRegistry ioContentFilterRegistry = this.vfs.getIoContentFilterRegistry();
        try {
            final NodeRef finalNodeToWriteTo = nodeToWriteTo;
            this.vfs.getTransactionService().getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    if (DocumentNode.this.vfs.getNodeService().exists(finalNodeToWriteTo)) {
                        boolean hasContent;
                        boolean isVersionable = DocumentNode.this.vfs.getNodeService().hasAspect(finalNodeToWriteTo, ContentModel.ASPECT_VERSIONABLE);
                        ContentData contentData = (ContentData)DocumentNode.this.vfs.getNodeService().getProperty(finalNodeToWriteTo, ContentModel.PROP_CONTENT);
                        boolean bl = hasContent = contentData != null && contentData.getSize() > 0L;
                        if (DocumentNode.this.activateVersioningOnWrite && !isVersionable && hasContent) {
                            HashMap initialVersionProps = new HashMap(1, 1.0f);
                            DocumentNode.this.vfs.getVersionService().ensureVersioningEnabled(DocumentNode.this.fileInfo.getNodeRef(), initialVersionProps);
                        }
                    }
                    return null;
                }
            }, false, true);
            ContentData contentData = (ContentData)this.vfs.getNodeService().getProperty(nodeToWriteTo, ContentModel.PROP_CONTENT);
            boolean bl = hadContentBeforeUpdate = contentData != null && contentData.getSize() > 0L;
            if (ioContentFilterRegistry != null) {
                ContentFilter filter;
                InputStream readFromStream = in;
                PushbackInputStream previewStream = null;
                int previewBytes = ioContentFilterRegistry.getMaxInputPreviewByteCount();
                if (previewBytes > 0) {
                    previewStream = new PushbackInputStream(in, previewBytes);
                    readFromStream = previewStream;
                }
                if ((filter = ioContentFilterRegistry.getInputFilter(this.vfs.getMimetypeService().guessMimetype(this.fileInfo.getName()), previewStream, nodeToWriteTo)) != null) {
                    tempFile = TempFileProvider.createTempFile((InputStream)readFromStream, (String)"AosDocumentNodeInput", (String)"tmp");
                    tempFileInputStream = new FileInputStream(tempFile);
                    ContentFilterProcessingResult processingResult = filter.process(nodeToWriteTo, tempFileInputStream, null, true);
                    if (processingResult != null) {
                        postProcessor = processingResult.getPostProcessor();
                    }
                    tempFileInputStream.close();
                    tempFileInputStream = new FileInputStream(tempFile);
                    content = tempFileInputStream;
                } else {
                    content = readFromStream;
                }
            } else {
                content = in;
            }
            ContentWriter writer = this.vfs.getFileFolderService().getWriter(nodeToWriteTo);
            writer.guessMimetype(this.fileInfo.getName());
            writer.guessEncoding();
            writer.putContent(content);
            if (postProcessor != null) {
                postProcessor.execute(nodeToWriteTo);
            }
            if (this.activateVersioningOnWrite && !this.vfs.getNodeService().hasAspect(nodeToWriteTo, ContentModel.ASPECT_VERSIONABLE)) {
                HashMap initialVersionProps = new HashMap(1, 1.0f);
                this.vfs.getVersionService().ensureVersioningEnabled(this.fileInfo.getNodeRef(), initialVersionProps);
            }
        }
        catch (AccessDeniedException ade) {
            logger.debug("Access to content denied.", (Throwable)ade);
            boolean bl = false;
            return bl;
        }
        catch (Throwable t) {
            AlfrescoVirtualFileSystem.checkForRetryingException(t);
            logger.error("Error writing content.", t);
            boolean bl = false;
            return bl;
        }
        finally {
            if (tempFileInputStream != null) {
                try {
                    tempFileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (tempFile != null) {
                tempFile.delete();
            }
        }
        try {
            if (hadContentBeforeUpdate) {
                String siteId = this.getSiteId();
                if (siteId != null && !siteId.isEmpty()) {
                    this.vfs.getActivityPoster().postFileFolderUpdated(siteId, this.vfs.getTenantDomain(), this.vfs.getFileFolderService().getFileInfo(nodeToWriteTo));
                }
            } else {
                Pair<String, String> activitySiteAndPath = this.vfs.getActivitySiteAndPath(nodeToWriteTo);
                if (!"".equals(activitySiteAndPath.getFirst())) {
                    this.vfs.getActivityPoster().postFileFolderAdded((String)activitySiteAndPath.getFirst(), this.vfs.getTenantDomain(), null, this.vfs.getFileFolderService().getFileInfo(nodeToWriteTo));
                }
            }
        }
        catch (Exception e) {
            logger.error("DocumentNode.storeContent: Error posting activity.", (Throwable)e);
        }
        return true;
    }

    public VersionNumber getVersionNumber() {
        VersionNumber versionNumber = VersionNumber.parseSafe((String)((Object)this.vfs.getNodeService().getProperty(this.fileInfo.getNodeRef(), ContentModel.PROP_VERSION_LABEL)));
        if (this.isCheckedOut()) {
            versionNumber = versionNumber.getNextMinor();
        }
        return versionNumber;
    }

    public List<VFSDocumentVersion> getVersions(int callContext) {
        ArrayList<VFSDocumentVersion> result = new ArrayList<VFSDocumentVersion>();
        boolean hasWorkingCopy = this.isCheckedOut();
        VersionNumber maxVersion = VersionNumber.INITIAL;
        VersionHistory versionHistory = this.vfs.getVersionService().getVersionHistory(this.fileInfo.getNodeRef());
        if (versionHistory == null) {
            Object versionLabel = (String)((Object)this.vfs.getNodeService().getProperty(this.fileInfo.getNodeRef(), ContentModel.PROP_VERSION_LABEL));
            if (versionLabel == null) {
                versionLabel = VersionNumber.INITIAL.toString();
            } else {
                maxVersion = VersionNumber.max(maxVersion, VersionNumber.parseSafe((String)versionLabel));
            }
            Date dateCreated = (Date)this.vfs.getNodeService().getProperty(this.fileInfo.getNodeRef(), ContentModel.PROP_CREATED);
            String userCreated = (String)((Object)this.vfs.getNodeService().getProperty(this.fileInfo.getNodeRef(), ContentModel.PROP_CREATOR));
            ContentReader reader = this.vfs.getFileFolderService().getReader(this.fileInfo.getNodeRef());
            long fileSize = reader == null ? 0L : reader.getSize();
            Object path = this.relativePath;
            if (hasWorkingCopy) {
                path = "/_aos_history/" + (String)versionLabel + this.relativePath;
            } else {
                versionLabel = "@" + (String)versionLabel;
            }
            result.add(new VFSDocumentVersion((String)versionLabel, (String)path, dateCreated, userCreated, fileSize, ""));
        } else {
            Version headVersion = versionHistory.getHeadVersion();
            for (Version version : versionHistory.getAllVersions()) {
                Object versionLabel = version.getVersionLabel();
                if (versionLabel == null) {
                    versionLabel = VersionNumber.INITIAL.toString();
                } else {
                    maxVersion = VersionNumber.max(maxVersion, VersionNumber.parseSafe((String)versionLabel));
                }
                Date dateCreated = version.getFrozenModifiedDate();
                String userCreated = version.getFrozenModifier();
                String comment = version.getDescription();
                ContentReader reader = this.vfs.getFileFolderService().getReader(version.getFrozenStateNodeRef());
                long fileSize = reader == null ? 0L : reader.getSize();
                Object path = "/_aos_history/" + (String)versionLabel + this.relativePath;
                if (!hasWorkingCopy && version.equals(headVersion)) {
                    versionLabel = "@" + (String)versionLabel;
                    path = this.relativePath;
                }
                result.add(new VFSDocumentVersion((String)versionLabel, (String)path, dateCreated, userCreated, fileSize, comment));
            }
        }
        if (hasWorkingCopy) {
            NodeRef workingCopy = this.getWorkingCopy();
            String versionLabel = "@" + maxVersion.getNextMinor().toString();
            Date dateCreated = (Date)this.vfs.getNodeService().getProperty(workingCopy, ContentModel.PROP_CREATED);
            String userCreated = (String)((Object)this.vfs.getNodeService().getProperty(workingCopy, ContentModel.PROP_CREATOR));
            ContentReader reader = this.vfs.getFileFolderService().getReader(workingCopy);
            long fileSize = reader == null ? 0L : reader.getSize();
            String path = this.relativePath;
            result.add(new VFSDocumentVersion(versionLabel, path, dateCreated, userCreated, fileSize, ""));
        }
        return result;
    }

    public boolean rename(String newName, int callContext) {
        if (this.isHistoryNode) {
            return false;
        }
        FileFolderService fileFolderService = this.vfs.getFileFolderService();
        try {
            int i = this.relativePath.lastIndexOf(47);
            String relativeParentFolderPath = this.relativePath.substring(0, i);
            FileInfo parentFolder = this.vfs.getFileInfoForPath(relativeParentFolderPath);
            this.deleteNodeInFolder(parentFolder.getNodeRef(), newName);
            fileFolderService.rename(this.fileInfo.getNodeRef(), newName);
            return true;
        }
        catch (Exception e) {
            logger.debug("Error renaming node", (Throwable)e);
            return false;
        }
    }

    private void deleteNodeInFolder(NodeRef nodeRef, String name) {
        NodeRef childNode = this.vfs.getNodeService().getChildByName(nodeRef, ContentModel.ASSOC_CONTAINS, name);
        if (childNode != null) {
            this.vfs.getFileFolderService().delete(childNode);
        }
    }

    public boolean delete(int callContext) {
        if (this.isHistoryNode) {
            return false;
        }
        try {
            NodeRef parentNodeRef = this.vfs.getNodeService().getPrimaryParent(this.fileInfo.getNodeRef()).getParentRef();
            this.vfs.getFileFolderService().delete(this.fileInfo.getNodeRef());
            try {
                FileInfo parentFileInfo = this.vfs.getFileFolderService().getFileInfo(parentNodeRef);
                Pair<String, String> activitySiteAndPath = this.vfs.getActivitySiteAndPath(parentNodeRef);
                if (!"".equals(activitySiteAndPath.getFirst())) {
                    this.vfs.getActivityPoster().postFileFolderDeleted((String)activitySiteAndPath.getFirst(), this.vfs.getTenantDomain(), (String)activitySiteAndPath.getSecond(), parentFileInfo, this.fileInfo);
                }
            }
            catch (Exception e) {
                logger.error("DocumentNode.delete: Error posting activity.", (Throwable)e);
            }
            return true;
        }
        catch (Exception e) {
            AlfrescoVirtualFileSystem.checkForRetryingException(e);
            logger.debug("Error deleting node", (Throwable)e);
            return false;
        }
    }

    public boolean move(UserData userData, String destinationPath, int callContext) {
        if (this.isHistoryNode) {
            return false;
        }
        try {
            FileInfo destination;
            String newParentPath = "/";
            String newName = destinationPath;
            int i = destinationPath.lastIndexOf(47);
            if (i >= 0) {
                newParentPath = destinationPath.substring(0, i);
                newName = destinationPath.substring(i + 1);
            }
            if ((destination = this.vfs.getFileInfoForPath(newParentPath)) == null) {
                return false;
            }
            if (!destination.isFolder() || destination.isLink()) {
                return false;
            }
            this.deleteNodeInFolder(destination.getNodeRef(), newName);
            this.vfs.getFileFolderService().move(this.fileInfo.getNodeRef(), destination.getNodeRef(), newName);
            return true;
        }
        catch (Exception e) {
            AlfrescoVirtualFileSystem.checkForRetryingException(e);
            logger.debug("Error moving node", (Throwable)e);
            return false;
        }
    }

    public boolean copy(UserData userData, String destinationPath, int callContext) {
        return false;
    }

    public String getContentTypeName() {
        QName nodeTypeQname = this.vfs.getNodeService().getType(this.fileInfo.getNodeRef());
        ClassDefinition classDefinition = this.vfs.getDictionaryService().getClass(nodeTypeQname);
        String contentTypeName = classDefinition.getTitle((MessageLookup)this.vfs.getDictionaryService());
        if (contentTypeName == null || contentTypeName.isEmpty()) {
            contentTypeName = nodeTypeQname.getLocalName();
        }
        return contentTypeName;
    }

    public ContentTypeId getContentTypeId() {
        return ContentTypeId.DOCUMENT.getChild(Guid.parse((String)this.fileInfo.getNodeRef().getId()));
    }

    public VFSNode getContainmentByName(UserData userData, String name, int callContext) {
        return null;
    }

    public List<VFSNode> getEnumerableContainees(UserData userData, int callContext) {
        return null;
    }

    public VFSDocumentNode createNewFile(UserData userData, String filename, VermeerRequest request, int callContext) {
        return null;
    }

    public VFSDocumentNode createNewFile(UserData userData, String filename, InputStream content, int callContext) {
        return null;
    }

    public VFSNode createNewFolder(UserData userData, String foldername, int callContext) {
        return null;
    }

    public boolean isCurrentUserCheckoutOwner() {
        if (this.ignoreCurrentUser) {
            return true;
        }
        LockService lockService = this.vfs.getLockService();
        LockStatus lockStatus = lockService.getLockStatus(this.fileInfo.getNodeRef());
        return lockStatus == LockStatus.LOCK_OWNER;
    }
}

