/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.vfs;

public class VersionNumber {
    public static final char VERSION_SEPARATOR = '.';
    public static final VersionNumber INITIAL = new VersionNumber(1, 0);
    private int major;
    private int minor;

    public VersionNumber(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toString(this.major));
        sb.append('.');
        sb.append(Integer.toString(this.minor));
        return sb.toString();
    }

    public VersionNumber getNextMajor() {
        return new VersionNumber(this.major + 1, 0);
    }

    public VersionNumber getNextMinor() {
        return new VersionNumber(this.major, this.minor + 1);
    }

    public int compareTo(VersionNumber v2) {
        if (this.major < v2.major) {
            return -1;
        }
        if (this.major > v2.major) {
            return 1;
        }
        if (this.minor < v2.minor) {
            return -1;
        }
        if (this.minor > v2.minor) {
            return 1;
        }
        return 0;
    }

    public static VersionNumber max(VersionNumber v1, VersionNumber v2) {
        return v1.compareTo(v2) >= 0 ? v1 : v2;
    }

    public static VersionNumber min(VersionNumber v1, VersionNumber v2) {
        return v1.compareTo(v2) <= 0 ? v1 : v2;
    }

    public static VersionNumber parseSafe(String s) {
        if (s == null) {
            return INITIAL;
        }
        int pos = s.indexOf(46);
        if (pos >= 0) {
            try {
                String majorPart = s.substring(0, pos);
                String minorPart = s.substring(pos + 1);
                return new VersionNumber(Integer.parseInt(majorPart), Integer.parseInt(minorPart));
            }
            catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                return INITIAL;
            }
        }
        try {
            return new VersionNumber(Integer.parseInt(s), 0);
        }
        catch (NumberFormatException e) {
            return INITIAL;
        }
    }
}

