/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.officeservices.AbstractVermeerService;
import org.alfresco.officeservices.GetOption;
import org.alfresco.officeservices.ServiceLogger;
import org.alfresco.officeservices.exceptions.AccessDeniedException;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.exceptions.MalformedVermeerRequestException;
import org.alfresco.officeservices.exceptions.VermeerException;
import org.alfresco.officeservices.protocol.VermeerParameterBoolean;
import org.alfresco.officeservices.protocol.VermeerParameterDictionary;
import org.alfresco.officeservices.protocol.VermeerParameterInteger;
import org.alfresco.officeservices.protocol.VermeerParameterSpecialBoolean;
import org.alfresco.officeservices.protocol.VermeerParameterString;
import org.alfresco.officeservices.protocol.VermeerParameterVectorString;
import org.alfresco.officeservices.protocol.VermeerParameterVectorUrlinfo;
import org.alfresco.officeservices.protocol.VermeerRequest;
import org.alfresco.officeservices.protocol.VermeerResponse;

public abstract class AbstractAuthorService
extends AbstractVermeerService {
    private static final long serialVersionUID = -6495710720757390517L;
    private static final ServiceLogger logger = new ServiceLogger(AbstractAuthorService.class);
    public static final String METHODNAME_OPEN_SERVICE = "open service";
    public static final String METHODNAME_GET_DOCUMENT = "get document";
    public static final String METHODNAME_GET_DOCUMENTS = "get documents";
    public static final String METHODNAME_PUT_DOCUMENT = "put document";
    public static final String METHODNAME_PUT_DOCUMENTS = "put documents";
    public static final String METHODNAME_MOVE_DOCUMENT = "move document";
    public static final String METHODNAME_GETDOCSMETAINFO = "getdocsmetainfo";
    public static final String METHODNAME_CHECKOUT_DOCUMENT = "checkout document";
    public static final String METHODNAME_UNCHECKOUT_DOCUMENT = "uncheckout document";
    public static final String METHODNAME_CHECKIN_DOCUMENT = "checkin document";
    public static final String METHODNAME_LIST_DOCUMENTS = "list documents";
    public static final String METHODNAME_CREATE_URLDIRECTORIES = "create url-directories";
    public static final String METHODNAME_CREATE_URLDIRECTORY = "create url-directory";
    public static final String METHODNAME_REMOVE_DOCUMENTS = "remove documents";

    @Override
    public void vermeerService(String methodname, VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) throws IOException, VermeerException, AuthenticationRequiredException, AccessDeniedException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (methodname.equalsIgnoreCase(METHODNAME_OPEN_SERVICE)) {
            this.vermeerOpenService(vermeerRequest, vermeerResponse);
        } else if (methodname.equalsIgnoreCase(METHODNAME_GET_DOCUMENT)) {
            this.vermeerGetDocument(vermeerRequest, vermeerResponse);
        } else if (methodname.equalsIgnoreCase(METHODNAME_GET_DOCUMENTS)) {
            this.vermeerGetDocuments(vermeerRequest, vermeerResponse);
        } else if (methodname.equalsIgnoreCase(METHODNAME_PUT_DOCUMENT)) {
            this.vermeerPutDocument(vermeerRequest, vermeerResponse);
        } else if (methodname.equalsIgnoreCase(METHODNAME_PUT_DOCUMENTS)) {
            this.vermeerPutDocuments(vermeerRequest, vermeerResponse);
        } else if (methodname.equalsIgnoreCase(METHODNAME_MOVE_DOCUMENT)) {
            this.vermeerMoveDocument(vermeerRequest, vermeerResponse);
        } else if (methodname.equalsIgnoreCase(METHODNAME_GETDOCSMETAINFO)) {
            this.vermeerGetDocsMetaInfo(vermeerRequest, vermeerResponse);
        } else if (methodname.equalsIgnoreCase(METHODNAME_CHECKOUT_DOCUMENT)) {
            this.vermeerCheckoutDocument(vermeerRequest, vermeerResponse);
        } else if (methodname.equalsIgnoreCase(METHODNAME_UNCHECKOUT_DOCUMENT)) {
            this.vermeerUncheckoutDocument(vermeerRequest, vermeerResponse);
        } else if (methodname.equalsIgnoreCase(METHODNAME_CHECKIN_DOCUMENT)) {
            this.vermeerCheckinDocument(vermeerRequest, vermeerResponse);
        } else if (methodname.equalsIgnoreCase(METHODNAME_LIST_DOCUMENTS)) {
            this.vermeerListDocuments(vermeerRequest, vermeerResponse);
        } else if (methodname.equalsIgnoreCase(METHODNAME_CREATE_URLDIRECTORIES)) {
            this.vermeerCreateUrlDirectories(vermeerRequest, vermeerResponse);
        } else if (methodname.equalsIgnoreCase(METHODNAME_CREATE_URLDIRECTORY)) {
            this.vermeerCreateUrlDirectory(vermeerRequest, vermeerResponse);
        } else if (methodname.equalsIgnoreCase(METHODNAME_REMOVE_DOCUMENTS)) {
            this.vermeerRemoveDocuments(vermeerRequest, vermeerResponse);
        } else {
            logger.error("vermeerService: unknown RPC methodname " + methodname);
            vermeerResponse.error("unknown method key");
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected void vermeerOpenService(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        this.openService(vermeerRequest, vermeerResponse);
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract void openService(VermeerRequest var1, VermeerResponse var2) throws IOException, VermeerException, AuthenticationRequiredException;

    protected void vermeerGetDocument(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
            logger.traceRawVermeerParameter(vermeerRequest, "document_name");
            logger.traceRawVermeerParameter(vermeerRequest, "get_option");
            logger.traceRawVermeerParameter(vermeerRequest, "force");
            logger.traceRawVermeerParameter(vermeerRequest, "timeout");
        }
        VermeerParameterString document_name = new VermeerParameterString(vermeerRequest, "document_name", true);
        VermeerParameterString get_option = new VermeerParameterString(vermeerRequest, "get_option", true);
        VermeerParameterSpecialBoolean force = new VermeerParameterSpecialBoolean(vermeerRequest, "force", true);
        VermeerParameterInteger timeout = new VermeerParameterInteger(vermeerRequest, "timeout", true);
        GetOption getoption = GetOption.NONE;
        if (get_option.getValue().equalsIgnoreCase("none")) {
            getoption = GetOption.NONE;
        } else if (get_option.getValue().equalsIgnoreCase("chkoutexclusive")) {
            getoption = GetOption.CHKOUTEXCLUSIVE;
        } else if (get_option.getValue().equalsIgnoreCase("chkoutnonexclusive")) {
            getoption = GetOption.CHKOUTNONEXCLUSIVE;
        }
        this.getDocument(vermeerRequest, vermeerResponse, document_name.getValue(), getoption, force.internalValue(), timeout.getValue());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract void getDocument(VermeerRequest var1, VermeerResponse var2, String var3, GetOption var4, int var5, int var6) throws IOException, VermeerException, AuthenticationRequiredException;

    protected void vermeerGetDocuments(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        vermeerResponse.error("unable to handle this method");
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected void vermeerPutDocument(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) throws IOException, VermeerException, AuthenticationRequiredException, AccessDeniedException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
            logger.traceRawVermeerParameter(vermeerRequest, "document");
            logger.traceRawVermeerParameter(vermeerRequest, "put_option");
            logger.traceRawVermeerParameter(vermeerRequest, "comment");
            logger.traceRawVermeerParameter(vermeerRequest, "keep_checked_out");
        }
        VermeerParameterDictionary document = new VermeerParameterDictionary(vermeerRequest, "document", true);
        VermeerParameterString put_option = new VermeerParameterString(vermeerRequest, "put_option", true);
        VermeerParameterString comment = new VermeerParameterString(vermeerRequest, "comment", true);
        VermeerParameterBoolean keep_checked_out = new VermeerParameterBoolean(vermeerRequest, "keep_checked_out", true);
        String documentName = document.get("document_name");
        if (documentName == null) {
            throw new MalformedVermeerRequestException("document_name missing");
        }
        String metaInfoData = document.get("meta_info");
        HashMap<String, String> metaInfo = new HashMap<String, String>();
        if (metaInfoData != null) {
            VermeerParameterVectorString metaInfoVector = new VermeerParameterVectorString(metaInfoData);
            if (metaInfoVector.getSize() % 2 != 0) {
                throw new MalformedVermeerRequestException("document meta_info malformed.");
            }
            for (int i = 0; i < metaInfoVector.getSize(); i += 2) {
                metaInfo.put(metaInfoVector.get(i), metaInfoVector.get(i + 1));
            }
        }
        this.putDocument(vermeerRequest, vermeerResponse, documentName, metaInfo, put_option.getValue(), comment.getValue(), keep_checked_out.getValue());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract void putDocument(VermeerRequest var1, VermeerResponse var2, String var3, Map<String, String> var4, String var5, String var6, boolean var7) throws IOException, VermeerException, AuthenticationRequiredException, AccessDeniedException;

    protected void vermeerPutDocuments(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        vermeerResponse.error("unable to handle this method");
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected void vermeerMoveDocument(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
            logger.traceRawVermeerParameter(vermeerRequest, "oldUrl");
            logger.traceRawVermeerParameter(vermeerRequest, "newUrl");
            logger.traceRawVermeerParameter(vermeerRequest, "put_option");
            logger.traceRawVermeerParameter(vermeerRequest, "rename_option");
            logger.traceRawVermeerParameter(vermeerRequest, "docopy");
        }
        VermeerParameterString oldUrl = new VermeerParameterString(vermeerRequest, "oldUrl", true);
        VermeerParameterString newUrl = new VermeerParameterString(vermeerRequest, "newUrl", true);
        VermeerParameterString put_option = new VermeerParameterString(vermeerRequest, "put_option", false);
        VermeerParameterString rename_option = new VermeerParameterString(vermeerRequest, "rename_option", false);
        VermeerParameterBoolean docopy = new VermeerParameterBoolean(vermeerRequest, "docopy", false);
        if (!docopy.isNull() && docopy.getValue()) {
            this.moveDocument_Copy(vermeerRequest, vermeerResponse, oldUrl.getValue(), newUrl.getValue(), put_option.getValue(), rename_option.getValue());
        } else {
            this.moveDocument(vermeerRequest, vermeerResponse, oldUrl.getValue(), newUrl.getValue(), put_option.getValue(), rename_option.getValue());
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract void moveDocument(VermeerRequest var1, VermeerResponse var2, String var3, String var4, String var5, String var6) throws IOException, VermeerException, AuthenticationRequiredException;

    public abstract void moveDocument_Copy(VermeerRequest var1, VermeerResponse var2, String var3, String var4, String var5, String var6) throws IOException, VermeerException, AuthenticationRequiredException;

    protected void vermeerGetDocsMetaInfo(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
            logger.traceRawVermeerParameter(vermeerRequest, "url_list");
        }
        VermeerParameterVectorString url_list = new VermeerParameterVectorString(vermeerRequest, "url_list", true);
        this.getDocsMetaInfo(vermeerRequest, vermeerResponse, url_list);
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract void getDocsMetaInfo(VermeerRequest var1, VermeerResponse var2, VermeerParameterVectorString var3) throws IOException, VermeerException, AuthenticationRequiredException;

    protected void vermeerCheckoutDocument(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
            logger.traceRawVermeerParameter(vermeerRequest, "document_name");
            logger.traceRawVermeerParameter(vermeerRequest, "force");
            logger.traceRawVermeerParameter(vermeerRequest, "timeout");
        }
        VermeerParameterString document_name = new VermeerParameterString(vermeerRequest, "document_name", true);
        VermeerParameterInteger force = new VermeerParameterInteger(vermeerRequest, "force", true);
        VermeerParameterInteger timeout = new VermeerParameterInteger(vermeerRequest, "timeout", true);
        this.checkoutDocument(vermeerRequest, vermeerResponse, document_name.getValue(), (force.getValue() & 1) != 0, (force.getValue() & 2) != 0, timeout.getValue());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract void checkoutDocument(VermeerRequest var1, VermeerResponse var2, String var3, boolean var4, boolean var5, int var6) throws IOException, VermeerException, AuthenticationRequiredException;

    protected void vermeerUncheckoutDocument(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
            logger.traceRawVermeerParameter(vermeerRequest, "document_name");
            logger.traceRawVermeerParameter(vermeerRequest, "force");
            logger.traceRawVermeerParameter(vermeerRequest, "rlsshortterm");
        }
        VermeerParameterString document_name = new VermeerParameterString(vermeerRequest, "document_name", true);
        VermeerParameterBoolean force = new VermeerParameterBoolean(vermeerRequest, "force", true);
        VermeerParameterBoolean rlsshortterm = new VermeerParameterBoolean(vermeerRequest, "rlsshortterm", true);
        this.uncheckoutDocument(vermeerRequest, vermeerResponse, document_name.getValue(), force.getValue(), rlsshortterm.getValue());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract void uncheckoutDocument(VermeerRequest var1, VermeerResponse var2, String var3, boolean var4, boolean var5) throws IOException, VermeerException, AuthenticationRequiredException;

    protected void vermeerCheckinDocument(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
            logger.traceRawVermeerParameter(vermeerRequest, "document_name");
            logger.traceRawVermeerParameter(vermeerRequest, "comment");
            logger.traceRawVermeerParameter(vermeerRequest, "keep_checked_out");
        }
        VermeerParameterString document_name = new VermeerParameterString(vermeerRequest, "document_name", true);
        VermeerParameterString comment = new VermeerParameterString(vermeerRequest, "comment", true);
        VermeerParameterBoolean keep_checked_out = new VermeerParameterBoolean(vermeerRequest, "keep_checked_out", true);
        this.checkinDocument(vermeerRequest, vermeerResponse, document_name.getValue(), comment.getValue(), keep_checked_out.getValue());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract void checkinDocument(VermeerRequest var1, VermeerResponse var2, String var3, String var4, boolean var5) throws IOException, VermeerException, AuthenticationRequiredException;

    protected void vermeerListDocuments(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
            logger.traceRawVermeerParameter(vermeerRequest, "initialUrl");
        }
        VermeerParameterString initialUrl = new VermeerParameterString(vermeerRequest, "initialUrl", true);
        this.listDocuments(vermeerRequest, vermeerResponse, initialUrl.getValue());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract void listDocuments(VermeerRequest var1, VermeerResponse var2, String var3) throws IOException, VermeerException, AuthenticationRequiredException;

    protected void vermeerCreateUrlDirectories(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
            logger.traceRawVermeerParameter(vermeerRequest, "urldirs");
        }
        VermeerParameterVectorUrlinfo urlDirs = new VermeerParameterVectorUrlinfo(vermeerRequest, "urldirs", true);
        this.createUrlDirectories(vermeerRequest, vermeerResponse, urlDirs);
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract void createUrlDirectories(VermeerRequest var1, VermeerResponse var2, VermeerParameterVectorUrlinfo var3) throws IOException, VermeerException, AuthenticationRequiredException;

    protected void vermeerCreateUrlDirectory(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        vermeerResponse.error("unable to handle this method");
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected void vermeerRemoveDocuments(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
            logger.traceRawVermeerParameter(vermeerRequest, "url_list");
        }
        VermeerParameterVectorString url_list = new VermeerParameterVectorString(vermeerRequest, "url_list", true);
        this.removeDocuments(vermeerRequest, vermeerResponse, url_list);
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract void removeDocuments(VermeerRequest var1, VermeerResponse var2, VermeerParameterVectorString var3) throws IOException, VermeerException, AuthenticationRequiredException;
}

