/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.alfresco.officeservices.ServiceLogger;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;

public abstract class AbstractBrowsingService
extends HttpServlet {
    private static final long serialVersionUID = 7058094050877980606L;
    private static final ServiceLogger logger = new ServiceLogger(AbstractBrowsingService.class);
    public static final String DIALOGVIEW_FILEOPEN = "fileopen";
    public static final String DIALOGVIEW_FILESAVE = "filesave";
    public static final String DIALOGVIEW_SAVEFORM = "saveform";

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("doHead: Sending \"200 OK\" on HEAD request");
        }
        resp.setStatus(200);
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        this.handleRequest(req, resp);
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        this.handleRequest(req, resp);
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block21: {
            UserData userData;
            if (logger.isTraceEnabled()) {
                logger.traceEnter();
            }
            String dialogview = request.getParameter("dialogview");
            String location = request.getParameter("location");
            if (dialogview == null) {
                logger.error("handleRequest: Parameter \"dialogview\" missing");
                response.setStatus(500);
                response.getWriter().print("Internal server error: required parameter dialogview is missing.");
                if (logger.isTraceEnabled()) {
                    logger.traceExit();
                }
                return;
            }
            if (location == null) {
                logger.error("handleRequest: Parameter \"location\" missing");
                response.setStatus(500);
                response.getWriter().print("Internal server error: required parameter location is missing.");
                if (logger.isTraceEnabled()) {
                    logger.traceExit();
                }
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("handleRequest: dialogview=" + dialogview);
                logger.debug("handleRequest: location=" + location);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("handleRequest: negogiating authentication");
            }
            if ((userData = this.negotiateAuthentication(request, response)) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("handleRequest: authentication negogiation requested immediate return.");
                }
                if (logger.isTraceEnabled()) {
                    logger.traceExit();
                }
                return;
            }
            try {
                try {
                    if (dialogview.equalsIgnoreCase(DIALOGVIEW_FILEOPEN)) {
                        this.doFileDialog(userData, false, location, request, response);
                        break block21;
                    }
                    if (dialogview.equalsIgnoreCase(DIALOGVIEW_FILESAVE)) {
                        this.doFileDialog(userData, true, location, request, response);
                        break block21;
                    }
                    if (dialogview.equalsIgnoreCase(DIALOGVIEW_SAVEFORM)) {
                        this.doPropertiesDialog(userData, location, request, response);
                        break block21;
                    }
                    logger.error("handleRequest: Unknown dialogview. dialogview=" + dialogview);
                    response.setStatus(500);
                    response.getWriter().print("Internal server error: unable to handle the requested dialogview.");
                }
                catch (AuthenticationRequiredException are) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("handleRequest: vermeerService requested authentication.");
                    }
                    this.requestAuthentication(request, response);
                }
                catch (Exception e) {
                    logger.error("handleRequest: Unexpected Exception while handling request", e);
                    response.setStatus(500);
                    response.getWriter().print("500: Internal server error.");
                }
            }
            finally {
                this.invalidateAuthentication(userData, request, response);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract UserData negotiateAuthentication(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    public abstract void requestAuthentication(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    public abstract void invalidateAuthentication(UserData var1, HttpServletRequest var2, HttpServletResponse var3) throws IOException;

    public abstract void doFileDialog(UserData var1, boolean var2, String var3, HttpServletRequest var4, HttpServletResponse var5) throws ServletException, IOException, AuthenticationRequiredException;

    public abstract void doPropertiesDialog(UserData var1, String var2, HttpServletRequest var3, HttpServletResponse var4) throws ServletException, IOException, AuthenticationRequiredException;
}

