/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices;

import java.io.IOException;
import java.io.PrintStream;
import org.alfresco.officeservices.AbstractSoapService;
import org.alfresco.officeservices.datamodel.FieldValue;
import org.alfresco.officeservices.datamodel.XMLValueFormatterParser;

public class FieldInformation {
    protected String id;
    protected String internalName;
    protected String displayName;
    protected String type;
    protected String value;

    public FieldInformation(FieldValue fieldValue) {
        this.id = fieldValue.getDefinition().getID().toString();
        this.internalName = fieldValue.getDefinition().getName();
        this.displayName = fieldValue.getDefinition().getDisplayName();
        this.type = fieldValue.getDefinition().getFieldType().getTypeString();
        this.value = XMLValueFormatterParser.getInstance().format(fieldValue.getDefinition(), fieldValue.getValue());
    }

    public void write(PrintStream out) throws IOException {
        out.print("<FieldInformation");
        AbstractSoapService.writeXmlAttribute(out, "Id", this.id, true);
        AbstractSoapService.writeXmlAttribute(out, "Type", this.type, true);
        AbstractSoapService.writeXmlAttribute(out, "InternalName", this.internalName, true);
        AbstractSoapService.writeXmlAttribute(out, "DisplayName", this.displayName, true);
        if (this.value != null) {
            AbstractSoapService.writeXmlAttribute(out, "Value", this.value, true);
        }
        out.print(" />");
    }
}

