/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.officeservices.AbstractVersionsService;
import org.alfresco.officeservices.ServiceLogger;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.vfs.VFSDocumentNode;
import org.alfresco.officeservices.vfs.VFSDocumentVersion;
import org.alfresco.officeservices.vfs.VirtualFileSystem;

public abstract class StandardVersionsService
extends AbstractVersionsService {
    private static final long serialVersionUID = 8282089887134693258L;
    private static final ServiceLogger logger = new ServiceLogger(StandardVersionsService.class);

    public abstract VirtualFileSystem getVirtualFileSystem(UserData var1) throws AuthenticationRequiredException;

    @Override
    public String getListGUID(UserData userData, String filename) {
        return "{12345678-0000-0000-0000-1234567890AB}";
    }

    @Override
    public List<AbstractVersionsService.VersionInformation> getVersions(UserData userData, String baseUrl, String filename) throws AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getVersions: baseUrl=" + baseUrl);
            logger.debug("getVersions: filename=" + filename);
        }
        VFSDocumentNode document = null;
        try {
            document = (VFSDocumentNode)this.getVirtualFileSystem(userData).getNodeByPath(userData, filename, 1);
        }
        catch (ClassCastException cce) {
            if (logger.isDebugEnabled()) {
                logger.debug("getVersions: virtual file system returned a non-document node (i.e. a directory)");
            }
            document = null;
        }
        if (document == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("getVersions: document not found. filename=" + filename);
            }
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return null;
        }
        List<VFSDocumentVersion> documentVersions = document.getVersions(1);
        if (documentVersions == null) {
            logger.error("getVersions: error retrieving versions from document. Got NULL instead of list of versions. filename=" + filename);
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return null;
        }
        ArrayList<AbstractVersionsService.VersionInformation> resultVersions = new ArrayList<AbstractVersionsService.VersionInformation>();
        for (VFSDocumentVersion documentVersion : documentVersions) {
            resultVersions.add(new AbstractVersionsService.VersionInformation(documentVersion.getVersion(), baseUrl + documentVersion.getVFSFilename(), documentVersion.getCreatedOn(), documentVersion.getCreatedBy(), documentVersion.getCreatedBy(), Long.toString(documentVersion.getSize()), documentVersion.getComments()));
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
        return resultVersions;
    }

    @Override
    public boolean restoreVersion(UserData userData, String fileName, String fileVersion) throws AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("restoreVersion: fileName=" + fileName);
            logger.debug("restoreVersion: fileVersion=" + fileVersion);
        }
        VFSDocumentNode document = null;
        try {
            document = (VFSDocumentNode)this.getVirtualFileSystem(userData).getNodeByPath(userData, fileName, 1);
        }
        catch (ClassCastException cce) {
            if (logger.isDebugEnabled()) {
                logger.debug("restoreVersion: virtual file system returned a non-document node (i.e. a directory)");
            }
            document = null;
        }
        if (document == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("restoreVersion: document not found. filename=" + fileName);
            }
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return false;
        }
        boolean result = this.restoreVersion(userData, document, fileVersion);
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
        return result;
    }

    public boolean restoreVersion(UserData userData, VFSDocumentNode document, String fileVersion) throws AuthenticationRequiredException {
        return false;
    }
}

