/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.alfresco.officeservices.AbstractWebsService;
import org.alfresco.officeservices.ServiceLogger;
import org.alfresco.officeservices.protocol.SimpleSoapParser;

public abstract class StandardWebsService
extends AbstractWebsService {
    private static final long serialVersionUID = -2155067930720095351L;
    private static final ServiceLogger logger = new ServiceLogger(StandardWebsService.class);

    public abstract List<String> getServicePrefixes(SimpleSoapParser var1, HttpServletRequest var2);

    @Override
    public String getWebUrlFromPageUrlResult(String pageurl, SimpleSoapParser parser, HttpServletRequest request) {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getWebUrlFromPageUrlResult: pageurl=" + pageurl);
        }
        Object hostprefix = "";
        if (pageurl.substring(0, 7).equalsIgnoreCase("http://")) {
            if (logger.isDebugEnabled()) {
                logger.debug("getWebUrlFromPageUrlResult: pageurl starts with \"http://\"");
            }
            if ((delimpos = (pageurl = pageurl.substring(7)).indexOf(47)) >= 0) {
                hostprefix = "http://" + pageurl.substring(0, delimpos);
                pageurl = pageurl.substring(delimpos);
            } else {
                hostprefix = "http://" + pageurl;
                pageurl = "";
            }
            if (logger.isDebugEnabled()) {
                logger.debug("getWebUrlFromPageUrlResult: hostprefix=" + (String)hostprefix);
                logger.debug("getWebUrlFromPageUrlResult: cleanedPageurl=" + pageurl);
            }
        } else if (pageurl.substring(0, 8).equalsIgnoreCase("https://")) {
            if (logger.isDebugEnabled()) {
                logger.debug("getWebUrlFromPageUrlResult: pageurl starts with \"https://\"");
            }
            if ((delimpos = (pageurl = pageurl.substring(8)).indexOf(47)) >= 0) {
                hostprefix = "https://" + pageurl.substring(0, delimpos);
                pageurl = pageurl.substring(delimpos);
            } else {
                hostprefix = "https://" + pageurl;
                pageurl = "";
            }
            if (logger.isDebugEnabled()) {
                logger.debug("getWebUrlFromPageUrlResult: hostprefix=" + (String)hostprefix);
                logger.debug("getWebUrlFromPageUrlResult: cleanedPageurl=" + pageurl);
            }
        }
        List<String> servicePrefixes = this.getServicePrefixes(parser, request);
        for (String testServicePrefix : servicePrefixes) {
            if (logger.isDebugEnabled()) {
                logger.debug("getWebUrlFromPageUrlResult: testing site prefix '" + testServicePrefix + "'");
            }
            if (testServicePrefix.equals(pageurl)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("getWebUrlFromPageUrlResult: found correct webUrl " + (String)hostprefix + testServicePrefix);
                }
                if (logger.isTraceEnabled()) {
                    logger.traceExit();
                }
                return (String)hostprefix + testServicePrefix;
            }
            if (pageurl.length() < testServicePrefix.length() + 1 || !pageurl.startsWith(testServicePrefix + "/")) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("getWebUrlFromPageUrlResult: found correct webUrl " + (String)hostprefix + testServicePrefix);
            }
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return (String)hostprefix + testServicePrefix;
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
        return null;
    }
}

