/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.datamodel;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.alfresco.officeservices.datamodel.FieldDefinition;
import org.alfresco.officeservices.datamodel.OLEValueFormatterParser;
import org.alfresco.officeservices.datamodel.ValueFormatterParser;

public class XMLValueFormatterParser
implements ValueFormatterParser {
    private static OLEValueFormatterParser singleton = new OLEValueFormatterParser();

    public static OLEValueFormatterParser getInstance() {
        return singleton;
    }

    @Override
    public String format(FieldDefinition fieldDef, Object value) {
        if (value == null) {
            return null;
        }
        switch (fieldDef.getFieldType()) {
            case TEXT: 
            case NOTE: 
            case CHOICE: {
                return (String)value;
            }
            case DATE_TIME: {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                return dateFormat.format((Date)value);
            }
            case BOOLEAN: {
                return (Boolean)value != false ? "true" : "false";
            }
            case NUMBER: {
                StringBuffer result = new StringBuffer();
                DecimalFormat decimalFormat = new DecimalFormat("#.#", new DecimalFormatSymbols(Locale.ENGLISH));
                decimalFormat.setGroupingUsed(false);
                decimalFormat.setMinimumIntegerDigits(1);
                decimalFormat.setMinimumFractionDigits(0);
                decimalFormat.setMaximumFractionDigits(fieldDef.getDecimals());
                decimalFormat.format((Number)value, result, new FieldPosition(1));
                return result.toString();
            }
        }
        throw new IllegalStateException("Unknown FieldType");
    }

    @Override
    public Object parse(String strValue) throws ParseException {
        return null;
    }
}

