/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.dws;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import org.alfresco.officeservices.AbstractSoapService;
import org.alfresco.officeservices.ServiceLogger;
import org.alfresco.officeservices.URLPathDecoder;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.dws.DwsDocumentItem;
import org.alfresco.officeservices.dws.DwsLinkItem;
import org.alfresco.officeservices.dws.DwsRoleInfo;
import org.alfresco.officeservices.dws.DwsTaskItem;
import org.alfresco.officeservices.dws.DwsUpdateBatchMethod;
import org.alfresco.officeservices.dws.DwsUpdateBatchRequest;
import org.alfresco.officeservices.dws.DwsUserInfo;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.protocol.HtmlEncoder;
import org.alfresco.officeservices.protocol.SimpleSoapParser;

public abstract class AbstractDwsService
extends AbstractSoapService {
    private static final long serialVersionUID = -6631378769921144913L;
    private static final ServiceLogger logger = new ServiceLogger(AbstractDwsService.class);
    public static final String METHODNAME_GETDWSDATA = "GetDwsData";
    public static final String METHODNAME_GETDWSMETADATA = "GetDwsMetaData";
    public static final String METHODNAME_UPDATEDWSDATA = "UpdateDwsData";
    public static final String METHODNAME_CREATEFOLDER = "CreateFolder";
    public static final String METHODPARAMETER_DOCUMENT = "document";
    public static final String METHODPARAMETER_LASTUPDATE = "lastupdate";
    public static final String METHODPARAMETER_ID = "id";
    public static final String METHODPARAMETER_MINIMAL = "minimal";
    public static final String METHODPARAMETER_UPDATES = "updates";

    public abstract String getUserInfoUrl(String var1, String var2, String var3);

    public abstract String getPermsUrl(String var1, String var2, String var3);

    public abstract String getSettingUrl(String var1, String var2, String var3);

    public abstract String getSubscribeUrl(String var1, String var2, String var3);

    protected abstract DwsUserInfo getUserInfo(UserData var1);

    protected abstract List<DwsRoleInfo> getRoles(UserData var1, String var2, String var3);

    protected abstract List<DwsUserInfo> getUsers(UserData var1, String var2, String var3);

    protected abstract String[] getTaskPriorities(UserData var1, String var2, String var3);

    protected abstract String[] getTaskStatuses(UserData var1, String var2, String var3);

    protected abstract List<DwsTaskItem> getTaskItems(UserData var1, String var2, String var3, String var4);

    protected abstract String getDocumentsItemsBaseFolder(UserData var1, String var2, String var3, String var4);

    protected abstract List<DwsDocumentItem> getDocumentItems(UserData var1, String var2, String var3, String var4);

    protected abstract List<DwsLinkItem> getLinksItems(UserData var1, String var2, String var3, String var4);

    protected abstract boolean canCreateTaskItem(UserData var1);

    protected abstract boolean canUpdateTaskItem(UserData var1);

    protected abstract boolean canDeleteTaskItem(UserData var1);

    protected abstract boolean canCreateLinkItem(UserData var1);

    protected abstract boolean canUpdateLinkItem(UserData var1);

    protected abstract boolean canDeleteLinkItem(UserData var1);

    protected abstract DwsTaskItem createTaskItem(String var1, String var2, String var3, String var4, String var5, Date var6);

    protected abstract DwsTaskItem updateTaskItem(String var1, String var2, String var3, String var4, String var5, String var6, Date var7);

    protected abstract boolean deleteTaskItem(String var1);

    protected abstract DwsLinkItem createLinkItem(String var1, String var2);

    protected abstract DwsLinkItem updateLinkItem(String var1, String var2, String var3);

    protected abstract boolean deleteLinkItem(String var1);

    @Override
    public void soapService(UserData userData, String methodName, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (methodName.equals(METHODNAME_GETDWSDATA)) {
            this.handleGetDwsData(userData, parser, request, response);
        } else if (methodName.equals(METHODNAME_GETDWSMETADATA)) {
            this.handleGetDwsMetaData(userData, parser, request, response);
        } else if (methodName.equals(METHODNAME_UPDATEDWSDATA)) {
            this.handleUpdateDwsData(userData, parser, request, response);
        } else if (methodName.equals(METHODNAME_CREATEFOLDER)) {
            this.handleCreateFolder(userData, parser, request, response);
        } else {
            logger.error("soapService: unknown RPC methodname " + methodName);
            SimpleSoapParser.soapErrorResponse(response, "Unknown methodname.");
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected String getSitePrefix(HttpServletRequest request) {
        String protocol = request.isSecure() ? "https://" : "http://";
        int defaultPort = request.isSecure() ? 443 : 80;
        String portString = request.getLocalPort() != defaultPort ? ":" + Integer.toString(request.getLocalPort()) : "";
        return protocol + request.getServerName() + portString + request.getContextPath();
    }

    protected void handleGetDwsData(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        String document;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((document = URLPathDecoder.decode(parser.getParameter(METHODPARAMETER_DOCUMENT), "UTF8")) == null) {
            logger.error("handleGetDwsData: Parameter \"document\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter document");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        String lastupdate = parser.getParameter(METHODPARAMETER_LASTUPDATE);
        if (lastupdate == null) {
            logger.error("handleGetDwsData: Parameter \"lastupdate\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter lastupdate");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("handleGetDwsData: Parameter document=" + document);
            logger.debug("handleGetDwsData: Parameter lastupdate=" + lastupdate);
        }
        String baseUrl = this.getSitePrefix(request);
        if (logger.isDebugEnabled()) {
            logger.debug("handleGetDwsData: baseUrl=" + baseUrl);
        }
        if (document.substring(0, baseUrl.length()).equalsIgnoreCase(baseUrl) && (document = document.substring(baseUrl.length())).length() > 1 && document.charAt(0) == '/') {
            document = document.substring(1);
        }
        StringBuffer payload = new StringBuffer();
        this.createGetDwsDataPayload(payload, userData, baseUrl, document, lastupdate);
        ServletOutputStream out = response.getOutputStream();
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<GetDwsDataResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/dws/\">");
        out.print("<GetDwsDataResult>");
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
        }
        catch (UnsupportedEncodingException use) {
            logger.error("UTF-8 character encoding is not available on this platform.", use);
            osw = new OutputStreamWriter((OutputStream)out);
        }
        HtmlEncoder.writeEncoded(osw, payload);
        osw.flush();
        out.print("</GetDwsDataResult>");
        out.print("</GetDwsDataResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected void handleGetDwsMetaData(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        String document;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((document = URLPathDecoder.decode(parser.getParameter(METHODPARAMETER_DOCUMENT), "UTF8")) == null) {
            logger.error("handleGetDwsMetaData: Parameter \"document\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter document");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        String id = parser.getParameter(METHODPARAMETER_ID);
        if (id == null) {
            logger.error("handleGetDwsMetaData: Parameter \"id\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter id");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        String minimal = parser.getParameter(METHODPARAMETER_MINIMAL);
        if (minimal == null) {
            logger.error("handleGetDwsMetaData: Parameter \"minimal\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter minimal");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        boolean bMinimal = minimal.equalsIgnoreCase("true");
        if (logger.isDebugEnabled()) {
            logger.debug("handleGetDwsMetaData: Parameter document=" + document);
            logger.debug("handleGetDwsMetaData: Parameter id=" + id);
            logger.debug("handleGetDwsMetaData: Parameter minimal=" + minimal);
        }
        String baseUrl = this.getSitePrefix(request);
        if (logger.isDebugEnabled()) {
            logger.debug("handleGetDwsMetaData: baseUrl=" + baseUrl);
        }
        if (document.substring(0, baseUrl.length()).equalsIgnoreCase(baseUrl) && (document = document.substring(baseUrl.length())).length() > 1 && document.charAt(0) == '/') {
            document = document.substring(1);
        }
        StringBuffer payload = new StringBuffer();
        this.createGetDwsMetaDataPayload(payload, userData, baseUrl, document, id, bMinimal);
        ServletOutputStream out = response.getOutputStream();
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<GetDwsMetaDataResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/dws/\">");
        out.print("<GetDwsMetaDataResult>");
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
        }
        catch (UnsupportedEncodingException use) {
            logger.error("UTF-8 character encoding is not available on this platform.", use);
            osw = new OutputStreamWriter((OutputStream)out);
        }
        HtmlEncoder.writeEncoded(osw, payload);
        osw.flush();
        out.print("</GetDwsMetaDataResult>");
        out.print("</GetDwsMetaDataResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected void handleUpdateDwsData(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        String updates;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((updates = parser.getParameter(METHODPARAMETER_UPDATES)) == null) {
            logger.error("handleUpdateDwsData: Parameter \"updates\" missing.");
            SimpleSoapParser.soapErrorResponse(response, "Missing parameter updates");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("handleUpdateDwsData: Parameter updates=" + updates);
        }
        DwsUpdateBatchRequest batch = null;
        try {
            batch = new DwsUpdateBatchRequest(updates);
        }
        catch (Exception e) {
            logger.error("handleUpdateDwsData: Parameter \"updates\" malformed.", e);
            SimpleSoapParser.soapErrorResponse(response, "Malformed parameter updates");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        StringBuffer payload = new StringBuffer();
        payload.append("<Results>");
        for (int i = 0; i < batch.size(); ++i) {
            DwsUpdateBatchMethod method = batch.getMethod(i);
            this.performBatchMethod(payload, method);
        }
        payload.append("</Results>");
        ServletOutputStream out = response.getOutputStream();
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<UpdateDwsDataResponse xmlns=\"http://schemas.microsoft.com/sharepoint/soap/dws/\">");
        out.print("<UpdateDwsDataResult>");
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
        }
        catch (UnsupportedEncodingException use) {
            logger.error("UTF-8 character encoding is not available on this platform.", use);
            osw = new OutputStreamWriter((OutputStream)out);
        }
        HtmlEncoder.writeEncoded(osw, payload);
        osw.flush();
        out.print("</UpdateDwsDataResult>");
        out.print("</UpdateDwsDataResponse>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected void performBatchMethod(StringBuffer payload, DwsUpdateBatchMethod method) {
        int updatelist = -1;
        if (method.getList().equals(this.getTasksGUID())) {
            updatelist = 0;
        } else if (method.getList().equals(this.getLinksGUID())) {
            updatelist = 1;
        }
        if (updatelist < 0) {
            payload.append("<Result ID=\"");
            payload.append(method.getID());
            payload.append("\" Code=\"-1\"><Error ID=\"5\">Error</Error></Result>");
            return;
        }
        String cmd = method.getVar("Cmd");
        int command = -1;
        if (cmd != null) {
            if (cmd.equalsIgnoreCase("save")) {
                command = 0;
            } else if (cmd.equalsIgnoreCase("delete")) {
                command = 1;
            }
        }
        if (command < 0) {
            payload.append("<Result ID=\"");
            payload.append(method.getID());
            payload.append("\" Code=\"-1\"><Error ID=\"5\">Error</Error></Result>");
            return;
        }
        String id = method.getVar(METHODPARAMETER_ID);
        block0 : switch (command) {
            case 0: {
                if (id != null) {
                    switch (updatelist) {
                        case 0: {
                            DwsTaskItem saveTasksResult;
                            String title = method.getVar("urn:schemas-microsoft-com:office:office#title");
                            String assignedTo = method.getVar("urn:schemas-microsoft-com:office:office#assignedto");
                            String status = method.getVar("urn:schemas-microsoft-com:office:office#status");
                            String priority = method.getVar("urn:schemas-microsoft-com:office:office#priority");
                            String body = method.getVar("urn:schemas-microsoft-com:office:office#body");
                            String duedate = method.getVar("urn:schemas-microsoft-com:office:office#duedate");
                            DwsTaskItem dwsTaskItem = saveTasksResult = id.equalsIgnoreCase("new") ? this.createTaskItem(title, assignedTo, status, priority, body, AbstractDwsService.parseDate(duedate)) : this.updateTaskItem(id, title, assignedTo, status, priority, body, AbstractDwsService.parseDate(duedate));
                            if (saveTasksResult == null) {
                                payload.append("<Result ID=\"");
                                payload.append(method.getID());
                                payload.append("\" Code=\"-1\"><Error ID=\"5\">Error</Error></Result>");
                                break block0;
                            }
                            payload.append("<Result ID=\"");
                            payload.append(method.getID());
                            payload.append("\" Code=\"0\">");
                            this.appendTasksItemToPayload(payload, saveTasksResult);
                            payload.append("</Result>");
                            break block0;
                        }
                        case 1: {
                            DwsLinkItem saveLinksResult;
                            String rawUrl = method.getVar("urn:schemas-microsoft-com:office:office#url");
                            String url = null;
                            String comments = null;
                            if (rawUrl != null) {
                                int delimPos = rawUrl.indexOf(44);
                                url = delimPos < 0 ? rawUrl : rawUrl.substring(0, delimPos);
                                comments = delimPos < 0 ? "" : rawUrl.substring(delimPos + 1);
                            }
                            DwsLinkItem dwsLinkItem = saveLinksResult = id.equalsIgnoreCase("new") ? this.createLinkItem(url, comments) : this.updateLinkItem(id, url, comments);
                            if (saveLinksResult == null) {
                                payload.append("<Result ID=\"");
                                payload.append(method.getID());
                                payload.append("\" Code=\"-1\"><Error ID=\"5\">Error</Error></Result>");
                                break block0;
                            }
                            payload.append("<Result ID=\"");
                            payload.append(method.getID());
                            payload.append("\" Code=\"0\">");
                            this.appendLinksItemToPayload(payload, saveLinksResult);
                            payload.append("</Result>");
                            break block0;
                        }
                    }
                    payload.append("<Result ID=\"");
                    payload.append(method.getID());
                    payload.append("\" Code=\"-1\"><Error ID=\"5\">Error</Error></Result>");
                    break;
                }
                payload.append("<Result ID=\"");
                payload.append(method.getID());
                payload.append("\" Code=\"-1\"><Error ID=\"5\">Error</Error></Result>");
                break;
            }
            case 1: {
                boolean deleteResult = false;
                if (id != null) {
                    switch (updatelist) {
                        case 0: {
                            deleteResult = this.deleteTaskItem(id);
                            break;
                        }
                        case 1: {
                            deleteResult = this.deleteLinkItem(id);
                            break;
                        }
                        default: {
                            deleteResult = false;
                        }
                    }
                }
                if (deleteResult) {
                    payload.append("<Result ID=\"");
                    payload.append(method.getID());
                    payload.append("\" Code=\"0\" List=\"");
                    payload.append(method.getList());
                    payload.append("\" Version=\"0\"></Result>");
                    break;
                }
                payload.append("<Result ID=\"");
                payload.append(method.getID());
                payload.append("\" Code=\"-1\"><Error ID=\"5\">Error</Error></Result>");
            }
        }
    }

    protected void handleCreateFolder(UserData userData, SimpleSoapParser parser, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        SimpleSoapParser.soapErrorResponse(response, "Folder creation is not supported for now.");
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected void createGetDwsDataPayload(StringBuffer payload, UserData userData, String baseUrl, String document, String lastupdate) {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        payload.append("<Results>");
        payload.append("<Title />");
        payload.append("<LastUpdate>00000000000000</LastUpdate>");
        payload.append("<User>");
        this.createDetails_User(payload, this.getUserInfo(userData), baseUrl, document, lastupdate);
        payload.append("</User>");
        List<DwsUserInfo> users = this.getUsers(userData, baseUrl, document);
        payload.append("<Members>");
        if (users != null) {
            for (DwsUserInfo userInfo : users) {
                payload.append("<Member>");
                payload.append("<ID>");
                HtmlEncoder.appendEncoded(payload, userInfo.getId());
                payload.append("</ID>");
                payload.append("<Name>");
                HtmlEncoder.appendEncoded(payload, userInfo.getFullName());
                payload.append("</Name>");
                payload.append("<LoginName>");
                if (userInfo.getUserDomain() != null) {
                    HtmlEncoder.appendEncoded(payload, userInfo.getUserDomain());
                    payload.append("\\");
                }
                HtmlEncoder.appendEncoded(payload, userInfo.getUserName());
                payload.append("</LoginName>");
                payload.append("<Email>");
                HtmlEncoder.appendEncoded(payload, userInfo.getEMail());
                payload.append("</Email>");
                payload.append("<IsDomainGroup>");
                payload.append(userInfo.isDomainGroup() ? "True" : "False");
                payload.append("</IsDomainGroup>");
                payload.append("</Member>");
            }
        }
        payload.append("</Members>");
        payload.append("<Assignees>");
        if (users != null) {
            for (DwsUserInfo userInfo : users) {
                payload.append("<Member>");
                payload.append("<ID>");
                HtmlEncoder.appendEncoded(payload, userInfo.getId());
                payload.append("</ID>");
                payload.append("<Name>");
                HtmlEncoder.appendEncoded(payload, userInfo.getFullName());
                payload.append("</Name>");
                payload.append("<LoginName>");
                if (userInfo.getUserDomain() != null) {
                    HtmlEncoder.appendEncoded(payload, userInfo.getUserDomain());
                    payload.append("\\");
                }
                HtmlEncoder.appendEncoded(payload, userInfo.getUserName());
                payload.append("</LoginName>");
                payload.append("</Member>");
            }
        }
        payload.append("</Assignees>");
        this.createListsPayload(payload, userData, baseUrl, document, lastupdate);
        payload.append("</Results>");
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected void createListsPayload(StringBuffer payload, UserData userData, String baseUrl, String document, String lastupdate) {
        List<DwsTaskItem> tasks = this.getTaskItems(userData, baseUrl, document, lastupdate);
        List<DwsDocumentItem> documents = this.getDocumentItems(userData, baseUrl, document, lastupdate);
        List<DwsLinkItem> links = this.getLinksItems(userData, baseUrl, document, lastupdate);
        if (tasks == null && documents == null && links == null) {
            payload.append("<List Name=\"Tasks\">");
            payload.append("</List>");
            payload.append("<List Name=\"Documents\">");
            payload.append("</List>");
            payload.append("<List Name=\"Links\">");
            payload.append("</List>");
        } else {
            payload.append("<List Name=\"Tasks\">");
            payload.append("<ID>" + this.getTasksGUID() + "</ID>");
            if (tasks != null) {
                for (DwsTaskItem task : tasks) {
                    this.appendTasksItemToPayload(payload, task);
                }
            }
            payload.append("</List>");
            payload.append("<List Name=\"Documents\">");
            payload.append("<ID>" + this.getDocumentsGUID() + "</ID>");
            if (documents != null) {
                for (DwsDocumentItem fileorfolder : documents) {
                    if (fileorfolder.isFile()) {
                        payload.append("<z:row");
                        this.appendRowAttribute(payload, "ows_FileRef", fileorfolder.getBaseRelativePath(), false);
                        this.appendRowAttribute(payload, "ows_Title", "", false);
                        this.appendRowAttribute(payload, "ows_FSObjType", "0", false);
                        this.appendRowAttribute(payload, "ows_Created", AbstractDwsService.formatDate(fileorfolder.getCreatedOn()), false);
                        this.appendRowAttribute(payload, "ows_Author", fileorfolder.getAuthorUserID() + ";#" + fileorfolder.getAuthorUserName(), false);
                        this.appendRowAttribute(payload, "ows_Modified", AbstractDwsService.formatDate(fileorfolder.getModifiedOn()), false);
                        this.appendRowAttribute(payload, "ows_Editor", fileorfolder.getEditorUserID() + ";#" + fileorfolder.getEditorUserName(), false);
                        this.appendRowAttribute(payload, "ows_ID", fileorfolder.getID(), false);
                        this.appendRowAttribute(payload, "ows_ProgID", "", false);
                        payload.append(" xmlns:z=\"#RowsetSchema\" />");
                        continue;
                    }
                    payload.append("<z:row");
                    this.appendRowAttribute(payload, "ows_FileRef", fileorfolder.getBaseRelativePath(), false);
                    this.appendRowAttribute(payload, "ows_FSObjType", "1", false);
                    payload.append(" xmlns:z=\"#RowsetSchema\" />");
                }
            }
            payload.append("</List>");
            payload.append("<List Name=\"Links\">");
            payload.append("<ID>" + this.getLinksGUID() + "</ID>");
            if (links != null) {
                for (DwsLinkItem link : links) {
                    this.appendLinksItemToPayload(payload, link);
                }
            }
            payload.append("</List>");
        }
    }

    protected void appendTasksItemToPayload(StringBuffer payload, DwsTaskItem task) {
        payload.append("<z:row");
        this.appendRowAttribute(payload, "ows_Title", task.getTitle(), false);
        this.appendRowAttribute(payload, "ows_AssignedTo", task.getAssignedToUserID() + ";#" + task.getAssignedToUserName(), false);
        this.appendRowAttribute(payload, "ows_Status", task.getStatus(), false);
        this.appendRowAttribute(payload, "ows_Priority", task.getPriority(), false);
        this.appendRowAttribute(payload, "ows_Body", task.getBody(), true);
        if (task.getDueDateUTC() != null) {
            this.appendRowAttribute(payload, "ows_DueDate", AbstractDwsService.formatDate(task.getDueDateUTC()), false);
        }
        this.appendRowAttribute(payload, "ows_Created", AbstractDwsService.formatDate(task.getCreatedOnUTC()), false);
        this.appendRowAttribute(payload, "ows_Author", task.getAuthorUserID() + ";#" + task.getAuthorUserName(), false);
        this.appendRowAttribute(payload, "ows_Modified", AbstractDwsService.formatDate(task.getModifiedOnUTC()), false);
        this.appendRowAttribute(payload, "ows_Editor", task.getEditorUserID() + ";#" + task.getEditorUserName(), false);
        this.appendRowAttribute(payload, "ows_owshiddenversion", Integer.toString(task.getItemVersion()), false);
        this.appendRowAttribute(payload, "ows_ID", task.getID(), false);
        payload.append(" xmlns:z=\"#RowsetSchema\" />");
    }

    protected void appendLinksItemToPayload(StringBuffer payload, DwsLinkItem link) {
        payload.append("<z:row");
        this.appendRowAttribute(payload, "ows_URL", link.getUrl() + ", " + link.getTitle(), false);
        this.appendRowAttribute(payload, "ows_Comments", link.getComments(), true);
        this.appendRowAttribute(payload, "ows_Created", AbstractDwsService.formatDate(link.getCreatedOnUTC()), false);
        this.appendRowAttribute(payload, "ows_Author", link.getAuthorUserID() + ";#" + link.getAuthorUserName(), false);
        this.appendRowAttribute(payload, "ows_Modified", AbstractDwsService.formatDate(link.getModifiedOnUTC()), false);
        this.appendRowAttribute(payload, "ows_Editor", link.getEditorUserID() + ";#" + link.getEditorUserName(), false);
        this.appendRowAttribute(payload, "ows_owshiddenversion", Integer.toString(link.getItemVersion()), false);
        this.appendRowAttribute(payload, "ows_ID", link.getID(), false);
        payload.append(" xmlns:z=\"#RowsetSchema\" />");
    }

    protected void appendRowAttribute(StringBuffer payload, String attributeName, String attributeValue, boolean canContainLinebreaks) {
        payload.append(" ");
        payload.append(attributeName);
        payload.append("=\"");
        HtmlEncoder.appendEncoded(payload, attributeValue, canContainLinebreaks);
        payload.append("\"");
    }

    protected void createGetDwsMetaDataPayload(StringBuffer payload, UserData userData, String baseUrl, String document, String id, boolean minimal) {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        payload.append("<Results>");
        if (!minimal) {
            payload.append("<SubscribeUrl>" + this.getSubscribeUrl(baseUrl, document, id) + "</SubscribeUrl>");
        }
        payload.append("<MtgInstance />");
        payload.append("<SettingUrl>" + this.getSettingUrl(baseUrl, document, id) + "</SettingUrl>");
        payload.append("<PermsUrl>" + this.getPermsUrl(baseUrl, document, id) + "</PermsUrl>");
        payload.append("<UserInfoUrl>" + this.getUserInfoUrl(baseUrl, document, id) + "</UserInfoUrl>");
        payload.append("<Roles>");
        List<DwsRoleInfo> roles = this.getRoles(userData, baseUrl, document);
        if (roles != null) {
            for (DwsRoleInfo roleInfo : roles) {
                payload.append("<Role Name=\"");
                HtmlEncoder.appendEncoded(payload, roleInfo.getName());
                payload.append("\" Type=\"");
                HtmlEncoder.appendEncoded(payload, roleInfo.getType());
                payload.append("\" Description=\"");
                HtmlEncoder.appendEncoded(payload, roleInfo.getDescription());
                payload.append("\" />");
            }
        }
        payload.append("</Roles>");
        if (!minimal) {
            payload.append("<Schema Name=\"Tasks\">");
            payload.append("<Field Name=\"Title\" Type=\"Text\" Required=\"True\"><Choices /></Field>");
            payload.append("<Field Name=\"Attachments\" Type=\"Attachments\" Required=\"False\"><Choices /></Field>");
            payload.append("<Field Name=\"Order\" Type=\"Number\" Required=\"False\"><Choices /></Field>");
            payload.append("<Field Name=\"Priority\" Type=\"Choice\" Required=\"False\">");
            payload.append("<Choices>");
            String[] priorities = this.getTaskPriorities(userData, baseUrl, document);
            if (priorities != null) {
                for (int i = 0; i < priorities.length; ++i) {
                    payload.append("<Choice>");
                    HtmlEncoder.appendEncoded(payload, priorities[i]);
                    payload.append("</Choice>");
                }
            }
            payload.append("</Choices>");
            payload.append("</Field>");
            payload.append("<Field Name=\"Status\" Type=\"Choice\" Required=\"False\">");
            payload.append("<Choices>");
            String[] statuses = this.getTaskStatuses(userData, baseUrl, document);
            if (statuses != null) {
                for (int i = 0; i < statuses.length; ++i) {
                    payload.append("<Choice>");
                    HtmlEncoder.appendEncoded(payload, statuses[i]);
                    payload.append("</Choice>");
                }
            }
            payload.append("</Choices>");
            payload.append("</Field>");
            payload.append("<Field Name=\"PercentComplete\" Type=\"Number\" Required=\"False\"><Choices /></Field>");
            payload.append("<Field Name=\"AssignedTo\" Type=\"User\" Required=\"False\"><Choices /></Field>");
            payload.append("<Field Name=\"Body\" Type=\"Note\" Required=\"False\"><Choices /></Field>");
            payload.append("<Field Name=\"StartDate\" Type=\"DateTime\" Required=\"False\"><Choices /></Field>");
            payload.append("<Field Name=\"DueDate\" Type=\"DateTime\" Required=\"False\"><Choices /></Field>");
            payload.append("</Schema>");
            payload.append("<Schema Name=\"Documents\" Url=\"");
            HtmlEncoder.appendEncoded(payload, this.getDocumentsItemsBaseFolder(userData, baseUrl, document, null));
            payload.append("\">");
            payload.append("<Field Name=\"FileLeafRef\" Type=\"Invalid\" Required=\"True\"><Choices /></Field>");
            payload.append("<Field Name=\"_SourceUrl\" Type=\"Text\" Required=\"False\"><Choices /></Field>");
            payload.append("<Field Name=\"_SharedFileIndex\" Type=\"Text\" Required=\"False\"><Choices /></Field>");
            payload.append("<Field Name=\"Order\" Type=\"Number\" Required=\"False\"><Choices /></Field>");
            payload.append("<Field Name=\"Title\" Type=\"Text\" Required=\"False\"><Choices /></Field>");
            payload.append("</Schema>");
            payload.append("<Schema Name=\"Links\">");
            payload.append("<Field Name=\"Attachments\" Type=\"Attachments\" Required=\"False\"><Choices /></Field>");
            payload.append("<Field Name=\"Order\" Type=\"Number\" Required=\"False\"><Choices /></Field>");
            payload.append("<Field Name=\"URL\" Type=\"URL\" Required=\"True\"><Choices /></Field>");
            payload.append("<Field Name=\"Comments\" Type=\"Note\" Required=\"False\"><Choices /></Field>");
            payload.append("</Schema>");
            payload.append("<ListInfo Name=\"Tasks\">");
            payload.append("<Moderated>False</Moderated>");
            payload.append("<ListPermissions>");
            if (this.canCreateTaskItem(userData)) {
                payload.append("<InsertListItems />");
            }
            if (this.canUpdateTaskItem(userData)) {
                payload.append("<EditListItems />");
            }
            if (this.canDeleteTaskItem(userData)) {
                payload.append("<DeleteListItems />");
            }
            payload.append("</ListPermissions>");
            payload.append("</ListInfo>");
            payload.append("<ListInfo Name=\"Documents\">");
            payload.append("<Moderated>False</Moderated>");
            payload.append("<ListPermissions>");
            payload.append("<EditListItems />");
            payload.append("</ListPermissions>");
            payload.append("</ListInfo>");
            payload.append("<ListInfo Name=\"Links\">");
            payload.append("<Moderated>False</Moderated>");
            payload.append("<ListPermissions>");
            if (this.canCreateLinkItem(userData)) {
                payload.append("<InsertListItems />");
            }
            if (this.canUpdateLinkItem(userData)) {
                payload.append("<EditListItems />");
            }
            if (this.canDeleteLinkItem(userData)) {
                payload.append("<DeleteListItems />");
            }
            payload.append("</ListPermissions>");
            payload.append("</ListInfo>");
        }
        payload.append("<Permissions>");
        if (this.canManageSubwebs(userData)) {
            payload.append("<ManageSubwebs />");
        }
        if (this.canManageWeb(userData)) {
            payload.append("<ManageWeb />");
        }
        if (this.canManageRoles(userData)) {
            payload.append("<ManageRoles />");
        }
        if (this.canManageLists(userData)) {
            payload.append("<ManageLists />");
        }
        if (this.canInsertListItems(userData)) {
            payload.append("<InsertListItems />");
        }
        if (this.canEditListItems(userData)) {
            payload.append("<EditListItems />");
        }
        if (this.canDeleteListItems(userData)) {
            payload.append("<DeleteListItems />");
        }
        payload.append("</Permissions>");
        payload.append("<HasUniquePerm>True</HasUniquePerm>");
        payload.append("<WorkspaceType />");
        payload.append("<IsADMode>False</IsADMode>");
        payload.append("<DocUrl>" + HtmlEncoder.encode(document) + "</DocUrl>");
        payload.append("<Minimal>" + (minimal ? "True" : "False") + "</Minimal>");
        if (minimal) {
            payload.append("<Results>");
            payload.append("<Title />");
            payload.append("<LastUpdate>00000000000000</LastUpdate>");
            payload.append("<User>");
            this.createDetails_User(payload, this.getUserInfo(userData), baseUrl, document, null);
            payload.append("</User>");
            List<DwsUserInfo> users = this.getUsers(userData, baseUrl, document);
            payload.append("<Members>");
            if (users != null) {
                for (DwsUserInfo userInfo : users) {
                    payload.append("<Member>");
                    payload.append("<ID>");
                    HtmlEncoder.appendEncoded(payload, userInfo.getId());
                    payload.append("</ID>");
                    payload.append("<Name>");
                    HtmlEncoder.appendEncoded(payload, userInfo.getFullName());
                    payload.append("</Name>");
                    payload.append("<LoginName>");
                    if (userInfo.getUserDomain() != null) {
                        HtmlEncoder.appendEncoded(payload, userInfo.getUserDomain());
                        payload.append("\\");
                    }
                    HtmlEncoder.appendEncoded(payload, userInfo.getUserName());
                    payload.append("</LoginName>");
                    payload.append("<Email>");
                    HtmlEncoder.appendEncoded(payload, userInfo.getEMail());
                    payload.append("</Email>");
                    payload.append("<IsDomainGroup>");
                    payload.append(userInfo.isDomainGroup() ? "True" : "False");
                    payload.append("</IsDomainGroup>");
                    payload.append("</Member>");
                }
            }
            payload.append("</Members>");
            payload.append("</Results>");
        } else {
            this.createGetDwsDataPayload(payload, userData, baseUrl, document, "");
        }
        payload.append("</Results>");
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected abstract boolean canManageSubwebs(UserData var1);

    protected abstract boolean canManageWeb(UserData var1);

    protected abstract boolean canManageRoles(UserData var1);

    protected abstract boolean canManageLists(UserData var1);

    protected abstract boolean canInsertListItems(UserData var1);

    protected abstract boolean canEditListItems(UserData var1);

    protected abstract boolean canDeleteListItems(UserData var1);

    protected void createDetails_User(StringBuffer payload, DwsUserInfo userInfo, String baseUrl, String document, String lastupdate) {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("createDetails_User: username=" + userInfo.getUserName());
        }
        payload.append("<ID>");
        HtmlEncoder.appendEncoded(payload, userInfo.getId());
        payload.append("</ID>");
        payload.append("<Name>");
        HtmlEncoder.appendEncoded(payload, userInfo.getFullName());
        payload.append("</Name>");
        payload.append("<LoginName>");
        if (userInfo.getUserDomain() != null) {
            HtmlEncoder.appendEncoded(payload, userInfo.getUserDomain());
            payload.append("\\");
        }
        HtmlEncoder.appendEncoded(payload, userInfo.getUserName());
        payload.append("</LoginName>");
        payload.append("<Email>");
        HtmlEncoder.appendEncoded(payload, userInfo.getEMail());
        payload.append("</Email>");
        payload.append("<IsDomainGroup>False</IsDomainGroup>");
        payload.append("<IsSiteAdmin>False</IsSiteAdmin>");
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected String getLinksGUID() {
        return "{69F93292-F9E8-B79C-FDF9-02E8612FE901}";
    }

    protected String getDocumentsGUID() {
        return "{69F93292-F9E8-B79C-FDF9-02E8612FE902}";
    }

    protected String getTasksGUID() {
        return "{69F93292-F9E8-B79C-FDF9-02E8612FE903}";
    }
}

