/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.lists;

import java.io.IOException;
import java.io.PrintStream;
import org.alfresco.officeservices.AbstractSoapService;
import org.alfresco.officeservices.datamodel.ContentTypeDefinition;
import org.alfresco.officeservices.datamodel.CustomXsnDefinition;

public class ListsGetListContentTypesContentType {
    protected String id;
    protected String name;
    protected String description;
    protected boolean bestMatch;
    protected String scope;
    protected String version = "0";
    protected String customXsnLocation;
    protected boolean customXsnCached = false;
    protected boolean customXsnOpenByDefault = false;
    protected String customXsnScope;

    public ListsGetListContentTypesContentType(String id, String name, String description, String scope, boolean bestMatch) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.scope = scope;
        this.bestMatch = bestMatch;
    }

    public ListsGetListContentTypesContentType(ContentTypeDefinition contentType, boolean bestMatch, String scope) {
        this.id = contentType.getId().toString();
        this.name = contentType.getName();
        this.description = contentType.getDescription();
        this.bestMatch = bestMatch;
        this.scope = scope;
        this.version = contentType.getVersion();
        CustomXsnDefinition customXsn = contentType.getCustomXsn();
        if (customXsn != null) {
            this.customXsnLocation = customXsn.getXsnLocation();
            this.customXsnCached = customXsn.isCached();
            this.customXsnOpenByDefault = customXsn.isOpenByDefault();
            this.customXsnScope = customXsn.getXsnScope();
        }
    }

    public void setCustomXsn(String location, boolean cached, boolean openByDefault, String scope) {
        this.customXsnLocation = location;
        this.customXsnCached = cached;
        this.customXsnOpenByDefault = openByDefault;
        this.customXsnScope = scope;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void write(PrintStream out) throws IOException {
        out.print("<ContentType");
        AbstractSoapService.writeXmlAttribute(out, "Name", this.name, true);
        AbstractSoapService.writeXmlAttribute(out, "ID", this.id, true);
        AbstractSoapService.writeXmlAttribute(out, "Description", this.description, true);
        AbstractSoapService.writeXmlAttribute(out, "Scope", this.scope, true);
        AbstractSoapService.writeXmlAttribute(out, "Version", this.version, true);
        if (this.bestMatch) {
            AbstractSoapService.writeXmlAttribute(out, "BestMatch", "TRUE", true);
        }
        out.print(">");
        out.print("<XmlDocuments>");
        if (this.customXsnLocation != null) {
            out.print("<XmlDocument NamespaceURI=\"http://schemas.microsoft.com/office/2006/metadata/customXsn\">");
            out.print("<ntns:customXsn xmlns:ntns=\"http://schemas.microsoft.com/office/2006/metadata/customXsn\">");
            out.print("<ntns:xsnLocation>");
            AbstractSoapService.writeEncoded(out, this.customXsnLocation);
            out.print("</ntns:xsnLocation>");
            out.print("<ntns:cached>");
            out.print(this.customXsnCached ? "TRUE" : "FALSE");
            out.print("</ntns:cached>");
            out.print("<ntns:openByDefault>");
            out.print(this.customXsnOpenByDefault ? "TRUE" : "FALSE");
            out.print("</ntns:openByDefault>");
            out.print("<ntns:xsnScope>");
            AbstractSoapService.writeEncoded(out, this.customXsnScope);
            out.print("</ntns:xsnScope>");
            out.print("</ntns:customXsn>");
            out.print("</XmlDocument>");
        }
        out.print("<XmlDocument NamespaceURI=\"http://schemas.microsoft.com/sharepoint/v3/contenttype/forms\">");
        out.print("<FormTemplates xmlns=\"http://schemas.microsoft.com/sharepoint/v3/contenttype/forms\">");
        out.print("<Display>DocumentLibraryForm</Display>");
        out.print("<Edit>DocumentLibraryForm</Edit>");
        out.print("<New>DocumentLibraryForm</New>");
        out.print("</FormTemplates>");
        out.print("</XmlDocument>");
        out.print("</XmlDocuments>");
        out.print("</ContentType>");
    }
}

