/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.lists;

import java.io.IOException;
import java.io.PrintStream;
import org.alfresco.officeservices.AbstractSoapService;
import org.alfresco.officeservices.lists.ListItem;

public class UpdateListItemResult {
    protected String id;
    protected String method;
    protected String list;
    protected String version;
    protected int errorCode = 0;
    protected ListItem changedItem;
    public static final int ERRORCODE_SUCCESS = 0;
    public static final int ERRORCODE_GENERAL = 1;

    public UpdateListItemResult(String id, String method, String list, String version, ListItem changedItem) {
        this.id = id;
        this.method = method;
        this.list = list;
        this.version = version;
        this.changedItem = changedItem;
    }

    public UpdateListItemResult(String id, String method, String list, int errorCode) {
        this.id = id;
        this.method = method;
        this.list = list;
        this.errorCode = errorCode;
    }

    public void write(PrintStream out) throws IOException {
        out.print("<Result");
        AbstractSoapService.writeXmlAttribute(out, "ID", this.id + "," + this.method, true);
        AbstractSoapService.writeXmlAttribute(out, "List", this.list, true);
        if (this.version != null) {
            AbstractSoapService.writeXmlAttribute(out, "Version", this.version, true);
        }
        out.print(">");
        out.print("<ErrorCode>");
        out.print("0x");
        String errorCodeStr = Integer.toHexString(this.errorCode);
        int leadingZerosCount = errorCodeStr.length() < 8 ? 8 - errorCodeStr.length() : 0;
        for (int i = 0; i < leadingZerosCount; ++i) {
            out.print("0");
        }
        out.print(errorCodeStr);
        out.print("</ErrorCode>");
        if (this.errorCode == 0 && this.changedItem != null) {
            this.changedItem.write(out, true, true);
        }
        out.print("</Result>");
    }
}

