/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.protocol;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.alfresco.officeservices.protocol.DefaultEntityResolver;
import org.alfresco.officeservices.protocol.HtmlEncoder;
import org.alfresco.officeservices.protocol.SSPError;
import org.alfresco.officeservices.protocol.SoapParameter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SimpleSoapParser {
    private SSPError lastError = SSPError.NONE;
    private Document xmlDocument;
    private String methodName = "";
    private Map<String, SoapParameter> methodparams = new HashMap<String, SoapParameter>();

    public static void soapErrorResponse(HttpServletResponse response, String errormessage) throws IOException {
        response.setStatus(500);
        response.setContentType("text/xml");
        ServletOutputStream out = response.getOutputStream();
        out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        out.print("<soap:Body>");
        out.print("<soap:Fault>");
        out.print("<faultcode>soap:Server</faultcode>");
        out.print("<faultstring>");
        HtmlEncoder.writeEncoded(out, errormessage, "UTF-8");
        out.print("</faultstring>");
        out.print("<detail>");
        out.print("<errorstring xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">Internal failure.</errorstring>");
        out.print("<errorcode xmlns=\"http://schemas.microsoft.com/sharepoint/soap/\">0x00000001</errorcode>");
        out.print("</detail>");
        out.print("</soap:Fault>");
        out.print("</soap:Body>");
        out.print("</soap:Envelope>");
    }

    public SimpleSoapParser(InputStream inStream) throws IOException, ParserConfigurationException {
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            docBuilder.setEntityResolver(new DefaultEntityResolver());
            this.xmlDocument = docBuilder.parse(inStream);
            Element envelopeElement = this.xmlDocument.getDocumentElement();
            String nodeName = envelopeElement.getNodeName();
            Object ns = "";
            if (nodeName.indexOf(58) != -1) {
                ns = nodeName.substring(0, nodeName.indexOf(58)) + ":";
                nodeName = nodeName.substring(nodeName.indexOf(58) + 1);
            }
            if (nodeName.equals("Envelope")) {
                this.processSoapEnvelope(envelopeElement, (String)ns);
            } else {
                this.lastError = SSPError.NO_ENVELOPE;
            }
        }
        catch (SAXException e) {
            this.lastError = SSPError.XML_MALFORMED;
        }
    }

    public SSPError getLastError() {
        return this.lastError;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getParameter(String paramName) {
        SoapParameter sp = this.methodparams.get(paramName.toLowerCase());
        if (sp == null) {
            return null;
        }
        return sp.getValue();
    }

    public SoapParameter getSoapParameter(String paramName) {
        return this.methodparams.get(paramName.toLowerCase());
    }

    private void processSoapEnvelope(Element envelopeElement, String ns) {
        NodeList nlist = envelopeElement.getElementsByTagName(ns + "Body");
        if (nlist.getLength() <= 0) {
            this.lastError = SSPError.NO_BODY;
        } else {
            Element bodyElement = (Element)nlist.item(0);
            this.processSoapBody(bodyElement);
        }
    }

    private void processSoapBody(Element bodyElement) {
        NodeList nlist = bodyElement.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node bodySubnode = nlist.item(i);
            if (bodySubnode.getNodeType() != 1) continue;
            this.processSoapMethod((Element)bodySubnode);
            break;
        }
    }

    private void processSoapMethod(Element methodElement) {
        this.methodName = methodElement.getTagName();
        this.methodparams.clear();
        NodeList nlist = methodElement.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node methodSubnode = nlist.item(i);
            if (methodSubnode.getNodeType() != 1) continue;
            Element paramElement = (Element)methodSubnode;
            SoapParameter soapParameter = this.parseParameter(paramElement);
            this.methodparams.put(soapParameter.getName().toLowerCase(), soapParameter);
        }
    }

    protected SoapParameter parseParameter(Element paramElement) {
        String paramName = paramElement.getTagName();
        StringBuffer paramText = new StringBuffer();
        ArrayList<SoapParameter> subParameters = new ArrayList<SoapParameter>();
        NodeList pvlist = paramElement.getChildNodes();
        for (int ii = 0; ii < pvlist.getLength(); ++ii) {
            Node n = pvlist.item(ii);
            if (n.getNodeType() == 3 || n.getNodeType() == 4) {
                paramText.append(n.getNodeValue());
                continue;
            }
            if (n.getNodeType() == 1) {
                subParameters.add(this.parseParameter((Element)n));
                continue;
            }
            if (n.getNodeType() != 2) continue;
            subParameters.add(new SoapParameter(n.getNodeName(), n.getNodeValue()));
        }
        if (paramElement.hasAttributes()) {
            NamedNodeMap attrs = paramElement.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attribute = (Attr)attrs.item(i);
                subParameters.add(new SoapParameter(attribute.getName(), attribute.getValue()));
            }
        }
        if (subParameters.size() > 0) {
            if (paramText.length() > 0) {
                return new SoapParameter(paramName, paramText.toString(), subParameters);
            }
            return new SoapParameter(paramName, subParameters);
        }
        return new SoapParameter(paramName, paramText.toString());
    }
}

