/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.protocol;

import org.alfresco.officeservices.exceptions.MalformedVermeerRequestException;
import org.alfresco.officeservices.protocol.VermeerRequest;

public class VermeerParameterString {
    protected String value = null;

    public VermeerParameterString(String data) throws MalformedVermeerRequestException {
        if (data != null) {
            StringBuffer decodedString = new StringBuffer(data.length());
            boolean escaped = false;
            int size = data.length();
            for (int i = 0; i < size; ++i) {
                char c = data.charAt(i);
                if (escaped) {
                    switch (c) {
                        case '\\': {
                            decodedString.append('\\');
                            break;
                        }
                        case '=': {
                            decodedString.append('=');
                            break;
                        }
                        case '[': {
                            decodedString.append('[');
                            break;
                        }
                        case ']': {
                            decodedString.append(']');
                            break;
                        }
                        case ';': {
                            decodedString.append(';');
                            break;
                        }
                        case '\"': {
                            decodedString.append('\"');
                            break;
                        }
                        default: {
                            throw new MalformedVermeerRequestException("invalid escapeing sequence");
                        }
                    }
                    escaped = false;
                    continue;
                }
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                decodedString.append(c);
            }
            if (escaped) {
                throw new MalformedVermeerRequestException("invalid escapeing sequence");
            }
            this.value = decodedString.toString();
        }
    }

    public VermeerParameterString(VermeerRequest request, String parameterName, boolean required) throws MalformedVermeerRequestException {
        this(request.getParameter(parameterName));
        if (required && this.isNull()) {
            throw new MalformedVermeerRequestException(parameterName + " missing");
        }
    }

    public boolean isNull() {
        return this.value == null;
    }

    public String getValue() {
        return this.value;
    }
}

