/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.protocol;

import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.util.Date;
import org.alfresco.officeservices.protocol.VermeerResponse;
import org.alfresco.officeservices.protocol.VermeerReturnDictionary;

public class VermeerReturnDictionaryDirectory
implements VermeerReturnDictionary {
    protected Date dateCreated;
    protected Date dateLastModified;
    protected String listName;
    protected boolean minorVersionsEnabled = false;

    public VermeerReturnDictionaryDirectory(Date dateCreated, Date dateLastModified, String listName) {
        this.dateCreated = dateCreated;
        this.dateLastModified = dateLastModified;
        this.listName = listName;
    }

    public void setMinorVersionsEnabled(boolean minorVersionsEnabled) {
        this.minorVersionsEnabled = minorVersionsEnabled;
    }

    @Override
    public void write(ServletOutputStream out) throws IOException {
        out.print("\n<ul>");
        out.print("\n<li>vti_isexecutable");
        out.print("\n<li>BR|false");
        out.print("\n<li>vti_isbrowsable");
        out.print("\n<li>BR|true");
        out.print("\n<li>vti_isscriptable");
        out.print("\n<li>BR|false");
        out.print("\n<li>vti_hassubdirs");
        out.print("\n<li>BR|true");
        out.print("\n<li>vti_listname");
        out.print("\n<li>SR|" + VermeerResponse.encodeString(this.listName));
        out.print("\n<li>vti_timecreated");
        out.print("\n<li>TR|" + VermeerResponse.formatDate(this.dateCreated));
        out.print("\n<li>vti_dirlateststamp");
        out.print("\n<li>TR|" + VermeerResponse.formatDate(this.dateLastModified));
        out.print("\n<li>vti_timelastmodified");
        out.print("\n<li>TR|" + VermeerResponse.formatDate(this.dateLastModified));
        out.print("\n<li>vti_listenableversioning");
        out.print("\n<li>BR|true");
        out.print("\n<li>vti_listenableminorversions");
        out.print("\n<li>BR|" + (this.minorVersionsEnabled ? "true" : "false"));
        out.print("\n</ul>");
    }

    @Override
    public String toTraceString() {
        StringBuffer sb = new StringBuffer();
        sb.append("vti_timecreated=");
        sb.append(VermeerResponse.formatDate(this.dateCreated));
        sb.append(" vti_dirlateststamp=");
        sb.append(VermeerResponse.formatDate(this.dateLastModified));
        sb.append(" vti_timelastmodified=");
        sb.append(VermeerResponse.formatDate(this.dateLastModified));
        return sb.toString();
    }
}

