/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.protocol;

import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.util.Date;
import org.alfresco.officeservices.protocol.VermeerResponse;
import org.alfresco.officeservices.protocol.VermeerReturnDictionary;

public class VermeerReturnDictionaryFile
implements VermeerReturnDictionary {
    protected long size;
    protected boolean isLocked;
    protected boolean isCheckedOut;
    protected Date dateCreated;
    protected Date dateLastModified;
    protected String createdBy;
    protected String createdByDomain;
    protected String modifiedBy;
    protected String modifiedByDomain;
    protected Date dateLocked;
    protected Date dateLockExpires;
    protected Date dateCheckedOut;
    protected String lockedBy;
    protected String lockedByDomain;
    protected String checkedOutBy;
    protected String checkedOutByDomain;
    protected String version;
    protected boolean checkoutToLocal = false;

    public VermeerReturnDictionaryFile(long size, boolean isLocked, boolean isCheckedOut, Date dateCreated, Date dateLastModified, String createdBy, String modifiedBy, Date dateLocked, Date dateLockExpires, Date dateCheckedOut, String lockedBy, String checkedOutBy, String version) {
        this.size = size;
        this.isLocked = isLocked;
        this.isCheckedOut = isCheckedOut;
        this.dateCreated = dateCreated;
        this.dateLastModified = dateLastModified;
        this.createdBy = createdBy;
        this.createdByDomain = "OFFICE";
        this.modifiedBy = modifiedBy;
        this.modifiedByDomain = "OFFICE";
        this.dateLocked = dateLocked;
        this.dateLockExpires = dateLockExpires;
        this.dateCheckedOut = dateCheckedOut;
        this.lockedBy = lockedBy;
        this.lockedByDomain = "OFFICE";
        this.checkedOutBy = checkedOutBy;
        this.checkedOutByDomain = "OFFICE";
        this.version = version;
    }

    public VermeerReturnDictionaryFile(long size, boolean isLocked, boolean isCheckedOut, Date dateCreated, Date dateLastModified, String createdBy, String createdByDomain, String modifiedBy, String modifiedByDomain, Date dateLocked, Date dateLockExpires, Date dateCheckedOut, String lockedBy, String lockedByDomain, String checkedOutBy, String checkedOutByDomain, String version) {
        this.size = size;
        this.isLocked = isLocked;
        this.isCheckedOut = isCheckedOut;
        this.dateCreated = dateCreated;
        this.dateLastModified = dateLastModified;
        this.createdBy = createdBy;
        this.createdByDomain = createdByDomain;
        this.modifiedBy = modifiedBy;
        this.modifiedByDomain = modifiedByDomain;
        this.dateLocked = dateLocked;
        this.dateLockExpires = dateLockExpires;
        this.dateCheckedOut = dateCheckedOut;
        this.lockedBy = lockedBy;
        this.lockedByDomain = lockedByDomain;
        this.checkedOutBy = checkedOutBy;
        this.checkedOutByDomain = checkedOutByDomain;
        this.version = version;
    }

    public void setCheckoutToLocal(boolean toLocal) {
        this.checkoutToLocal = toLocal;
    }

    @Override
    public void write(ServletOutputStream out) throws IOException {
        out.print("\n<ul>");
        if (this.isLocked && !this.isCheckedOut) {
            out.print("\n<li>vti_sourcecontrollockexpires");
            out.print("\n<li>TR|" + VermeerResponse.formatDate(this.dateLockExpires));
        }
        out.print("\n<li>vti_modifiedby");
        out.print("\n<li>SR|");
        if (this.modifiedByDomain != null) {
            out.print(VermeerResponse.encodeString(this.modifiedByDomain));
            out.print("&#92;");
        }
        out.print(VermeerResponse.encodeString(this.modifiedBy));
        out.print("\n<li>vti_filesize");
        out.print("\n<li>IR|" + this.size);
        out.print("\n<li>vti_timecreated");
        out.print("\n<li>TR|" + VermeerResponse.formatDate(this.dateCreated));
        out.print("\n<li>vti_nexttolasttimemodified");
        out.print("\n<li>TR|" + VermeerResponse.formatDate(this.dateCreated));
        out.print("\n<li>vti_title");
        out.print("\n<li>SW|");
        out.print("\n<li>vti_timelastmodified");
        out.print("\n<li>TR|" + VermeerResponse.formatDate(this.dateLastModified));
        if (this.isLocked || this.isCheckedOut) {
            out.print("\n<li>vti_sourcecontrolmultiuserchkoutby");
            if (this.isCheckedOut) {
                out.print("\n<li>VR|");
                if (this.checkedOutByDomain != null) {
                    out.print(VermeerResponse.encodeString(this.checkedOutByDomain));
                    out.print("&#92;&#92;");
                }
                out.print(VermeerResponse.encodeString(this.checkedOutBy));
            } else {
                out.print("\n<li>VR|");
                if (this.lockedByDomain != null) {
                    out.print(VermeerResponse.encodeString(this.lockedByDomain));
                    out.print("&#92;&#92;");
                }
                out.print(VermeerResponse.encodeString(this.lockedBy));
            }
        }
        out.print("\n<li>vti_author");
        out.print("\n<li>SR|");
        if (this.createdByDomain != null) {
            out.print(VermeerResponse.encodeString(this.createdByDomain));
            out.print("&#92;");
        }
        out.print(VermeerResponse.encodeString(this.createdBy));
        if (this.isLocked || this.isCheckedOut) {
            if (this.isCheckedOut) {
                out.print("\n<li>vti_sourcecontrolcheckedoutby");
                out.print("\n<li>SR|");
                if (this.checkedOutByDomain != null) {
                    out.print(VermeerResponse.encodeString(this.checkedOutByDomain));
                    out.print("&#92;");
                }
                out.print(VermeerResponse.encodeString(this.checkedOutBy));
                out.print("\n<li>vti_sourcecontroltimecheckedout");
                out.print("\n<li>TR|" + VermeerResponse.formatDate(this.dateCheckedOut));
            } else {
                out.print("\n<li>vti_sourcecontrolcheckedoutby");
                out.print("\n<li>SR|");
                if (this.lockedByDomain != null) {
                    out.print(VermeerResponse.encodeString(this.lockedByDomain));
                    out.print("&#92;");
                }
                out.print(VermeerResponse.encodeString(this.lockedBy));
                out.print("\n<li>vti_sourcecontroltimecheckedout");
                out.print("\n<li>TR|" + VermeerResponse.formatDate(this.dateLocked));
            }
        }
        out.print("\n<li>vti_sourcecontrolversion");
        out.print("\n<li>SR|V" + this.version);
        out.print("\n<li>vti_sourcecontrolcookie");
        out.print("\n<li>SR|fp_internal");
        if (this.isCheckedOut) {
            out.print("\n<li>vti_sourcecontrolcheckouttolocal");
            out.print("\n<li>BR|");
            if (this.checkoutToLocal) {
                out.print("true");
            } else {
                out.print("false");
            }
        }
        out.print("\n<li>vti_canmaybeedit");
        out.print("\n<li>BX|true");
        out.print("\n</ul>");
    }

    @Override
    public String toTraceString() {
        StringBuffer sb = new StringBuffer();
        if (this.isLocked && !this.isCheckedOut) {
            sb.append(" vti_sourcecontrollockexpires=");
            sb.append(VermeerResponse.formatDate(this.dateLockExpires));
        }
        sb.append(" vti_modifiedby=");
        sb.append("OFFICE&#92;");
        sb.append(VermeerResponse.encodeString(this.modifiedBy));
        sb.append(" vti_filesize=");
        sb.append(Long.toString(this.size));
        sb.append(" vti_timecreated=");
        sb.append(VermeerResponse.formatDate(this.dateCreated));
        sb.append(" vti_nexttolasttimemodified=");
        sb.append(VermeerResponse.formatDate(this.dateCreated));
        sb.append(" vti_title=");
        sb.append(" vti_timelastmodified=");
        sb.append(VermeerResponse.formatDate(this.dateLastModified));
        if (this.isLocked || this.isCheckedOut) {
            sb.append(" vti_sourcecontrolmultiuserchkoutby=");
            if (this.isCheckedOut) {
                sb.append(VermeerResponse.encodeString(this.checkedOutByDomain));
                sb.append("&#92;&#92;");
                sb.append(VermeerResponse.encodeString(this.checkedOutBy));
            } else {
                sb.append(VermeerResponse.encodeString(this.lockedByDomain));
                sb.append("&#92;&#92;");
                sb.append(VermeerResponse.encodeString(this.lockedBy));
            }
        }
        sb.append(" vti_author=");
        sb.append("OFFICE&#92;");
        sb.append(VermeerResponse.encodeString(this.createdBy));
        if (this.isLocked || this.isCheckedOut) {
            if (this.isCheckedOut) {
                sb.append(" vti_sourcecontrolcheckedoutby=");
                sb.append(VermeerResponse.encodeString(this.checkedOutByDomain));
                sb.append("&#92;");
                sb.append(VermeerResponse.encodeString(this.checkedOutBy));
                sb.append(" vti_sourcecontroltimecheckedout=");
                sb.append(VermeerResponse.formatDate(this.dateCheckedOut));
                sb.append(" vti_sourcecontrolcheckouttolocal=");
                if (this.checkoutToLocal) {
                    sb.append("true");
                } else {
                    sb.append("false");
                }
            } else {
                sb.append(" vti_sourcecontrolcheckedoutby=");
                sb.append(VermeerResponse.encodeString(this.lockedByDomain));
                sb.append("&#92;");
                sb.append(VermeerResponse.encodeString(this.lockedBy));
                sb.append(" vti_sourcecontroltimecheckedout=");
                sb.append(VermeerResponse.formatDate(this.dateLocked));
            }
        }
        sb.append(" vti_sourcecontrolversion=");
        sb.append(this.version);
        sb.append(" vti_sourcecontrolcookie=");
        sb.append("fp_internal");
        return sb.toString();
    }
}

