/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.protocol;

import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.officeservices.protocol.VermeerResponse;
import org.alfresco.officeservices.protocol.VermeerReturnDictionary;
import org.alfresco.officeservices.protocol.VermeerReturnValue;

public class VermeerReturnDocumentList
implements VermeerReturnValue {
    protected List<VermeerReturnDocumentListItem> items = new ArrayList<VermeerReturnDocumentListItem>();

    public void add(String documentUrl, VermeerReturnDictionary metainfoDictionary) {
        this.items.add(new VermeerReturnDocumentListItem(documentUrl, metainfoDictionary));
    }

    public int size() {
        return this.items.size();
    }

    public String getDocumentName(int i) {
        return this.items.get(i).getDocumentName();
    }

    public VermeerReturnDictionary getMetainfoDictionary(int i) {
        return this.items.get(i).getMetainfoDictionary();
    }

    @Override
    public void write(ServletOutputStream out) throws IOException {
        out.print("\n<ul>");
        for (VermeerReturnDocumentListItem item : this.items) {
            out.print("\n<ul>");
            out.print("\n<li>document_name=");
            out.print(VermeerResponse.encodeString(item.getDocumentName()));
            out.print("\n<li>meta_info=");
            item.getMetainfoDictionary().write(out);
            out.print("\n</ul>");
        }
        out.print("\n</ul>");
    }

    @Override
    public String toTraceString() {
        return "####";
    }

    protected static class VermeerReturnDocumentListItem {
        protected String documentName;
        protected VermeerReturnDictionary metainfoDictionary;

        public VermeerReturnDocumentListItem(String documentName, VermeerReturnDictionary metainfoDictionary) {
            this.documentName = documentName;
            this.metainfoDictionary = metainfoDictionary;
        }

        public String getDocumentName() {
            return this.documentName;
        }

        public VermeerReturnDictionary getMetainfoDictionary() {
            return this.metainfoDictionary;
        }
    }
}

