/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.vfs;

import java.io.InputStream;
import java.util.StringTokenizer;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.protocol.VermeerRequest;
import org.alfresco.officeservices.vfs.VFSDocumentNode;
import org.alfresco.officeservices.vfs.VFSNode;
import org.alfresco.officeservices.vfs.VirtualFileSystem;

public abstract class StandardVirtualFileSystem
implements VirtualFileSystem {
    protected abstract VFSNode getFilesystemRoot(UserData var1, int var2) throws AuthenticationRequiredException;

    @Override
    public VFSNode getNodeByPath(UserData userData, String path, int callContext) throws AuthenticationRequiredException {
        StringTokenizer pathTokens = new StringTokenizer(path, "/\\", false);
        VFSNode result = this.getFilesystemRoot(userData, callContext);
        while (pathTokens.hasMoreTokens()) {
            String pathElement = pathTokens.nextToken();
            if (pathElement.length() <= 0) continue;
            if (result == null || result instanceof VFSDocumentNode) {
                return null;
            }
            result = result.getContainmentByName(userData, pathElement, callContext);
        }
        return result;
    }

    @Override
    public VFSDocumentNode createDocument(UserData userData, String path, InputStream content, int callContext) throws AuthenticationRequiredException {
        StringTokenizer pathTokens = new StringTokenizer(path, "/\\", false);
        VFSNode parent = this.getFilesystemRoot(userData, callContext);
        String filename = null;
        while (pathTokens.hasMoreTokens()) {
            String pathElement = pathTokens.nextToken();
            if (pathElement.length() <= 0) continue;
            if (filename != null) {
                if (parent == null || parent instanceof VFSDocumentNode) {
                    return null;
                }
                parent = parent.getContainmentByName(userData, filename, callContext);
            }
            filename = pathElement;
        }
        if (parent == null || filename == null) {
            return null;
        }
        return parent.createNewFile(userData, filename, content, callContext);
    }

    @Override
    public VFSDocumentNode createDocument(UserData userData, String path, VermeerRequest request, int callContext) throws AuthenticationRequiredException {
        StringTokenizer pathTokens = new StringTokenizer(path, "/\\", false);
        VFSNode parent = this.getFilesystemRoot(userData, callContext);
        String filename = null;
        while (pathTokens.hasMoreTokens()) {
            String pathElement = pathTokens.nextToken();
            if (pathElement.length() <= 0) continue;
            if (filename != null) {
                if (parent == null || parent instanceof VFSDocumentNode) {
                    return null;
                }
                parent = parent.getContainmentByName(userData, filename, callContext);
            }
            filename = pathElement;
        }
        if (parent == null || filename == null) {
            return null;
        }
        return parent.createNewFile(userData, filename, request, callContext);
    }

    @Override
    public VFSNode createFolder(UserData userData, String path, int callContext) throws AuthenticationRequiredException {
        StringTokenizer pathTokens = new StringTokenizer(path, "/\\", false);
        VFSNode parent = this.getFilesystemRoot(userData, callContext);
        String filename = null;
        while (pathTokens.hasMoreTokens()) {
            String pathElement = pathTokens.nextToken();
            if (pathElement.length() <= 0) continue;
            if (filename != null) {
                if (parent == null || parent instanceof VFSDocumentNode) {
                    return null;
                }
                parent = parent.getContainmentByName(userData, filename, callContext);
            }
            filename = pathElement;
        }
        if (parent == null || filename == null) {
            return null;
        }
        return parent.createNewFolder(userData, filename, callContext);
    }
}

