/*
 * Copyright 2005-2015 Alfresco Software, Ltd.  All rights reserved.
 *
 * This file is part of a proprietary Alfresco module.
 *
 * License rights for this program are granted under the terms of the "Alfresco
 * Component License", which defines the permitted uses of the module.
 * License terms can be found in the file license.txt distributed with this module.
 */
package org.alfresco.module.aosmodule.dispatch;

import java.io.IOException;
import java.util.List;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.lists.AbstractListsService;
import org.alfresco.officeservices.lists.CheckinType;
import org.alfresco.officeservices.lists.ListChanges;
import org.alfresco.officeservices.lists.ListDescription;
import org.alfresco.officeservices.lists.ListType;
import org.alfresco.officeservices.lists.ListUpdatesBatch;
import org.alfresco.officeservices.lists.ListsGetListAndViewView;
import org.alfresco.officeservices.lists.ListsGetListContentTypeContentType;
import org.alfresco.officeservices.lists.ListsGetListContentTypesContentType;
import org.alfresco.officeservices.lists.ListsGetListList;
import org.alfresco.officeservices.lists.UpdateListItemsResults;
import org.alfresco.officeservices.protocol.SimpleSoapParser;
import org.alfresco.officeservices.protocol.SoapParameter;

public class ListsService extends AbstractListsService
{

    private static final long serialVersionUID = 6923578592507345851L;

    @Override
    protected boolean isWSS3List(UserData userData, String listName)
    {
        return true;
    }

    @Override
    protected ListType getListType(UserData userData, String listName)
    {
        return ListType.UNSPECIFIED;
    }

    @Override
    protected boolean isValidListName(UserData userData, String listName)
    {
        return false;
    }

    @Override
    protected String getAlternateServerURL(UserData userData, String listName, HttpServletRequest request)
    {
        String protocol = request.isSecure() ? "https://" : "http://";
        int defaultPort = request.isSecure() ? 443 : 80;
        String portString = (request.getLocalPort() != defaultPort) ? ":" + Integer.toString(request.getLocalPort()) : "";
        return protocol + request.getServerName() + portString;
    }

    @Override
    protected String getRootFolder(UserData userData, String listName)
    {
        return "/";
    }

    @Override
    protected ListChanges getListItemChanges(UserData userData, String listName, String since, HttpServletRequest request) throws AuthenticationRequiredException
    {
        return null;
    }

    @Override
    protected ListChanges getListItems(UserData userData, String listName, SoapParameter query, SoapParameter queryOptions, SoapParameter viewFields, HttpServletRequest request) throws AuthenticationRequiredException
    {
        return null;
    }

    @Override
    protected UpdateListItemsResults updateListItems(UserData userData, String listName, ListUpdatesBatch batch, HttpServletRequest request) throws AuthenticationRequiredException
    {
        return null;
    }

    @Override
    protected ListChanges getListChangesSinceToken(UserData userData, String listName, SoapParameter viewFields, String rowLimit, SoapParameter queryOptions, String changeToken, SoapParameter contains, HttpServletRequest request)
            throws AuthenticationRequiredException
    {
        return null;
    }

    @Override
    protected boolean checkoutFile(UserData userData, String documentName, boolean checkoutToLocal, String lastModified) throws AuthenticationRequiredException
    {
        return false;
    }

    @Override
    protected boolean checkinFile(UserData userData, String documentName, String comment, CheckinType checkinType) throws AuthenticationRequiredException
    {
        return false;
    }

    @Override
    protected boolean undoCheckOut(UserData userData, String documentName) throws AuthenticationRequiredException
    {
        return false;
    }

    @Override
    protected ListsGetListContentTypeContentType getListContentType(UserData userData, String listName, String contentTypeId, HttpServletRequest request) throws AuthenticationRequiredException
    {
        return null;
    }

    @Override
    protected ListsGetListContentTypesContentType[] getListContentTypes(UserData userData, String listName, String contentTypeId, HttpServletRequest request) throws AuthenticationRequiredException
    {
        return null;
    }

    @Override
    public List<ListDescription> getListCollection(SimpleSoapParser parser)
    {
        return null;
    }

    @Override
    protected ListsGetListList getList(UserData userData, String listName, HttpServletRequest request) throws AuthenticationRequiredException
    {
        return null;
    }

    @Override
    protected ListsGetListAndViewView getView(UserData userData, String listName, String viewName, HttpServletRequest request) throws AuthenticationRequiredException
    {
        return null;
    }

    protected class ListsServiceUserData implements UserData
    {

        public String getUsername()
        {
            return "";
        }

    }

    protected UserData userData = new ListsServiceUserData();

    public UserData negotiateAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException
    {
        return userData;
    }

    public void requestAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException
    {
        // nothing to do here
    }

    public void invalidateAuthentication(UserData userData, HttpServletRequest request, HttpServletResponse response) throws IOException
    {
        // nothing to do here
    }

}
