/*
 * Copyright 2005-2022 Alfresco Software, Ltd.  All rights reserved.
 *
 * This file is part of a proprietary Alfresco module.
 *
 * License rights for this program are granted under the terms of the "Alfresco
 * Component License", which defines the permitted uses of the module.
 * License terms can be found in the file license.txt distributed with this module.
 */
package org.alfresco.module.aosmodule.dispatch;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;


import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

import org.alfresco.officeservices.StandardDispatcherService;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.exceptions.VermeerException;
import org.alfresco.officeservices.protocol.VermeerRequest;
import org.alfresco.officeservices.protocol.VermeerResponse;
import org.alfresco.officeservices.protocol.VermeerReturnList;
import org.alfresco.officeservices.protocol.VermeerReturnStringValue;
import org.slf4j.LoggerFactory;
import org.slf4j.Logger;

public class ServiceDispatcher extends StandardDispatcherService
{

	private static final long serialVersionUID = 7637570058783423513L;

	protected List<String> servicePrefixes = new ArrayList<String>();
	
    private Logger logger = LoggerFactory.getLogger(ServiceDispatcher.class);

    public void init(ServletConfig servletConfig_p) throws ServletException
    {
        // initialize parent class
        super.init(servletConfig_p);
        // read list of service names
        String spaceSeparatedEncodedServices = getServletContext().getInitParameter("org.alfresco.module.aosmodule.dispatch.SERVICES");
        if(spaceSeparatedEncodedServices != null)
        {
            for(String encodedContext : spaceSeparatedEncodedServices.split(" "))
            {
                try
                {
                    servicePrefixes.add(URLDecoder.decode(encodedContext, "UTF-8"));
                }
                catch (UnsupportedEncodingException e)
                {
                    logger.error("Unsupported encoding",e);
                }
            }
        }
    }

    public List<String> getServicePrefixes(VermeerRequest vermeerRequest)
    {
        return servicePrefixes;
    }

    public void serverVersion(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) throws IOException, VermeerException, AuthenticationRequiredException
    {
        // compile and send response
        VermeerReturnList serverVersionDescription = new VermeerReturnList();
        serverVersionDescription.add("major ver",new VermeerReturnStringValue("14"));
        serverVersionDescription.add("minor ver",new VermeerReturnStringValue("0"));
        serverVersionDescription.add("phase ver",new VermeerReturnStringValue("0"));
        serverVersionDescription.add("ver incr",new VermeerReturnStringValue("4730"));
        vermeerResponse.addReturnItem("server version",serverVersionDescription);
        vermeerResponse.addReturnItem("source control",new VermeerReturnStringValue("1"));
        vermeerResponse.send();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException
    {
        resp.getWriter().print("<html><body>This is the xoservices xosdav ServiceDispatcher</body></html>");
    }


    protected class ServiceDispatcherUserData implements UserData
    {

        public String getUsername()
        {
            return "";
        }

    }

    protected UserData userData = new ServiceDispatcherUserData();

    public UserData negotiateAuthentication(HttpServletRequest arg0, HttpServletResponse arg1) throws IOException
    {
        return userData;
    }

    public void invalidateAuthentication(UserData arg0, HttpServletRequest arg1, HttpServletResponse arg2) throws IOException
    {
        // nothing to do here
    }

    public void requestAuthentication(HttpServletRequest arg0, HttpServletResponse arg1) throws IOException
    {
        // nothing to do here
    }

}