/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.dispatch;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.officeservices.StandardDispatcherService;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.exceptions.VermeerException;
import org.alfresco.officeservices.protocol.VermeerRequest;
import org.alfresco.officeservices.protocol.VermeerResponse;
import org.alfresco.officeservices.protocol.VermeerReturnList;
import org.alfresco.officeservices.protocol.VermeerReturnStringValue;
import org.alfresco.officeservices.protocol.VermeerReturnValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDispatcher
extends StandardDispatcherService {
    private static final long serialVersionUID = 7637570058783423513L;
    protected List<String> servicePrefixes = new ArrayList<String>();
    private Logger logger = LoggerFactory.getLogger(ServiceDispatcher.class);
    protected UserData userData = new ServiceDispatcherUserData();

    public void init(ServletConfig servletConfig_p) throws ServletException {
        super.init(servletConfig_p);
        String spaceSeparatedEncodedServices = this.getServletContext().getInitParameter("org.alfresco.module.aosmodule.dispatch.SERVICES");
        if (spaceSeparatedEncodedServices != null) {
            for (String encodedContext : spaceSeparatedEncodedServices.split(" ")) {
                try {
                    this.servicePrefixes.add(URLDecoder.decode(encodedContext, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    this.logger.error("Unsupported encoding", (Throwable)e);
                }
            }
        }
    }

    public List<String> getServicePrefixes(VermeerRequest vermeerRequest) {
        return this.servicePrefixes;
    }

    public void serverVersion(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) throws IOException, VermeerException, AuthenticationRequiredException {
        VermeerReturnList serverVersionDescription = new VermeerReturnList();
        serverVersionDescription.add("major ver", (VermeerReturnValue)new VermeerReturnStringValue("14"));
        serverVersionDescription.add("minor ver", (VermeerReturnValue)new VermeerReturnStringValue("0"));
        serverVersionDescription.add("phase ver", (VermeerReturnValue)new VermeerReturnStringValue("0"));
        serverVersionDescription.add("ver incr", (VermeerReturnValue)new VermeerReturnStringValue("4730"));
        vermeerResponse.addReturnItem("server version", (VermeerReturnValue)serverVersionDescription);
        vermeerResponse.addReturnItem("source control", (VermeerReturnValue)new VermeerReturnStringValue("1"));
        vermeerResponse.send();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.getWriter().print("<html><body>This is the xoservices xosdav ServiceDispatcher</body></html>");
    }

    public UserData negotiateAuthentication(HttpServletRequest arg0, HttpServletResponse arg1) throws IOException {
        return this.userData;
    }

    public void invalidateAuthentication(UserData arg0, HttpServletRequest arg1, HttpServletResponse arg2) throws IOException {
    }

    public void requestAuthentication(HttpServletRequest arg0, HttpServletResponse arg1) throws IOException {
    }

    protected class ServiceDispatcherUserData
    implements UserData {
        protected ServiceDispatcherUserData() {
        }

        public String getUsername() {
            return "";
        }
    }
}

