/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.dispatch;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.officeservices.GetWebCollectionWebDescription;
import org.alfresco.officeservices.GetWebWebDescription;
import org.alfresco.officeservices.StandardWebsService;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.WebsGetContentTypeContentType;
import org.alfresco.officeservices.WebsGetContentTypesContentType;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.protocol.SimpleSoapParser;
import org.alfresco.officeservices.protocol.SoapParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsService
extends StandardWebsService {
    private static final long serialVersionUID = -6294184506392454609L;
    protected List<String> servicePrefixes = new ArrayList<String>();
    private Logger logger = LoggerFactory.getLogger(WebsService.class);
    protected UserData userData = new WebsServiceUserData();

    public void init(ServletConfig servletConfig_p) throws ServletException {
        super.init(servletConfig_p);
        String spaceSeparatedEncodedServices = this.getServletContext().getInitParameter("org.alfresco.module.aosmodule.dispatch.SERVICES");
        if (spaceSeparatedEncodedServices != null) {
            for (String encodedContext : spaceSeparatedEncodedServices.split(" ")) {
                try {
                    this.servicePrefixes.add(URLDecoder.decode(encodedContext, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    this.logger.error("Unsupported encoding", (Throwable)e);
                }
            }
        }
        this.servicePrefixes.add("");
    }

    public List<String> getServicePrefixes(SimpleSoapParser parser, HttpServletRequest request) {
        return this.servicePrefixes;
    }

    protected String getServerUrl(HttpServletRequest request) {
        String protocol = request.isSecure() ? "https://" : "http://";
        int defaultPort = request.isSecure() ? 443 : 80;
        String portString = request.getLocalPort() != defaultPort ? ":" + Integer.toString(request.getLocalPort()) : "";
        return protocol + request.getServerName() + portString;
    }

    public List<GetWebCollectionWebDescription> getWebCollection(SimpleSoapParser parser, HttpServletRequest request) {
        String serverUrl = this.getServerUrl(request);
        ArrayList<GetWebCollectionWebDescription> webCollection = new ArrayList<GetWebCollectionWebDescription>(this.servicePrefixes.size() - 1);
        for (String servicePrefix : this.servicePrefixes) {
            String webUrlForService = serverUrl + servicePrefix;
            String webTitle = servicePrefix.length() > 1 && servicePrefix.startsWith("/") ? servicePrefix.substring(1) : servicePrefix;
            webCollection.add(new GetWebCollectionWebDescription(webTitle, webUrlForService));
        }
        return webCollection;
    }

    protected GetWebWebDescription getWebResult(UserData userData, String webUrl, SimpleSoapParser parser, HttpServletRequest request) {
        String serverUrl = this.getServerUrl(request);
        for (String servicePrefix : this.servicePrefixes) {
            String webUrlForService = serverUrl + servicePrefix;
            if (!webUrl.equals(webUrlForService)) continue;
            String webTitle = servicePrefix.length() > 1 && servicePrefix.startsWith("/") ? servicePrefix.substring(1) : servicePrefix;
            return new GetWebWebDescription(webTitle, webUrlForService, "", "1033", "");
        }
        return null;
    }

    public WebsGetContentTypesContentType[] getContentTypes(SimpleSoapParser parser, HttpServletRequest request) {
        return null;
    }

    protected WebsGetContentTypeContentType getContentType(UserData userData, String contentTypeId, HttpServletRequest request) throws AuthenticationRequiredException {
        return null;
    }

    public UserData negotiateAuthentication(HttpServletRequest arg0, HttpServletResponse arg1) throws IOException {
        return this.userData;
    }

    public void invalidateAuthentication(UserData userData, HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    public void requestAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    protected boolean updateContentTypeXmlDocument(UserData userData, String contentTypeId, SoapParameter newDocument, HttpServletRequest request) throws AuthenticationRequiredException {
        return false;
    }

    protected class WebsServiceUserData
    implements UserData {
        protected WebsServiceUserData() {
        }

        public String getUsername() {
            return "";
        }
    }
}

