/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.aos;

import org.alfresco.aos.AOSTest;
import org.alfresco.aos.AOSWrapper;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.apache.commons.lang3.RandomStringUtils;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AOSDemoTest
extends AOSTest {
    private FileModel fileModel;
    private FolderModel folderModel;
    private String contentToAppend;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testSite = this.dataSite.createPublicRandomSite();
        this.folderModel = FolderModel.getRandomFolderModel();
        this.contentToAppend = RandomStringUtils.randomAlphanumeric((int)10);
    }

    @BeforeMethod(alwaysRun=true)
    public void createFileModel() throws Exception {
        this.fileModel = new FileModel(RandomData.getRandomFile((FileType)FileType.MSWORD2007), FileType.MSWORD2007, RandomData.getRandomName((String)"fileContent"));
    }

    @Test(groups={"protocols", "aos", "demo"})
    public void adminIsAbleToCreateFileInAOSDocumentLibrary() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFile(this.fileModel).and()).assertThat().existsInRepo()).then()).assertThat().fileExistsInAOS();
    }

    @Test(groups={"protocols", "aos", "demo"})
    public void adminIsAbleToCreateFileInAOSRootFolder() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).assertThat().existsInRepo()).then()).assertThat().fileExistsInAOS();
    }

    @Test(groups={"protocols", "aos", "demo"})
    public void adminIsAbleToCreateFolderInAos() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFolder(this.folderModel).and()).assertThat().existsInRepo()).then()).assertThat().fileExistsInAOS();
    }

    @Test(groups={"protocols", "aos", "demo"})
    public void adminIsAbleToCreateFolderInDocumentLibrary() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).and()).assertThat().existsInRepo()).then()).assertThat().fileExistsInAOS();
    }

    @Test(groups={"protocols", "aos", "demo"})
    public void adminIsAbleToRetrieveWord2003Content() throws Exception {
        this.fileModel = new FileModel(RandomData.getRandomFile((FileType)FileType.MSWORD), FileType.MSWORD, RandomData.getRandomName((String)"fileContent"));
        ((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).assertThat().contentIs(this.fileModel.getContent());
    }

    @Test(groups={"protocols", "aos", "demo"})
    public void adminIsAbleToRetrieveExcel2003Content() throws Exception {
        this.fileModel = new FileModel(RandomData.getRandomFile((FileType)FileType.MSEXCEL), FileType.MSEXCEL, RandomData.getRandomName((String)"fileContent"));
        ((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).assertThat().contentIs(this.fileModel.getContent());
    }

    @Test(groups={"protocols", "aos", "demo"})
    public void adminIsAbleToRetrievePowerPoint2003Content() throws Exception {
        this.fileModel = new FileModel(RandomData.getRandomFile((FileType)FileType.MSPOWERPOINT), FileType.MSPOWERPOINT, RandomData.getRandomName((String)"fileContent"));
        ((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).assertThat().contentIs(this.fileModel.getContent());
    }

    @Test(groups={"protocols", "aos", "demo"})
    public void adminIsAbleToRetrieveWord2007Content() throws Exception {
        ((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).assertThat().contentIs(this.fileModel.getContent());
    }

    @Test(groups={"protocols", "aos", "demo"})
    public void adminIsAbleToRetrieveExcel2007Content() throws Exception {
        this.fileModel = new FileModel(RandomData.getRandomFile((FileType)FileType.MSEXCEL2007), FileType.MSEXCEL2007, RandomData.getRandomName((String)"fileContent"));
        ((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).assertThat().contentIs(this.fileModel.getContent());
    }

    @Test(groups={"protocols", "aos", "demo"})
    public void adminIsAbleToRetrievePowerPoint2007Content() throws Exception {
        this.fileModel = new FileModel(RandomData.getRandomFile((FileType)FileType.MSPOWERPOINT2007), FileType.MSPOWERPOINT2007, RandomData.getRandomName((String)"fileContent"));
        ((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).assertThat().contentIs(this.fileModel.getContent());
    }

    @Test(groups={"protocols", "aos", "demo"})
    public void adminIsAbleToDeleteOfficeFiles() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).assertThat().existsInRepo()).then()).delete().and()).assertThat().doesNotExistInRepo();
    }

    @Test(groups={"protocols", "aos", "demo"})
    public void adminIsAbleToRenameOfficeFiles() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).assertThat().existsInRepo()).then()).rename("newFile.doc").and()).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "aos", "demo"})
    public void adminIsAbleToUpdateWordFile() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).assertThat().contentIs(this.fileModel.getContent()).and()).update(this.contentToAppend).then()).assertThat().contentIs(this.fileModel.getContent() + this.contentToAppend);
    }

    @Test(groups={"protocols", "aos", "demo"})
    public void adminIsAbleToUpdateExcelFile() throws Exception {
        this.fileModel = new FileModel(RandomData.getRandomFile((FileType)FileType.MSEXCEL2007), FileType.MSEXCEL2007, RandomData.getRandomName((String)"fileContent"));
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).update(this.contentToAppend).then()).assertThat().contentIs(this.fileModel.getContent() + this.contentToAppend);
    }

    @Test(groups={"protocols", "aos", "demo"})
    public void adminIsAbleToUpdatePowerPointFile() throws Exception {
        this.fileModel = new FileModel(RandomData.getRandomFile((FileType)FileType.MSPOWERPOINT2007), FileType.MSPOWERPOINT, RandomData.getRandomName((String)"fileContent"));
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).update(this.contentToAppend).then()).assertThat().contentIs(this.fileModel.getContent() + this.contentToAppend);
    }

    @Test(groups={"protocols", "aos", "demo"})
    public void adminIsAbleToCreateFileInFolderHierarchy() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).then()).createFolder(this.folderModel).then()).createFile(this.fileModel).then()).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "aos", "demo"})
    public void adminCannotEditCheckedOutDocument() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFile(this.fileModel).and()).checkOutDocument().then()).update("newContent").and()).assertThat().contentIs(this.fileModel.getContent());
    }

    @Test(groups={"protocols", "aos", "demo"})
    public void adminIsAbleToCopyFile() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFile(this.fileModel).then()).copyTo((ContentModel)this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS().then()).usingResource((ContentModel)this.fileModel).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
    }

    @Test(groups={"protocols", "aos", "demo"})
    public void adminIsAbleToMoveFile() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFile(this.fileModel).then()).moveTo((ContentModel)this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS().then()).usingResource((ContentModel)this.fileModel).assertThat().doesNotExistInRepo()).and()).assertThat().fileDoesNotExistInAOS();
    }
}

