/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.aos;

import java.io.File;
import org.alfresco.aos.AOSWebTest;
import org.alfresco.aos.web.AosLoginPage;
import org.alfresco.aos.web.AosNavigationPage;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.annotations.Test;

public class AosWithWebBrowserTests
extends AOSWebTest {
    private static final String SITES_URL_PATH = "/Sites/";
    private static final String DOCUMENT_LIBRARY_URL_PATH = "/documentLibrary/";
    @Autowired
    AosLoginPage aosLoginPage;
    @Autowired
    AosNavigationPage aosNavPage;

    @Test(enabled=false)
    public void openBrowserDemoTest() {
        this.aosLoginPage.authenticateSession(this.adminUser);
        this.aosLoginPage.navigateTo("Sites/sitePublic-VSxlhOmaHAyywyW/");
        this.aosNavPage.clickTableRow("documentLibrary");
        this.aosNavPage.clickTableRow("Folder-ZrDkWMjosnscKUx");
        this.aosNavPage.clickTableRow("file-dNPIZeZxZorbPpm");
        String srcRoot = System.getProperty("user.dir") + File.separator;
        String testDataFolder = srcRoot + "testdata" + File.separator + "file-dNPIZeZxZorbPpm.html";
        Utility.assertFileExists((String)testDataFolder);
        Utility.assertFileDoesNotExist((String)(testDataFolder + "a"));
    }

    @Bug(id="REPO-2095", status=Bug.Status.FIXED)
    @Test(groups={"sanity", "aos"})
    @TestRail(section={"aos"}, executionType={ExecutionType.SANITY}, description="File is downloaded when clicking it in WebBrowser")
    public void downloadFileUsingWebBrowser() {
        this.adminUser = this.dataUser.getAdminUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.testSite)).createFolder();
        FileModel file = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folder)).createContent(CMISUtil.DocumentType.HTML);
        this.aosLoginPage.authenticateSession(this.adminUser);
        this.aosLoginPage.navigateTo(SITES_URL_PATH.concat(this.testSite.getTitle().concat(DOCUMENT_LIBRARY_URL_PATH)));
        this.aosNavPage.clickTableRow(folder.getName());
        this.aosNavPage.clickTableRow(file.getName());
        String srcRoot = System.getProperty("user.dir") + File.separator;
        String testFileLocation = srcRoot + "testdata" + File.separator + file.getName();
        Utility.assertFileExists((String)testFileLocation);
    }
}

