/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.aos;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import org.alfresco.aos.AOSProperties;
import org.alfresco.aos.DataContentExtented;
import org.alfresco.aos.dsl.AOSAssertion;
import org.alfresco.aos.dsl.AOSNetworkDrive;
import org.alfresco.aos.dsl.AOSUtil;
import org.alfresco.aos.dsl.JmxUtil;
import org.alfresco.utility.LogFactory;
import org.alfresco.utility.TasProperties;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.dsl.DSLContentModelAction;
import org.alfresco.utility.dsl.DSLFile;
import org.alfresco.utility.dsl.DSLFolder;
import org.alfresco.utility.dsl.DSLProtocolWithNetworkDrive;
import org.alfresco.utility.exception.TestConfigurationException;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.SystemUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xslf.usermodel.SlideLayout;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFSlideLayout;
import org.apache.poi.xslf.usermodel.XSLFSlideMaster;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.BreakType;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class AOSWrapper
extends DSLProtocolWithNetworkDrive<AOSWrapper>
implements DSLContentModelAction<AOSWrapper>,
DSLFolder<AOSWrapper>,
DSLFile<AOSWrapper> {
    static Logger LOG = LogFactory.getLogger();
    @Autowired
    AOSProperties aosProperties;
    @Autowired
    TasProperties tasProperties;
    @Autowired
    AOSNetworkDrive aosNetworkDrive;
    @Autowired
    DataContentExtented dataContent;
    private FileOutputStream fileOut;
    private FileType fileType;
    private FileModel fileModel;
    private String content;
    private String aosLocation;
    public int status = 500;

    public AOSNetworkDrive withNetworkDrive() {
        return this.aosNetworkDrive;
    }

    public AOSUtil withAosUtil() {
        return new AOSUtil(this);
    }

    public AOSWrapper createFile(FileModel fileModel) throws Exception {
        this.content = RandomData.getRandomName((String)"fileContent");
        switch (fileModel.getFileType()) {
            case MSEXCEL: 
            case MSEXCEL2007: {
                int i;
                for (i = 0; i < 2; ++i) {
                    XSSFWorkbook wb = new XSSFWorkbook();
                    XSSFSheet sheet = wb.createSheet();
                    sheet.createRow(1);
                    sheet.getRow(1).createCell(1);
                    sheet.getRow(1).getCell(1).setCellValue(fileModel.getContent());
                    LOG.info("Aos Location is {} and fileModel Name is {}", (Object)this.getAosLocation(), (Object)fileModel.getName());
                    this.fileOut = new FileOutputStream(new File(this.getAosLocation(), fileModel.getName()));
                    wb.write((OutputStream)this.fileOut);
                    this.fileOut.close();
                    wb.close();
                    this.setFileType(FileType.MSEXCEL);
                }
                break;
            }
            case MSPOWERPOINT: 
            case MSPOWERPOINT2007: {
                int i;
                for (i = 0; i < 2; ++i) {
                    XMLSlideShow ppt = new XMLSlideShow();
                    XSLFSlideMaster slideMaster = (XSLFSlideMaster)ppt.getSlideMasters().get(0);
                    XSLFSlideLayout titleLayout = slideMaster.getLayout(SlideLayout.TITLE);
                    XSLFSlide slide1 = ppt.createSlide(titleLayout);
                    XSLFTextShape title1 = slide1.getPlaceholder(0);
                    title1.setText(fileModel.getContent());
                    this.fileOut = new FileOutputStream(new File(this.getAosLocation(), fileModel.getName()));
                    ppt.write((OutputStream)this.fileOut);
                    this.fileOut.close();
                    ppt.close();
                    this.setFileType(FileType.MSPOWERPOINT);
                }
                break;
            }
            case MSWORD: 
            case MSWORD2007: {
                int i;
                for (i = 0; i < 2; ++i) {
                    XWPFDocument document = new XWPFDocument();
                    this.fileOut = new FileOutputStream(new File(this.getAosLocation(), fileModel.getName()));
                    XWPFParagraph paragraph = document.createParagraph();
                    XWPFRun run = paragraph.createRun();
                    run.setText(fileModel.getContent());
                    document.write((OutputStream)this.fileOut);
                    this.fileOut.close();
                    document.close();
                    this.setFileType(FileType.MSWORD);
                }
                break;
            }
            default: {
                throw new TestConfigurationException("Unknown Office file type" + String.valueOf(fileModel.getFileType()));
            }
        }
        String location = this.getLastResourceWithoutPrefix();
        this.setLastResource(this.buildPath(location, fileModel.toFile().getName()));
        this.setAosLocation(this.getPrefixSpace() + this.getLastResource());
        this.setDefaultFileContent(fileModel.getContent());
        this.setFileModel(fileModel);
        fileModel.setProtocolLocation(this.getCurrentSpace() + fileModel.getName());
        fileModel.setCmisLocation(this.getLastResourceWithoutPrefix());
        fileModel.setNodeRef(this.contentService.getNodeRefByPath(this.getTestUser().getUsername(), this.getTestUser().getPassword(), this.getLastResourceWithoutPrefix()));
        LOG.info("Creating file: {}", (Object)this.getLastResource());
        this.dataContent.waitUntilContentIsCreatedInLinux(this.getLastResource());
        return this;
    }

    public AOSWrapper createFolder(FolderModel folderModel) throws Exception {
        String folderLocation = this.buildPath(this.getLastResource(), folderModel.getName());
        this.aosNetworkDrive.inOSEnvironment().createFolder(folderLocation);
        this.setLastResource(folderLocation);
        this.setAosLocation(this.getPrefixSpace() + this.getLastResource());
        folderModel.setProtocolLocation(this.getCurrentSpace() + folderModel.getName());
        folderModel.setCmisLocation(this.getLastResourceWithoutPrefix());
        LOG.info("Creating Folder: {}", (Object)this.getLastResource());
        this.dataContent.waitUntilContentIsCreatedInLinux(this.getLastResource());
        return this;
    }

    public List<FileModel> getFiles() throws Exception {
        return null;
    }

    public List<FolderModel> getFolders() throws Exception {
        return null;
    }

    public AOSWrapper rename(String newName) throws Exception {
        this.aosNetworkDrive.inOSEnvironment().renameContent(this.getLastResource(), newName).getPath();
        this.setLastResource(this.buildPath(this.getCurrentSpace(), newName));
        this.setAosLocation(this.getPrefixSpace() + this.getLastResource());
        this.dataContent.waitUntilContentIsCreatedInLinux(this.getLastResource());
        this.getLastContentModel().setProtocolLocation(this.getCurrentSpace() + this.fileModel.getName());
        this.getLastContentModel().setCmisLocation(this.getLastResourceWithoutPrefix());
        return this;
    }

    public AOSWrapper update(String content) throws Exception {
        String resourcePath = this.aosNetworkDrive.inOSEnvironment().getLocalVolumePath() + this.getLastResource();
        this.updateContent(resourcePath, content, Content.ADD);
        this.dataContent.waitUntilContentIsCreatedInLinux(this.getLastResource());
        return this;
    }

    public AOSWrapper deleteContent(String content) throws Exception {
        String resourcePath = this.aosNetworkDrive.inOSEnvironment().getLocalVolumePath() + this.getLastResource();
        this.updateContent(resourcePath, content, Content.DELETE);
        this.dataContent.waitUntilContentIsCreatedInLinux(this.getLastResource());
        return this;
    }

    public String buildPath(String parent, String ... paths) {
        return Utility.buildPath((String)parent, (String[])paths);
    }

    public AOSWrapper delete() throws Exception {
        String resourcePath = this.getLastResource();
        Utility.checkObjectIsInitialized((Object)resourcePath, (String)"resourcePath");
        this.aosNetworkDrive.inOSEnvironment().deleteContent(resourcePath);
        this.dataContent.waitUntilContentIsCreatedInLinux(this.getLastResource());
        return this;
    }

    public AOSWrapper copyTo(ContentModel destination) throws Exception {
        File file = new File(this.getLastResourceWithoutPrefix());
        String fileName = file.getName();
        String fileDestination = this.buildPath(destination.getCmisLocation(), fileName);
        if (Files.isRegularFile(Paths.get(this.getAosLocation(), new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            this.aosNetworkDrive.inOSEnvironment().copyFile(this.getLastResourceWithoutPrefix(), fileDestination);
        } else {
            this.aosNetworkDrive.inOSEnvironment().copyFolder(this.getLastResourceWithoutPrefix(), fileDestination);
        }
        this.setLastResource(fileDestination);
        this.setAosLocation(this.getPrefixSpace() + this.getLastResource());
        this.dataContent.waitUntilContentIsCreatedInLinux(this.getLastResource());
        return this;
    }

    public AOSWrapper updateContent(String resourcePath, String content, Content contentAction) throws FileNotFoundException, IOException {
        FileInputStream file;
        if (FileType.fromName((String)resourcePath).equals((Object)FileType.MSWORD) || FileType.fromName((String)resourcePath).equals((Object)FileType.MSWORD2007)) {
            file = new FileInputStream(new File(resourcePath));
            XWPFDocument document = new XWPFDocument((InputStream)file);
            List paragraphs = document.getParagraphs();
            List runs = ((XWPFParagraph)paragraphs.get(0)).getRuns();
            XWPFRun run = (XWPFRun)runs.get(0);
            if (contentAction.equals((Object)Content.ADD)) {
                run.setText(((XWPFParagraph)paragraphs.get(0)).getText() + content, 0);
            } else {
                run.setText(content, 0);
            }
            document.write((OutputStream)new FileOutputStream(new File(resourcePath)));
            document.close();
            this.setFileType(FileType.MSWORD);
        }
        if (FileType.fromName((String)resourcePath).equals((Object)FileType.MSEXCEL2007) || FileType.fromName((String)resourcePath).equals((Object)FileType.MSEXCEL)) {
            file = new FileInputStream(new File(resourcePath));
            XSSFWorkbook wb = new XSSFWorkbook((InputStream)file);
            XSSFSheet sheet = wb.getSheetAt(0);
            Row row = sheet.getRow(1);
            Cell cell = row.getCell(1);
            if (contentAction.equals((Object)Content.ADD)) {
                cell.setCellValue(this.getDefaultFileContent() + content);
            } else {
                cell.setCellValue(content);
            }
            FileOutputStream fileOut = new FileOutputStream(new File(resourcePath));
            wb.write((OutputStream)fileOut);
            fileOut.close();
            wb.close();
            this.setFileType(FileType.MSEXCEL);
        }
        if (FileType.fromName((String)resourcePath).equals((Object)FileType.MSPOWERPOINT) || FileType.fromName((String)resourcePath).equals((Object)FileType.MSPOWERPOINT2007)) {
            XMLSlideShow ppt = new XMLSlideShow((InputStream)new FileInputStream(resourcePath));
            XSLFTextShape title1 = ((XSLFSlide)ppt.getSlides().get(0)).getPlaceholder(0);
            if (contentAction.equals((Object)Content.ADD)) {
                title1.setText(this.getDefaultFileContent() + content);
            } else {
                title1.setText(content);
            }
            FileOutputStream fileOut = new FileOutputStream(new File(resourcePath));
            ppt.write((OutputStream)fileOut);
            fileOut.close();
            ppt.close();
            this.setFileType(FileType.MSPOWERPOINT);
        }
        this.dataContent.waitUntilContentIsCreatedInLinux(this.getLastResource());
        return this;
    }

    public AOSWrapper addNewDocumentPage() throws IOException, TestConfigurationException {
        String resourcePath = this.aosNetworkDrive.inOSEnvironment().getLocalVolumePath() + this.getLastResource();
        FileInputStream file = new FileInputStream(new File(resourcePath));
        if (FileType.fromName((String)resourcePath).equals((Object)FileType.MSWORD) || FileType.fromName((String)resourcePath).equals((Object)FileType.MSWORD2007)) {
            XWPFDocument document = new XWPFDocument((InputStream)file);
            XWPFParagraph paragraph = document.getLastParagraph();
            XWPFRun run = paragraph.createRun();
            run.addBreak(BreakType.PAGE);
            run.setText(this.getFileModel().getContent());
            paragraph.setPageBreak(true);
            document.write((OutputStream)new FileOutputStream(new File(resourcePath)));
            document.close();
        }
        if (FileType.fromName((String)resourcePath).equals((Object)FileType.MSEXCEL2007) || FileType.fromName((String)resourcePath).equals((Object)FileType.MSEXCEL)) {
            XSSFWorkbook wb = new XSSFWorkbook((InputStream)file);
            XSSFSheet newSheet = wb.createSheet("newSheet");
            newSheet.createRow(1);
            newSheet.getRow(1).createCell(1);
            newSheet.getRow(1).getCell(1).setCellValue(this.fileModel.getContent());
            FileOutputStream fileOut = new FileOutputStream(new File(resourcePath));
            wb.write((OutputStream)fileOut);
            fileOut.close();
            wb.close();
        }
        if (FileType.fromName((String)resourcePath).equals((Object)FileType.MSPOWERPOINT) || FileType.fromName((String)resourcePath).equals((Object)FileType.MSPOWERPOINT2007)) {
            XMLSlideShow ppt = new XMLSlideShow((InputStream)new FileInputStream(resourcePath));
            XSLFSlideMaster slideMaster = (XSLFSlideMaster)ppt.getSlideMasters().get(0);
            XSLFSlideLayout titleLayout = slideMaster.getLayout(SlideLayout.TITLE);
            XSLFSlide newSlide = ppt.createSlide(titleLayout);
            XSLFTextShape title1 = newSlide.getPlaceholder(0);
            title1.setText(this.fileModel.getContent());
            FileOutputStream fileOut = new FileOutputStream(new File(resourcePath));
            ppt.write((OutputStream)fileOut);
            fileOut.close();
            ppt.close();
        }
        return this;
    }

    public AOSWrapper moveTo(ContentModel destination) throws Exception {
        String fileName = new File(this.getLastResourceWithoutPrefix()).getName();
        String fileDestination = this.buildPath(destination.getCmisLocation(), fileName);
        if (Files.isRegularFile(Paths.get(this.getAosLocation(), new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            this.aosNetworkDrive.inOSEnvironment().moveFile(this.getLastResourceWithoutPrefix(), fileDestination);
        } else {
            this.aosNetworkDrive.inOSEnvironment().moveFolder(this.getLastResourceWithoutPrefix(), fileDestination);
        }
        this.setLastResource(fileDestination);
        this.setAosLocation(this.getPrefixSpace() + this.getLastResource());
        this.dataContent.waitUntilContentIsCreatedInLinux(this.getLastResource());
        return this;
    }

    public AOSWrapper httpMoveTo(ContentModel destination) throws IOException {
        String sourceUrl = this.aosProperties.getAosLinuxNetwork() + this.getLastResource();
        String destinationUrl = this.aosProperties.getAosLinuxNetwork() + destination.getCmisLocation();
        String unhashedString = String.format("%s:%s", this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword());
        String basicAuth = "Basic " + new String(new Base64().encode(unhashedString.getBytes()));
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpUriRequest moveRequest = RequestBuilder.create((String)"MOVE").setUri(sourceUrl).addHeader("Overwrite", "F").addHeader("Destination", destinationUrl).addHeader("Authorization", basicAuth).build();
        CloseableHttpResponse response = httpclient.execute(moveRequest);
        this.status = response.getStatusLine().getStatusCode();
        return this;
    }

    protected String getProtocolJMXConfigurationStatus() throws Exception {
        return this.withJMX().getAOSServerConfigurationStatus();
    }

    public AOSWrapper authenticateUser(UserModel userModel) throws Exception {
        this.setTestUser(userModel);
        return this;
    }

    public AOSWrapper disconnect() throws Exception {
        this.setTestUser(new UserModel());
        return this;
    }

    public AOSWrapper usingSite(String siteId) throws Exception {
        Step.STEP((String)String.format("AOS: Navigate to site '%s/documentLibrary/'", siteId));
        Utility.checkObjectIsInitialized((Object)siteId, (String)"SiteID");
        this.setCurrentSpace(this.buildSiteDocumentLibraryPath(siteId, new String[]{""}));
        this.setAosLocation(this.buildPath(this.getPrefixSpace(), this.getLastResource()));
        this.setActionExecutedOnMappedDrive(false);
        return this;
    }

    public AOSWrapper usingSite(SiteModel siteModel) throws Exception {
        Utility.checkObjectIsInitialized((Object)siteModel, (String)"SiteModel");
        this.usingSite(siteModel.getId());
        return this;
    }

    public AOSWrapper usingRoot() throws TestConfigurationException, Exception {
        this.setCurrentSpace(this.getRootPath());
        this.setAosLocation(this.buildPath(this.getPrefixSpace(), this.getRootPath()));
        return this;
    }

    public AOSWrapper usingUserHome(String username) throws Exception {
        return null;
    }

    public AOSWrapper usingUserHome() throws Exception {
        return null;
    }

    public String getRootPath() throws TestConfigurationException {
        return String.format("/", new Object[0]);
    }

    public String getSitesPath() throws TestConfigurationException {
        return String.format("%s%s", this.getRootPath(), "Sites");
    }

    public String getUserHomesPath() throws TestConfigurationException {
        return String.format("%s%s", this.getRootPath(), "User Homes");
    }

    public String getDataDictionaryPath() throws TestConfigurationException {
        return String.format("%s%s", this.getRootPath(), "Data Dictionary");
    }

    public String getPrefixSpace() {
        String prefixSpace = "";
        if (SystemUtils.IS_OS_WINDOWS) {
            prefixSpace = "Y:";
        } else if (SystemUtils.IS_OS_LINUX) {
            prefixSpace = "/mnt/alfrescoAos";
        } else if (SystemUtils.IS_OS_MAC) {
            prefixSpace = "/data/alfrescoAos";
        }
        return prefixSpace;
    }

    public AOSWrapper usingResource(ContentModel model) throws Exception {
        this.setLastContentModel(model);
        Step.STEP((String)String.format("AOS: Navigate to '%s'", model.getName()));
        this.setCurrentSpace(model.getCmisLocation());
        this.setAosLocation(this.buildPath(this.getPrefixSpace(), model.getCmisLocation()));
        return this;
    }

    public AOSAssertion assertThat() {
        return new AOSAssertion(this);
    }

    public JmxUtil withJMX() {
        return new JmxUtil(this, this.jmxBuilder.getJmxClient());
    }

    public AOSWrapper usingNetworkDrive() throws Exception {
        Step.STEP((String)String.format("AOS: map a drive", new Object[0]));
        if (!this.aosNetworkDrive.inOSEnvironment().isNetworkDriveMounted()) {
            this.aosNetworkDrive.inOSEnvironment().mount();
        }
        return this;
    }

    public AOSWrapper unmountNetworkDrive() throws Exception {
        Step.STEP((String)String.format("AOS: unmount a drive", new Object[0]));
        if (this.aosNetworkDrive.inOSEnvironment().isNetworkDriveMounted()) {
            this.aosNetworkDrive.inOSEnvironment().unount();
        }
        return this;
    }

    public String getContent(String filePath) throws TestConfigurationException, IOException {
        FileInputStream fileStream = new FileInputStream(filePath);
        String content = "";
        if (this.getFileType().equals((Object)FileType.MSWORD) || this.getFileType().equals((Object)FileType.MSWORD2007)) {
            XWPFDocument document = new XWPFDocument((InputStream)fileStream);
            XWPFWordExtractor wordExtractor = new XWPFWordExtractor(document);
            content = wordExtractor.getText().trim();
            wordExtractor.close();
        }
        if (this.getFileType().equals((Object)FileType.MSEXCEL2007) || this.getFileType().equals((Object)FileType.MSEXCEL)) {
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)fileStream);
            XSSFSheet worksheet = workbook.getSheetAt(0);
            XSSFRow row1 = worksheet.getRow(1);
            XSSFCell cell1 = row1.getCell(1);
            content = cell1.getStringCellValue();
            workbook.close();
        }
        if (this.getFileType().equals((Object)FileType.MSPOWERPOINT) || this.getFileType().equals((Object)FileType.MSPOWERPOINT2007)) {
            XMLSlideShow powerPoint = new XMLSlideShow((InputStream)fileStream);
            XSLFShape shape = (XSLFShape)((XSLFSlide)powerPoint.getSlides().get(0)).getShapes().get(0);
            if (shape instanceof XSLFTextShape) {
                String text;
                XSLFTextShape textShape = (XSLFTextShape)shape;
                content = text = textShape.getText();
            }
            powerPoint.close();
        }
        return content;
    }

    public String getDefaultFileContent() {
        return this.content;
    }

    public void setDefaultFileContent(String content) {
        this.content = content;
    }

    public void setFileModel(FileModel fileModel) {
        this.fileModel = fileModel;
    }

    public FileModel getFileModel() {
        return this.fileModel;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public void setFileType(FileType fileType) {
        this.fileType = fileType;
    }

    public String getAosLocation() {
        return this.aosLocation;
    }

    public void setAosLocation(String aosLocation) {
        LOG.info(String.format("Set AOS location to '%s'", aosLocation));
        this.aosLocation = aosLocation;
    }

    public AOSWrapper checkOutDocument() throws InterruptedException {
        Document document = this.dataContent.getCMISDocument(this.getLastResource());
        document.checkOut();
        return this;
    }

    public AOSWrapper cancelCheckOutDocument() throws InterruptedException {
        Document document = this.dataContent.getCMISDocument(this.getLastResource());
        document.cancelCheckOut();
        return this;
    }

    public static enum Content {
        ADD,
        DELETE;

    }
}

