/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.aos;

import org.alfresco.aos.AOSTest;
import org.alfresco.aos.AOSWrapper;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AosFolderCoreTests
extends AOSTest {
    private UserModel testUser;
    private FolderModel folderModel;
    private SiteModel moderatedSite;
    private SiteModel publicSite;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.publicSite = this.dataSite.createPublicRandomSite();
        this.moderatedSite = this.dataSite.createModeratedRandomSite();
        this.testUser = this.dataUser.getAdminUser();
        this.folderModel = FolderModel.getRandomFolderModel();
        this.aosProtocol.authenticateUser(this.testUser);
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Copy empty folder in AOS network drive")
    @Test(groups={"protocols", "aos", "core"})
    public void copyEmptyFolder() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.moderatedSite).createFolder(this.folderModel).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
        FolderModel newFolder = FolderModel.getRandomFolderModel();
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.publicSite).createFolder(newFolder).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingResource((ContentModel)this.folderModel).copyTo((ContentModel)newFolder).and()).assertThat().existsInRepo()).assertThat().fileExistsInAOS();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="Move empty folder in AOS network drive")
    @Test(groups={"protocols", "aos", "core"})
    public void moveEmptyFolder() throws Exception {
        FolderModel folder = FolderModel.getRandomFolderModel();
        folder.setName("testfolder");
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.moderatedSite).createFolder(folder).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
        FolderModel newFolder = FolderModel.getRandomFolderModel();
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.publicSite).createFolder(newFolder).and()).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS();
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingResource((ContentModel)folder).moveTo((ContentModel)newFolder).and()).assertThat().existsInRepo()).assertThat().fileExistsInAOS();
        ((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingResource((ContentModel)folder).assertThat().fileDoesNotExistInAOS().assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.REGRESSION}, description="User is able to create several files and folders in AOS network drive")
    @Test(groups={"protocols", "aos", "core"})
    public void createSeveralFilesAndFoldersInAosNetworkDrive() throws Exception {
        FolderModel folder1 = FolderModel.getRandomFolderModel();
        FolderModel folder2 = FolderModel.getRandomFolderModel();
        FileModel file1 = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        FileModel file2 = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        FileModel file3 = FileModel.getRandomFileModel((FileType)FileType.MSPOWERPOINT);
        FileModel file4 = FileModel.getRandomFileModel((FileType)FileType.MSWORD2007);
        FileModel file5 = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL2007);
        FileModel file6 = FileModel.getRandomFileModel((FileType)FileType.MSPOWERPOINT2007);
        ((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.publicSite).createFolder(folder1).usingSite(this.publicSite).createFolder(folder2).createFile(file3).usingResource((ContentModel)folder1).createFile(file4).usingSite(this.publicSite).createFile(file1).usingSite(this.publicSite).createFile(file2).usingSite(this.publicSite).createFile(file5).usingSite(this.publicSite).createFile(file6);
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingNetworkDrive().usingResource((ContentModel)folder1).assertThat().fileExistsInAOS().and()).assertThat().existsInRepo()).then()).usingResource((ContentModel)folder2).assertThat().fileExistsInAOS().and()).assertThat().existsInRepo()).then()).usingResource((ContentModel)file3).assertThat().fileExistsInAOS().and()).assertThat().existsInRepo()).then()).usingResource((ContentModel)file1).assertThat().fileExistsInAOS().and()).assertThat().existsInRepo()).then()).usingResource((ContentModel)file2).assertThat().fileExistsInAOS().and()).assertThat().existsInRepo()).then()).usingResource((ContentModel)file4).assertThat().fileExistsInAOS().and()).assertThat().existsInRepo()).then()).usingResource((ContentModel)file5).assertThat().fileExistsInAOS().and()).assertThat().existsInRepo()).then()).usingResource((ContentModel)file6).assertThat().fileExistsInAOS().and()).assertThat().existsInRepo();
    }
}

