/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.aos;

import org.alfresco.aos.AOSTest;
import org.alfresco.aos.AOSWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MSExcel2007SanityTests
extends AOSTest {
    private UserModel testUser;
    private FileModel fileModel;
    private String updatedContent = "updatedContent";
    private FolderModel folderModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testSite = this.dataSite.createPublicRandomSite();
        this.testUser = this.dataUser.getAdminUser();
        this.aosProtocol.authenticateUser(this.testUser);
        this.folderModel = FolderModel.getRandomFolderModel();
    }

    @BeforeMethod(alwaysRun=true)
    public void createFileModel() throws Exception {
        this.fileModel = new FileModel(RandomData.getRandomFile((FileType)FileType.MSEXCEL2007), FileType.MSEXCEL2007, RandomData.getRandomName((String)"fileContent"));
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify content of  excel file after saving it and no content was added")
    @Test(groups={"protocols", "aos", "sanity"})
    public void saveExcel2007DocumentWithoutAnyChanges() throws Exception {
        String newContent = "";
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).update(newContent).then()).assertThat().contentIs(this.fileModel.getContent());
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify admin user renames MSEXCEL2007 file with AOS Protocol")
    @Test(groups={"protocols", "aos", "sanity"})
    public void adminIsAbleToRenameExcel2007File() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).assertThat().existsInRepo()).then()).rename(RandomData.getRandomFile((FileType)FileType.MSEXCEL2007)).assertThat().existsInRepo()).and()).assertThat().fileExistsInAOS().usingResource((ContentModel)this.fileModel).assertThat().doesNotExistInRepo()).and()).assertThat().fileDoesNotExistInAOS();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify admin user deletes MSEXCEL2007 file with AOS Protocol")
    @Test(groups={"protocols", "aos", "sanity"})
    public void adminIsAbleToDeleteExcel2007File() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).assertThat().existsInRepo()).then()).delete().and()).assertThat().doesNotExistInRepo()).and()).assertThat().fileDoesNotExistInAOS();
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify admin can update existing excel document")
    @Test(groups={"protocols", "aos", "sanity"})
    public void updateExistingExcel2007DocumentWithAdmin() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingRoot().createFile(this.fileModel).and()).update(this.updatedContent).then()).assertThat().contentIs(this.fileModel.getContent() + this.updatedContent);
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify admin can update excel document from Document Library")
    @Test(groups={"protocols", "aos", "sanity"})
    public void updateExcel2007FileFromDocumentLibray() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingSite(this.testSite).usingNetworkDrive().createFile(this.fileModel).and()).assertThat().existsInRepo()).and()).update(this.updatedContent).then()).assertThat().contentIs(this.fileModel.getContent() + this.updatedContent);
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify site manager can update excel document")
    @Test(groups={"protocols", "aos", "sanity"})
    public void updateExcel2007DocumentWithManagerRole() throws Exception {
        UserModel siteManager = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(siteManager, this.testSite, UserRole.SiteManager);
        this.aosProtocol.authenticateUser(siteManager);
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingSite(this.testSite).usingNetworkDrive().createFile(this.fileModel).and()).assertThat().existsInRepo()).and()).update(this.updatedContent).then()).assertThat().contentIs(this.fileModel.getContent() + this.updatedContent);
    }

    @TestRail(section={"protocols", "aos"}, executionType={ExecutionType.SANITY}, description="Verify that admin can create excel document in folder hierarchy")
    @Test(groups={"protocols", "aos", "sanity"})
    public void adminIsAbleToCreateExcel2007FileInFolderHierarchy() throws Exception {
        ((AOSWrapper)((AOSWrapper)((AOSWrapper)((AOSWrapper)this.aosProtocol.usingAdmin()).usingNetworkDrive().usingSite(this.testSite).createFolder(this.folderModel).then()).createFolder(this.folderModel).then()).createFile(this.fileModel).then()).assertThat().existsInRepo();
    }
}

