/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.aos.dsl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.aos.AOSWrapper;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.dsl.DSLAssertion;
import org.alfresco.utility.dsl.DSLProtocol;
import org.alfresco.utility.exception.TestConfigurationException;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.report.log.Step;
import org.apache.chemistry.opencmis.client.api.SecondaryType;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.Assert;

public class AOSAssertion
extends DSLAssertion<AOSWrapper> {
    @Autowired
    DataContent content;

    public AOSAssertion(AOSWrapper aosWrapper) {
        super((DSLProtocol)aosWrapper);
    }

    public AOSWrapper aosWrapper() {
        return (AOSWrapper)((Object)this.getProtocol());
    }

    public AOSWrapper fileExistsInAOS() throws TestConfigurationException {
        String contentName = new File(this.aosWrapper().getAosLocation()).getPath();
        Step.STEP((String)String.format("Verify that content '%s' exists in AOS", contentName));
        Assert.assertTrue((boolean)this.aosWrapper().withAosUtil().contentExistsInAos(contentName), (String)String.format("File %s does not exist in AOS", contentName));
        return this.aosWrapper();
    }

    public AOSWrapper fileDoesNotExistInAOS() throws TestConfigurationException {
        String contentName = new File(this.aosWrapper().getAosLocation()).getPath();
        Step.STEP((String)String.format("Verify that content '%s' exists in AOS", contentName));
        Assert.assertFalse((boolean)this.aosWrapper().withAosUtil().contentExistsInAos(contentName), (String)String.format("File %s does not exist in AOS", contentName));
        return this.aosWrapper();
    }

    public AOSWrapper contentIs(String expectedContent) throws IOException, TestConfigurationException {
        Step.STEP((String)String.format("AOS: Assert current content is '%s'", expectedContent));
        String actualContent = this.aosWrapper().getContent(this.aosWrapper().getAosLocation());
        Assert.assertEquals((String)actualContent, (String)expectedContent, (String)String.format("Content for file %s is not the expected one.", ((AOSWrapper)((Object)this.getProtocol())).getLastResource()));
        return this.aosWrapper();
    }

    public AOSWrapper documentIsLocked() {
        Step.STEP((String)"AOS: Assert that document is locked for editing");
        List secondaryTypes = this.aosWrapper().withAosUtil().getCMISDocument().getSecondaryTypes();
        ArrayList<String> flags = new ArrayList<String>();
        for (int i = 0; i < secondaryTypes.size(); ++i) {
            flags.add(((SecondaryType)secondaryTypes.get(i)).getQueryName());
        }
        Assert.assertTrue((boolean)flags.contains("cm:lockable"), (String)"Document is not locked, missing secondary type flag 'lockable'");
        return this.aosWrapper();
    }

    public AOSWrapper newPageExistsAndContentIsValid() throws IOException, TestConfigurationException {
        String resourcePath = this.aosWrapper().getAosLocation();
        FileInputStream file = new FileInputStream(new File(resourcePath));
        if (FileType.fromName((String)resourcePath).equals((Object)FileType.MSWORD) || FileType.fromName((String)resourcePath).equals((Object)FileType.MSWORD2007)) {
            XWPFDocument document = new XWPFDocument((InputStream)file);
            XWPFParagraph paragraph = document.getLastParagraph();
            Assert.assertTrue((boolean)paragraph.isPageBreak(), (String)"No page break detected");
            document.close();
        }
        if (FileType.fromName((String)resourcePath).equals((Object)FileType.MSEXCEL) || FileType.fromName((String)resourcePath).equals((Object)FileType.MSEXCEL2007)) {
            XSSFWorkbook wb = new XSSFWorkbook((InputStream)file);
            XSSFRow row1 = wb.getSheetAt(1).getRow(1);
            XSSFCell cell1 = row1.getCell(1);
            Assert.assertEquals((int)wb.getNumberOfSheets(), (int)2, (String)"Number of sheets is not correct");
            Assert.assertEquals((String)wb.getSheetAt(1).getSheetName(), (String)"newSheet", (String)"Sheet name is not correct");
            Assert.assertEquals((String)cell1.getStringCellValue(), (String)this.aosWrapper().getDefaultFileContent(), (String)"Sheet content is not correct");
            wb.close();
        }
        if (FileType.fromName((String)resourcePath).equals((Object)FileType.MSPOWERPOINT) || FileType.fromName((String)resourcePath).equals((Object)FileType.MSPOWERPOINT2007)) {
            XMLSlideShow powerPoint = new XMLSlideShow((InputStream)file);
            XSLFShape shape = (XSLFShape)((XSLFSlide)powerPoint.getSlides().get(1)).getShapes().get(0);
            if (shape instanceof XSLFTextShape) {
                XSLFTextShape textShape = (XSLFTextShape)shape;
                String text = textShape.getText();
                Assert.assertEquals((String)text, (String)this.aosWrapper().getDefaultFileContent(), (String)"Slide content is not correct");
            }
            Assert.assertEquals((int)powerPoint.getSlides().size(), (int)2, (String)"Number of slides is not correct");
            powerPoint.close();
        }
        return this.aosWrapper();
    }

    public AOSWrapper hasStatus(int status) {
        Assert.assertEquals((int)this.aosWrapper().withAosUtil().getStatus(), (int)status, (String)String.format("Verify status", new Object[0]));
        return this.aosWrapper();
    }
}

